/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class AddGroupTest
extends CrowdAcceptanceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("searchdirectories.xml");
    }

    public void testAddGroupWithNoDetails() {
        this.log("Running testAddGroupWithNoDetails");
        this.gotoAddGroup();
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.selectOptionByValue("directoryID", "-1");
        this.submit();
        this.assertKeyPresent("group.name.invalid");
        this.assertKeyPresent("group.directory.invalid");
    }

    public void testAddGroupThatAlreadyExists() {
        this.log("Running testAddGroupThatAlreadyExists");
        this.gotoAddGroup();
        this.setTextField("name", "crowd-administrators");
        this.setTextField("description", "Crowd Administrators");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("invalid.namealreadyexist");
    }

    public void testAddGroupToInternalDirectory() {
        this.log("Running testAddGroupToInternalDirectory");
        this.gotoAddGroup();
        this.setTextField("name", "test-group");
        this.setTextField("description", "Crowd Test Group");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("test-group");
    }

    public void testAddGroupToInternalDirectoryMixedCaseName() {
        this.log("Running testAddGroupToInternalDirectoryInvalidName");
        this.gotoAddGroup();
        this.setTextField("name", "Test-Group");
        this.setTextField("description", "");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("Test-Group");
    }

    public void testAddGroupToLDAPMixedCaseName() {
        this.log("Running testAddGroupToLDAPMixedCaseName");
        this.gotoAddGroup();
        this.setTextField("name", "Test-MixedCase");
        this.setTextField("description", "");
        this.selectOption("directoryID", "Apache DS");
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("Test-MixedCase");
    }
}

