/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.directory.ApacheDS;
import com.atlassian.crowd.directory.GenericLDAP;

public class AddDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String INTERNAL_DIRECTORY_NAME = "Second Internal Directory";
    private static final String INTERNAL_DIRECTORY_DESCRIPTION = "Second Internal Directory Description";
    private static final String CROWD_DIRECTORY_NAME = "Test Remote Crowd Directory";
    private static final String CROWD_DIRECTORY_DESCRIPTION = "Test Remote Crowd Directory Description";
    private static final String CONNECTOR_DIRECTORY_NAME = "Test Connector Directory";
    private static final String CONNECTOR_DIRECTORY_DESCRIPTION = "Test Connector Directory Description";
    private static final String CUSTOM_DIRECTORY_NAME = "Test Custom Remote Directory";
    private static final String DELEGATED_DIRECTORY_NAME = "Test Delegated Remote Directory";
    private static final String DELEGATED_DIRECTORY_DESCRIPTION = "Test Delegated Remote Directory Description";
    private static final String BAD_CLASS_NAME = "com.atlassian.crowd.integration.connector.ApacheDS";

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testAddInternalDirectory() {
        this.gotoCreateDirectory();
        this.clickButton("create-internal");
        this.assertKeyPresent("directoryinternalcreate.title");
        this.setWorkingForm("directoryinternal");
        this.setTextField("name", INTERNAL_DIRECTORY_NAME);
        this.setTextField("description", INTERNAL_DIRECTORY_DESCRIPTION);
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
        this.assertTextFieldEquals("name", INTERNAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", INTERNAL_DIRECTORY_DESCRIPTION);
        this.assertTextPresent("Crowd Internal Directory");
    }

    public void testAddRemoteCrowdDirectory() {
        this.gotoCreateDirectory();
        this.clickButton("create-crowd");
        this.assertKeyPresent("directorycrowdcreate.title");
        this.setWorkingForm("directorycrowd");
        this.setTextField("name", CROWD_DIRECTORY_NAME);
        this.setTextField("description", CROWD_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connection");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "demo");
        this.setTextField("applicationPassword", "password");
        this.setTextField("pollingIntervalInMin", "60");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CROWD_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CROWD_DIRECTORY_DESCRIPTION);
        this.clickLink("crowd-connectiondetails");
        this.assertTextFieldEquals("url", this.getBaseUrl());
        this.assertTextFieldEquals("applicationName", "demo");
        this.assertTextFieldEquals("pollingIntervalInMin", "60");
    }

    public void testAddInactiveRemoteCrowdDirectory() {
        this.gotoCreateDirectory();
        this.clickButton("create-crowd");
        this.assertKeyPresent("directorycrowdcreate.title");
        this.setWorkingForm("directorycrowd");
        this.setTextField("name", CROWD_DIRECTORY_NAME);
        this.setTextField("description", CROWD_DIRECTORY_DESCRIPTION);
        this.uncheckCheckbox("active");
        this.clickLinkWithExactText("Connection");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "demo");
        this.setTextField("applicationPassword", "password");
        this.setTextField("pollingIntervalInMin", "60");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertElementNotPresent("lastsyncinfo");
        this.assertButtonNotPresent("synchroniseDirectoryButton");
    }

    public void testAddRemoteCrowdDirectoryWithVariousOptions() {
        this.gotoCreateDirectory();
        this.clickButton("create-crowd");
        this.assertKeyPresent("directorycrowdcreate.title");
        this.setWorkingForm("directorycrowd");
        this.setTextField("name", CROWD_DIRECTORY_NAME);
        this.setTextField("description", CROWD_DIRECTORY_DESCRIPTION);
        this.assertCheckboxNotSelected("useNestedGroups");
        this.checkCheckbox("useNestedGroups");
        this.clickLinkWithExactText("Connection");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "demo");
        this.setTextField("applicationPassword", "password");
        this.setTextField("pollingIntervalInMin", "60");
        this.setTextField("httpTimeout", "12");
        this.setTextField("httpMaxConnections", "123");
        this.setTextField("httpProxyPort", "5432");
        this.setTextField("httpProxyUsername", "proxyuser");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.assertCheckboxSelected("useNestedGroups");
        this.clickLinkWithExactText("Connection");
        this.assertTextFieldEquals("httpTimeout", "12");
        this.assertTextFieldEquals("httpMaxConnections", "123");
        this.assertTextFieldEquals("httpProxyPort", "5432");
        this.assertTextFieldEquals("httpProxyUsername", "proxyuser");
    }

    public void testAddConnectorDirectory() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.setTextField("readTimeoutInSec", "42000");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CONNECTOR_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertTextFieldEquals("readTimeoutInSec", "42000");
        this.assertTextFieldEquals("searchTimeoutInSec", "60");
        this.assertTextFieldEquals("connectionTimeoutInSec", "0");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "ou=groups");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
        this.assertCheckboxSelected("rolesDisabled");
    }

    public void testAddInactiveConnectorDirectory() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.uncheckCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.setTextField("readTimeoutInSec", "42000");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertElementNotPresent("lastsyncinfo");
        this.assertButtonNotPresent("synchroniseDirectoryButton");
    }

    public void testAddConnectorDirectoryWithPwdEncryption() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", GenericLDAP.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.selectOption("userEncryptionMethod", "MD5");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CONNECTOR_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.assertTextPresent(GenericLDAP.getStaticDirectoryType());
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "MD5");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "ou=groups");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
        this.assertCheckboxSelected("rolesDisabled");
    }

    public void testAddInternalDirectoryWithoutName() {
        this.gotoCreateDirectory();
        this.clickButton("create-internal");
        this.assertKeyPresent("directoryinternalcreate.title");
        this.setWorkingForm("directoryinternal");
        this.setTextField("name", "");
        this.setTextField("description", INTERNAL_DIRECTORY_DESCRIPTION);
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testAddConnectorDirectoryWithoutAttributesRolesDisabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "");
        this.setTextField("groupObjectClass", "");
        this.setTextField("groupObjectFilter", "");
        this.setTextField("groupNameAttr", "");
        this.setTextField("groupDescriptionAttr", "");
        this.setTextField("groupMemberAttr", "");
        this.setTextField("roleDNaddition", "");
        this.setTextField("roleObjectClass", "");
        this.setTextField("roleObjectFilter", "");
        this.setTextField("roleNameAttr", "");
        this.setTextField("roleDescriptionAttr", "");
        this.setTextField("roleMemberAttr", "");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userPasswordAttr", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.clickLinkWithExactText("Connector");
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid");
        this.clickLinkWithExactText("Configuration");
        this.assertKeyPresent("directoryconnector.groupobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.groupobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.groupname.invalid");
        this.assertKeyPresent("directoryconnector.groupmember.invalid");
        this.assertKeyPresent("directoryconnector.groupdescription.invalid");
        this.assertCheckboxSelected("rolesDisabled");
        this.assertKeyNotPresent("directoryconnector.rolednaddition.invalid");
        this.assertKeyNotPresent("directoryconnector.roleobjectclass.invalid");
        this.assertKeyNotPresent("directoryconnector.roleobjectfilter.invalid");
        this.assertKeyNotPresent("directoryconnector.rolename.invalid");
        this.assertKeyNotPresent("directoryconnector.rolemember.invalid");
        this.assertKeyNotPresent("directoryconnector.roledescription.invalid");
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userpassword.invalid");
    }

    public void testAddConnectorDirectoryWithoutAttributesRolesEnabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "");
        this.setTextField("groupObjectClass", "");
        this.setTextField("groupObjectFilter", "");
        this.setTextField("groupNameAttr", "");
        this.setTextField("groupDescriptionAttr", "");
        this.setTextField("groupMemberAttr", "");
        this.uncheckCheckbox("rolesDisabled");
        this.setTextField("roleDNaddition", "");
        this.setTextField("roleObjectClass", "");
        this.setTextField("roleObjectFilter", "");
        this.setTextField("roleNameAttr", "");
        this.setTextField("roleDescriptionAttr", "");
        this.setTextField("roleMemberAttr", "");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userPasswordAttr", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.clickLinkWithExactText("Connector");
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid");
        this.clickLinkWithExactText("Configuration");
        this.assertKeyPresent("directoryconnector.groupobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.groupobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.groupname.invalid");
        this.assertKeyPresent("directoryconnector.groupmember.invalid");
        this.assertKeyPresent("directoryconnector.groupdescription.invalid");
        this.assertCheckboxNotSelected("rolesDisabled");
        this.assertKeyPresent("directoryconnector.roleobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.roleobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.rolename.invalid");
        this.assertKeyPresent("directoryconnector.rolemember.invalid");
        this.assertKeyPresent("directoryconnector.roledescription.invalid");
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userpassword.invalid");
    }

    public void testAddConnectorDirectoryWithAllValidExceptOverlappedRolesGroupDN() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.uncheckCheckbox("rolesDisabled");
        this.setTextField("groupDNaddition", "");
        this.setTextField("roleDNaddition", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.rolednaddition.invalid");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("roleDNaddition", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.rolednaddition.invalid");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("roleDNaddition", "ou=roles");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CONNECTOR_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "ou=groups");
        this.assertTextFieldEquals("roleDNaddition", "ou=roles");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
        this.assertCheckboxNotSelected("rolesDisabled");
    }

    public void testAddConnectorDirectoryWithSpecificAttributesRolesEnabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "1");
        this.setTextField("description", "2");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "7");
        this.setTextField("groupObjectClass", "8");
        this.setTextField("groupObjectFilter", "9");
        this.setTextField("groupNameAttr", "10");
        this.setTextField("groupDescriptionAttr", "11");
        this.setTextField("groupMemberAttr", "12");
        this.uncheckCheckbox("rolesDisabled");
        this.setTextField("roleDNaddition", "13");
        this.setTextField("roleObjectClass", "14");
        this.setTextField("roleObjectFilter", "15");
        this.setTextField("roleNameAttr", "16");
        this.setTextField("roleDescriptionAttr", "17");
        this.setTextField("roleMemberAttr", "18");
        this.setTextField("userDNaddition", "19");
        this.setTextField("userObjectClass", "20");
        this.setTextField("userObjectFilter", "21");
        this.setTextField("userNameAttr", "22");
        this.setTextField("userFirstnameAttr", "23");
        this.setTextField("userLastnameAttr", "24");
        this.setTextField("userMailAttr", "25");
        this.setTextField("userGroupMemberAttr", "26");
        this.setTextField("userPasswordAttr", "27");
        this.submit();
        this.assertWarningNotPresent();
        this.assertErrorNotPresent();
        this.assertTextFieldEquals("name", "1");
        this.assertTextFieldEquals("directoryDescription", "2");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "7");
        this.assertTextFieldEquals("groupObjectClass", "8");
        this.assertTextFieldEquals("groupObjectFilter", "9");
        this.assertTextFieldEquals("groupNameAttr", "10");
        this.assertTextFieldEquals("groupDescriptionAttr", "11");
        this.assertTextFieldEquals("groupMemberAttr", "12");
        this.assertCheckboxNotSelected("rolesDisabled");
        this.assertTextFieldEquals("roleDNaddition", "13");
        this.assertTextFieldEquals("roleObjectClass", "14");
        this.assertTextFieldEquals("roleObjectFilter", "15");
        this.assertTextFieldEquals("roleNameAttr", "16");
        this.assertTextFieldEquals("roleDescriptionAttr", "17");
        this.assertTextFieldEquals("roleMemberAttr", "18");
        this.assertTextFieldEquals("userDNaddition", "19");
        this.assertTextFieldEquals("userObjectClass", "20");
        this.assertTextFieldEquals("userObjectFilter", "21");
        this.assertTextFieldEquals("userNameAttr", "22");
        this.assertTextFieldEquals("userFirstnameAttr", "23");
        this.assertTextFieldEquals("userLastnameAttr", "24");
        this.assertTextFieldEquals("userMailAttr", "25");
        this.assertTextFieldEquals("userGroupMemberAttr", "26");
        this.assertTextFieldEquals("userPasswordAttr", "27");
    }

    public void testAddConnectorDirectoryWithUseUserMembershipAttributeRolesEnabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "1");
        this.setTextField("description", "2");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.checkCheckbox("useUserMembershipAttribute");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "7");
        this.setTextField("groupObjectClass", "8");
        this.setTextField("groupObjectFilter", "9");
        this.setTextField("groupNameAttr", "10");
        this.setTextField("groupDescriptionAttr", "11");
        this.setTextField("groupMemberAttr", "12");
        this.uncheckCheckbox("rolesDisabled");
        this.setTextField("roleDNaddition", "13");
        this.setTextField("roleObjectClass", "14");
        this.setTextField("roleObjectFilter", "15");
        this.setTextField("roleNameAttr", "16");
        this.setTextField("roleDescriptionAttr", "17");
        this.setTextField("roleMemberAttr", "18");
        this.setTextField("userDNaddition", "19");
        this.setTextField("userObjectClass", "20");
        this.setTextField("userObjectFilter", "21");
        this.setTextField("userNameAttr", "22");
        this.setTextField("userFirstnameAttr", "23");
        this.setTextField("userLastnameAttr", "24");
        this.setTextField("userMailAttr", "25");
        this.setTextField("userGroupMemberAttr", "26");
        this.setTextField("userPasswordAttr", "27");
        this.submit();
        this.assertWarningNotPresent();
        this.assertErrorNotPresent();
        this.assertTextFieldEquals("name", "1");
        this.assertTextFieldEquals("directoryDescription", "2");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("useUserMembershipAttribute");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "7");
        this.assertTextFieldEquals("groupObjectClass", "8");
        this.assertTextFieldEquals("groupObjectFilter", "9");
        this.assertTextFieldEquals("groupNameAttr", "10");
        this.assertTextFieldEquals("groupDescriptionAttr", "11");
        this.assertTextFieldEquals("groupMemberAttr", "12");
        this.assertCheckboxNotSelected("rolesDisabled");
        this.assertTextFieldEquals("roleDNaddition", "13");
        this.assertTextFieldEquals("roleObjectClass", "14");
        this.assertTextFieldEquals("roleObjectFilter", "15");
        this.assertTextFieldEquals("roleNameAttr", "16");
        this.assertTextFieldEquals("roleDescriptionAttr", "17");
        this.assertTextFieldEquals("roleMemberAttr", "18");
        this.assertTextFieldEquals("userDNaddition", "19");
        this.assertTextFieldEquals("userObjectClass", "20");
        this.assertTextFieldEquals("userObjectFilter", "21");
        this.assertTextFieldEquals("userNameAttr", "22");
        this.assertTextFieldEquals("userFirstnameAttr", "23");
        this.assertTextFieldEquals("userLastnameAttr", "24");
        this.assertTextFieldEquals("userMailAttr", "25");
        this.assertTextFieldEquals("userGroupMemberAttr", "26");
        this.assertTextFieldEquals("userPasswordAttr", "27");
    }

    public void testAddConnectorDirectoryWithUseUserMembershipAttributeRolesDisabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "1");
        this.setTextField("description", "2");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.checkCheckbox("useUserMembershipAttribute");
        this.setTextField("groupDNaddition", "7");
        this.setTextField("groupObjectClass", "8");
        this.setTextField("groupObjectFilter", "9");
        this.setTextField("groupNameAttr", "10");
        this.setTextField("groupDescriptionAttr", "11");
        this.setTextField("groupMemberAttr", "12");
        this.setTextField("roleDNaddition", "13");
        this.setTextField("roleObjectClass", "14");
        this.setTextField("roleObjectFilter", "15");
        this.setTextField("roleNameAttr", "16");
        this.setTextField("roleDescriptionAttr", "17");
        this.setTextField("roleMemberAttr", "18");
        this.setTextField("userDNaddition", "19");
        this.setTextField("userObjectClass", "20");
        this.setTextField("userObjectFilter", "21");
        this.setTextField("userNameAttr", "22");
        this.setTextField("userFirstnameAttr", "23");
        this.setTextField("userLastnameAttr", "24");
        this.setTextField("userMailAttr", "25");
        this.setTextField("userGroupMemberAttr", "26");
        this.setTextField("userPasswordAttr", "27");
        this.submit();
        this.assertWarningNotPresent();
        this.assertErrorNotPresent();
        this.assertTextFieldEquals("name", "1");
        this.assertTextFieldEquals("directoryDescription", "2");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("useUserMembershipAttribute");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "7");
        this.assertTextFieldEquals("groupObjectClass", "8");
        this.assertTextFieldEquals("groupObjectFilter", "9");
        this.assertTextFieldEquals("groupNameAttr", "10");
        this.assertTextFieldEquals("groupDescriptionAttr", "11");
        this.assertTextFieldEquals("groupMemberAttr", "12");
        this.assertTextFieldEquals("userDNaddition", "19");
        this.assertTextFieldEquals("userObjectClass", "20");
        this.assertTextFieldEquals("userObjectFilter", "21");
        this.assertTextFieldEquals("userNameAttr", "22");
        this.assertTextFieldEquals("userFirstnameAttr", "23");
        this.assertTextFieldEquals("userLastnameAttr", "24");
        this.assertTextFieldEquals("userMailAttr", "25");
        this.assertTextFieldEquals("userGroupMemberAttr", "26");
        this.assertTextFieldEquals("userPasswordAttr", "27");
        this.assertCheckboxSelected("rolesDisabled");
        this.assertKeyNotPresent("directoryconnector.rolednaddition.invalid");
        this.assertKeyNotPresent("directoryconnector.roleobjectclass.invalid");
        this.assertKeyNotPresent("directoryconnector.roleobjectfilter.invalid");
        this.assertKeyNotPresent("directoryconnector.rolename.invalid");
        this.assertKeyNotPresent("directoryconnector.rolemember.invalid");
        this.assertKeyNotPresent("directoryconnector.roledescription.invalid");
    }

    public void testAddConnectorDirectoryWithUseUserMembershipAttributeForGroupMembershipRolesEnabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "1");
        this.setTextField("description", "2");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.checkCheckbox("useUserMembershipAttributeForGroupMembership");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "7");
        this.setTextField("groupObjectClass", "8");
        this.setTextField("groupObjectFilter", "9");
        this.setTextField("groupNameAttr", "10");
        this.setTextField("groupDescriptionAttr", "11");
        this.setTextField("groupMemberAttr", "12");
        this.uncheckCheckbox("rolesDisabled");
        this.setTextField("roleDNaddition", "13");
        this.setTextField("roleObjectClass", "14");
        this.setTextField("roleObjectFilter", "15");
        this.setTextField("roleNameAttr", "16");
        this.setTextField("roleDescriptionAttr", "17");
        this.setTextField("roleMemberAttr", "18");
        this.setTextField("userDNaddition", "19");
        this.setTextField("userObjectClass", "20");
        this.setTextField("userObjectFilter", "21");
        this.setTextField("userNameAttr", "22");
        this.setTextField("userFirstnameAttr", "23");
        this.setTextField("userLastnameAttr", "24");
        this.setTextField("userMailAttr", "25");
        this.setTextField("userGroupMemberAttr", "26");
        this.setTextField("userPasswordAttr", "27");
        this.submit();
        this.assertWarningNotPresent();
        this.assertErrorNotPresent();
        this.assertTextFieldEquals("name", "1");
        this.assertTextFieldEquals("directoryDescription", "2");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxNotSelected("useUserMembershipAttribute");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "7");
        this.assertTextFieldEquals("groupObjectClass", "8");
        this.assertTextFieldEquals("groupObjectFilter", "9");
        this.assertTextFieldEquals("groupNameAttr", "10");
        this.assertTextFieldEquals("groupDescriptionAttr", "11");
        this.assertTextFieldEquals("groupMemberAttr", "12");
        this.assertCheckboxNotSelected("rolesDisabled");
        this.assertTextFieldEquals("roleDNaddition", "13");
        this.assertTextFieldEquals("roleObjectClass", "14");
        this.assertTextFieldEquals("roleObjectFilter", "15");
        this.assertTextFieldEquals("roleNameAttr", "16");
        this.assertTextFieldEquals("roleDescriptionAttr", "17");
        this.assertTextFieldEquals("roleMemberAttr", "18");
        this.assertTextFieldEquals("userDNaddition", "19");
        this.assertTextFieldEquals("userObjectClass", "20");
        this.assertTextFieldEquals("userObjectFilter", "21");
        this.assertTextFieldEquals("userNameAttr", "22");
        this.assertTextFieldEquals("userFirstnameAttr", "23");
        this.assertTextFieldEquals("userLastnameAttr", "24");
        this.assertTextFieldEquals("userMailAttr", "25");
        this.assertTextFieldEquals("userGroupMemberAttr", "26");
        this.assertTextFieldEquals("userPasswordAttr", "27");
    }

    public void testAddConnectorDirectoryWithUseUserMembershipAttributeForGroupMembershipRolesDisabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "1");
        this.setTextField("description", "2");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.checkCheckbox("useUserMembershipAttributeForGroupMembership");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "7");
        this.setTextField("groupObjectClass", "8");
        this.setTextField("groupObjectFilter", "9");
        this.setTextField("groupNameAttr", "10");
        this.setTextField("groupDescriptionAttr", "11");
        this.setTextField("groupMemberAttr", "12");
        this.setTextField("userDNaddition", "19");
        this.setTextField("userObjectClass", "20");
        this.setTextField("userObjectFilter", "21");
        this.setTextField("userNameAttr", "22");
        this.setTextField("userFirstnameAttr", "23");
        this.setTextField("userLastnameAttr", "24");
        this.setTextField("userMailAttr", "25");
        this.setTextField("userGroupMemberAttr", "26");
        this.setTextField("userPasswordAttr", "27");
        this.submit();
        this.assertWarningNotPresent();
        this.assertErrorNotPresent();
        this.assertTextFieldEquals("name", "1");
        this.assertTextFieldEquals("directoryDescription", "2");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxNotSelected("useUserMembershipAttribute");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "7");
        this.assertTextFieldEquals("groupObjectClass", "8");
        this.assertTextFieldEquals("groupObjectFilter", "9");
        this.assertTextFieldEquals("groupNameAttr", "10");
        this.assertTextFieldEquals("groupDescriptionAttr", "11");
        this.assertTextFieldEquals("groupMemberAttr", "12");
        this.assertTextFieldEquals("userDNaddition", "19");
        this.assertTextFieldEquals("userObjectClass", "20");
        this.assertTextFieldEquals("userObjectFilter", "21");
        this.assertTextFieldEquals("userNameAttr", "22");
        this.assertTextFieldEquals("userFirstnameAttr", "23");
        this.assertTextFieldEquals("userLastnameAttr", "24");
        this.assertTextFieldEquals("userMailAttr", "25");
        this.assertTextFieldEquals("userGroupMemberAttr", "26");
        this.assertTextFieldEquals("userPasswordAttr", "27");
        this.assertCheckboxSelected("rolesDisabled");
        this.assertKeyNotPresent("directoryconnector.rolednaddition.invalid");
        this.assertKeyNotPresent("directoryconnector.roleobjectclass.invalid");
        this.assertKeyNotPresent("directoryconnector.roleobjectfilter.invalid");
        this.assertKeyNotPresent("directoryconnector.rolename.invalid");
        this.assertKeyNotPresent("directoryconnector.rolemember.invalid");
        this.assertKeyNotPresent("directoryconnector.roledescription.invalid");
    }

    public void testAddConnectorDirectoryWithRolesEnabled() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", "");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("roleDNaddition", "ou=roles");
        this.setTextField("groupDNaddition", "ou=groups");
        this.uncheckCheckbox("rolesDisabled");
        this.submit();
        this.clickLink("connector-configuration");
        this.assertCheckboxNotSelected("rolesDisabled");
        this.gotoBrowseRoles();
        this.assertSelectOptionPresent("directoryID", CONNECTOR_DIRECTORY_NAME);
    }

    public void testAddCustomDirectoryWithoutAttributes() {
        this.gotoCreateDirectory();
        this.clickButton("create-custom");
        this.assertKeyPresent("directorycustomcreate.title");
        this.setWorkingForm("directorycustom");
        this.setTextField("name", "");
        this.setTextField("implementationClass", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.assertKeyPresent("directorycustom.implementationclass.invalid");
    }

    public void testAddCustomDirectoryWithBadImplementationClass() {
        this.gotoCreateDirectory();
        this.clickButton("create-custom");
        this.assertKeyPresent("directorycustomcreate.title");
        this.setWorkingForm("directorycustom");
        this.setTextField("name", CUSTOM_DIRECTORY_NAME);
        this.setTextField("implementationClass", BAD_CLASS_NAME);
        this.submit();
        this.assertErrorPresent();
        this.assertKeyPresent("directorycustom.implementationclass.invalid");
    }

    public void testAddCustomDirectory() {
        this.gotoCreateDirectory();
        this.clickButton("create-custom");
        this.assertKeyPresent("directorycustomcreate.title");
        this.setWorkingForm("directorycustom");
        this.setTextField("name", CUSTOM_DIRECTORY_NAME);
        this.setTextField("implementationClass", ApacheDS.class.getCanonicalName());
        this.submit();
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.assertTextFieldEquals("name", CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
    }

    public void testAddDelegatedDirectory() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("description", DELEGATED_DIRECTORY_DESCRIPTION);
        this.checkCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertTextFieldEquals("name", DELEGATED_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", DELEGATED_DIRECTORY_DESCRIPTION);
        this.assertKeyPresent("directory.delegating.type.name");
        this.assertKeyNotPresent("directoryconnector.rolednaddition.invalid");
        this.assertCheckboxSelected("active");
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME));
        this.clickLink("delegated-connectiondetails");
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.clickLink("delegated-configuration");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
    }

    public void testAddDelegatedDirectoryWithPwdEncryption() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("description", DELEGATED_DIRECTORY_DESCRIPTION);
        this.checkCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", GenericLDAP.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.selectOption("userEncryptionMethod", "MD5");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertTextFieldEquals("name", DELEGATED_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", DELEGATED_DIRECTORY_DESCRIPTION);
        this.assertKeyPresent("directory.delegating.type.name");
        this.assertCheckboxSelected("active");
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME));
        this.clickLink("delegated-connectiondetails");
        this.assertTextPresent(GenericLDAP.getStaticDirectoryType());
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "MD5");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.clickLink("delegated-configuration");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
    }

    public void testAddDelegatingDirectoryWithoutAttributes() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userNameRdnAttr", "");
        this.setTextField("userDisplayNameAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userPasswordAttr", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.clickLinkWithExactText("Connector");
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid");
        this.clickLinkWithExactText("Configuration");
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usernamerdnattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userpassword.invalid");
        this.assertKeyPresent("directoryconnector.userdisplaynameattribute.invalid");
    }

    public void testAddDelegatedDirectoryTestSearch() {
        this.log("Running: testAddDelegatedDirectoryTestSearchInvalid");
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("description", DELEGATED_DIRECTORY_DESCRIPTION);
        this.checkCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.clickButton("test-search-principal");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testAddDelegatedDirectoryTestSearchInvalid() {
        this.log("Running: testAddDelegatedDirectoryTestSearchInvalid");
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("description", DELEGATED_DIRECTORY_DESCRIPTION);
        this.checkCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=nonexistent");
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }
}

