/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.confluence;

import com.atlassian.crowd.acceptance.tests.applications.confluence.ConfluenceAcceptanceTestCase;

public class ConfluenceUserMutationTest
extends ConfluenceAcceptanceTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToConfluence();
    }

    public void testConfluenceUserCrud() {
        this._testCreateConfluenceUser();
        this._testUpdateConfluenceUser();
        this._testAddConfluenceUserGroupMembership();
        this._testRemoveConfluenceUserGroupMembership();
        this._testDeleteConfluenceUser();
    }

    public void _testCreateConfluenceUser() {
        this.gotoBrowseUsers();
        this.setWorkingForm("createuserform");
        this.setTextField("username", "mutant-connie");
        this.setTextField("fullname", "Mutant Connie");
        this.setTextField("password", "password");
        this.setTextField("confirm", "password");
        this.setTextField("email", "mutant-connie@example.com");
        this.submit();
        this.assertTextPresent("User: mutant-connie");
        this.assertTextPresent("mutant-connie");
        this.assertTextPresent("Mutant Connie");
        this.assertTextPresent("mutant-connie@example.com");
        this.assertTextPresent("confluence-users");
        this.verifyUserExistsInCrowd("mutant-connie", "Mutant", "Connie", "mutant-connie@example.com", "confluence-users");
    }

    private void _testUpdateConfluenceUser() {
        this.verifyUserExistsInCrowd("mutant-connie", "Mutant", "Connie", "mutant-connie@example.com", "confluence-users");
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink("mutant-connie");
        this.clickLinkWithText("Edit Details");
        this.setWorkingForm("editUser");
        this.setTextField("fullName", "Mutated Bonnie");
        this.setTextField("email", "mutated.connie.mutant@example.com");
        this.submit();
        this.assertTextPresent("User: mutant-connie");
        this.assertTextPresent("mutant-connie");
        this.assertTextPresent("Mutated Bonnie");
        this.assertTextPresent("mutated.connie.mutant@example.com");
        this.assertTextPresent("confluence-users");
        this.verifyUserExistsInCrowd("mutant-connie", "Mutated", "Bonnie", "mutated.connie.mutant@example.com", "confluence-users");
    }

    private void _testAddConfluenceUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink("mutant-connie");
        this.clickLinkWithText("Edit Groups");
        this.setWorkingForm("editusergroupsform");
        this.assertCheckboxSelected("newGroups", "confluence-users");
        this.checkCheckbox("newGroups", "confluence-administrators");
        this.submit("save");
        this.verifyUserExistsInCrowd("mutant-connie", "Mutated", "Bonnie", "mutated.connie.mutant@example.com", "confluence-administrators", "confluence-users");
    }

    private void _testRemoveConfluenceUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink("mutant-connie");
        this.clickLinkWithText("Edit Groups");
        this.setWorkingForm("editusergroupsform");
        this.assertCheckboxSelected("newGroups", "confluence-administrators");
        this.assertCheckboxSelected("newGroups", "confluence-users");
        this.uncheckCheckbox("newGroups", "confluence-administrators");
        this.submit("save");
        this.verifyUserExistsInCrowd("mutant-connie", "Mutated", "Bonnie", "mutated.connie.mutant@example.com", "confluence-users");
    }

    private void _testDeleteConfluenceUser() {
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink("mutant-connie");
        this.clickLinkWithText("Remove");
        this.assertTextPresent("Remove User");
        this.setWorkingForm("removeuserform");
        this.submit();
        this.assertTextPresent("Manage Users");
        this.clickLinkWithText("Show all users");
        this.assertTextNotPresent("mutant-connie");
        this.assertTextNotPresent("Mutated Bonnie");
        this.assertTextNotPresent("mutated.connie.mutant@example.com");
        this.verifyUserDoesNotExistInCrowd("mutant-connie", "Mutated", "Bonnie", "mutated.connie.mutant@example.com", new String[0]);
    }
}

