/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.applications.bamboo.BambooAcceptanceTestCase;

public class BambooUserMutationTest
extends BambooAcceptanceTestCase {
    private static final String BAMBOO_USER = "bamboo-mutant";
    private static final String BAMBOO_USER_PASSWORD = "password";
    private static final String BAMBOO_USER_EMAIL = "bamboomutant@example.com";
    private static final String BAMBOO_USER_FIRSTNAME = "Bamboo";
    private static final String BAMBOO_USER_LASTNAME = "Mutant";
    private static final String BAMBOO_USER_FULLNAME = "Bamboo Mutant";
    private static final String BAMBOO_MUTANT_FIRSTNAME = "Mutated";
    private static final String BAMBOO_MUTANT_LASTNAME = "Baboon";
    private static final String BAMBOO_MUTANT_FULLNAME = "Mutated Baboon";
    private static final String BAMBOO_MUTANT_EMAIL = "mutant_baboon@example.com";

    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToBamboo();
    }

    public void testBambooUserCrud() {
        this._testCreateBambooUser();
        this._testUpdateBambooUser();
        this._testAddBambooUserGroupMembership();
        this._testRemoveBambooUserGroupMembership();
        this._testDeleteBambooUser();
    }

    private void _testCreateBambooUser() {
        this.gotoBrowseUsers();
        this.setWorkingForm("createUser");
        this.setTextField("username", BAMBOO_USER);
        this.setTextField(BAMBOO_USER_PASSWORD, BAMBOO_USER_PASSWORD);
        this.setTextField("confirmPassword", BAMBOO_USER_PASSWORD);
        this.setTextField("fullName", BAMBOO_USER_FULLNAME);
        this.setTextField("email", BAMBOO_USER_EMAIL);
        this.selectOptionByValue("groups", "bamboo-users");
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{BAMBOO_USER, BAMBOO_USER_EMAIL, BAMBOO_USER_FULLNAME, "bamboo-users \n", "", "Edit | Delete"});
        this.verifyUserExistsInCrowd(BAMBOO_USER, BAMBOO_USER_FIRSTNAME, BAMBOO_USER_LASTNAME, BAMBOO_USER_EMAIL, "bamboo-users");
    }

    private void _testUpdateBambooUser() {
        this.gotoBrowseUsers();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{BAMBOO_USER, BAMBOO_USER_EMAIL, BAMBOO_USER_FULLNAME, "bamboo-users \n", "", "Edit | Delete"});
        this.clickLink("editUser-bamboo-mutant");
        this.setWorkingForm("updateUser");
        this.setTextField("fullName", BAMBOO_MUTANT_FULLNAME);
        this.setTextField("email", BAMBOO_MUTANT_EMAIL);
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{BAMBOO_USER, BAMBOO_MUTANT_EMAIL, BAMBOO_MUTANT_FULLNAME, "bamboo-users \n", "", "Edit | Delete"});
        this.verifyUserExistsInCrowd(BAMBOO_USER, BAMBOO_MUTANT_FIRSTNAME, BAMBOO_MUTANT_LASTNAME, BAMBOO_MUTANT_EMAIL, "bamboo-users");
    }

    private void _testAddBambooUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLink("editUser-bamboo-mutant");
        this.setWorkingForm("updateUser");
        this.selectOptionsByValues("groups", new String[]{"bamboo-admin", "bamboo-users"});
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{BAMBOO_USER, BAMBOO_MUTANT_EMAIL, BAMBOO_MUTANT_FULLNAME, "bamboo-admin \n bamboo-users \n", "", "Edit | Delete"});
        this.verifyUserExistsInCrowd(BAMBOO_USER, BAMBOO_MUTANT_FIRSTNAME, BAMBOO_MUTANT_LASTNAME, BAMBOO_MUTANT_EMAIL, "bamboo-admin", "bamboo-users");
    }

    private void _testRemoveBambooUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLink("editUser-bamboo-mutant");
        this.setWorkingForm("updateUser");
        this.selectOptionByValue("groups", "bamboo-admin");
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{BAMBOO_USER, BAMBOO_MUTANT_EMAIL, BAMBOO_MUTANT_FULLNAME, "bamboo-admin \n", "", "Edit | Delete"});
        this.verifyUserExistsInCrowd(BAMBOO_USER, BAMBOO_MUTANT_FIRSTNAME, BAMBOO_MUTANT_LASTNAME, BAMBOO_MUTANT_EMAIL, "bamboo-admin");
    }

    private void _testDeleteBambooUser() {
        this.gotoBrowseUsers();
        this.clickLink("deleteUser-bamboo-mutant");
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
        this.verifyUserDoesNotExistInCrowd(BAMBOO_USER, BAMBOO_MUTANT_FIRSTNAME, BAMBOO_MUTANT_LASTNAME, BAMBOO_MUTANT_EMAIL, "bamboo-admin");
    }
}

