/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.page;

import com.atlassian.crowd.acceptance.page.IllegalPageStateException;
import net.sourceforge.jwebunit.api.ITestingEngine;
import net.sourceforge.jwebunit.junit.WebTester;

public abstract class SecurePage {
    protected final ITestingEngine engine;

    protected SecurePage(ITestingEngine engine) {
        this.engine = engine;
        if (!engine.hasElement("userFullName")) {
            throw new IllegalStateException("User is not logged in");
        }
        if (engine.getPageTitle().contains("Access Denied")) {
            throw new IllegalPageStateException(engine, "User has no access to this page");
        }
    }

    protected SecurePage(WebTester tester, String baseUrl, String pageUrl, String displayName, String username, String password) {
        this.engine = tester.getTestingEngine();
        tester.beginAt(baseUrl + pageUrl);
        if (this.engine.hasElement("userFullName") && !this.engine.isTextInElement("userFullName", displayName)) {
            tester.beginAt(baseUrl + "console/logoff.action");
            tester.beginAt(baseUrl + pageUrl);
        }
        if (!this.engine.hasElement("userFullName")) {
            this.loginAs(username, password);
        }
        if (this.engine.getPageTitle().contains("Access Denied")) {
            throw new IllegalPageStateException(this.engine, "User " + username + " has no access to this page");
        }
    }

    private void loginAs(String username, String password) {
        this.engine.setWorkingForm("login", 0);
        this.engine.setTextField("j_username", username);
        this.engine.setTextField("j_password", password);
        this.engine.submit();
        if (this.engine.hasForm("login")) {
            throw new IllegalStateException("Login failed");
        }
    }
}

