/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.rest.service.RestCrowdClient;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class RestCrowdClientTest
extends CrowdAcceptanceTestCase {
    private static final String APPLICATION_NAME = "crowd";
    private static final String APPLICATION_PASSWORD = "qybhDMZh";
    private CrowdClient crowdClient;

    public void setUp() throws Exception {
        super.setUp();
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        this.crowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        this.restoreCrowdFromXML("remotecrowddirectory.xml");
    }

    public void testGetUser() throws Exception {
        User user = this.crowdClient.getUser("admin");
        RestCrowdClientTest.assertEquals((String)"admin", (String)user.getName());
    }

    public void testGetGroupNameMembershipsForGroup() throws Exception {
        List<String> expectedGroupNames = Arrays.asList("crowd-testers", "crowd-users");
        List groupNames = this.crowdClient.getNamesOfParentGroupsForGroup("badgers", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groupNames);
        RestCrowdClientTest.assertEquals((int)expectedGroupNames.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroupNames));
    }

    public void testGetGroupNameMembershipsForGroup_InvalidStartIndex() throws Exception {
        try {
            this.crowdClient.getNamesOfParentGroupsForGroup("badgers", -1, 50);
            RestCrowdClientTest.fail((String)"Expected OperationFailedException");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public void testGetGroupNameMembershipsForGroup_NonExistentGroup() throws Exception {
        List groupNames = this.crowdClient.getNamesOfParentGroupsForGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groupNames);
        RestCrowdClientTest.assertTrue((boolean)groupNames.isEmpty());
    }

    public void testGetNestedUserNameMembersOfGroup() throws Exception {
        List<String> expectedUsernames = Arrays.asList("secondadmin", "penny", "admin", "eeeep");
        List usernames = this.crowdClient.getNamesOfNestedUsersOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)usernames);
        RestCrowdClientTest.assertEquals((int)expectedUsernames.size(), (int)usernames.size());
        RestCrowdClientTest.assertTrue((boolean)usernames.containsAll(expectedUsernames));
    }

    public void testGetNestedUserNameMembersOfGroup_NonExistentGroup() throws Exception {
        List usernames = this.crowdClient.getNamesOfNestedUsersOfGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)usernames);
        RestCrowdClientTest.assertTrue((boolean)usernames.isEmpty());
    }

    public void testGetNestedGroupMembersOfGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-testers", "badgers");
        List groups = this.crowdClient.getNestedChildGroupsOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        ArrayList<String> groupNames = new ArrayList<String>(groups.size());
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembersOfGroup_NonExistentGroup() throws Exception {
        List groups = this.crowdClient.getNestedChildGroupsOfGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupNameMembersOfGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-testers", "badgers");
        List groups = this.crowdClient.getNamesOfNestedChildGroupsOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groups.size());
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupNameMembersOfGroup_NonExistent() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-testers", "badgers");
        List groups = this.crowdClient.getNamesOfNestedChildGroupsOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groups.size());
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembershipsForUser() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "badgers", "crowd-users");
        List groups = this.crowdClient.getGroupsForNestedUser("admin", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembershipsForUser_NonExistent() throws Exception {
        List groups = this.crowdClient.getGroupsForNestedUser("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupNameMembershipsForUser() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "badgers", "crowd-users");
        List groups = this.crowdClient.getNamesOfGroupsForNestedUser("admin", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupNameMembershipsForUser_NonExistent() throws Exception {
        List groups = this.crowdClient.getNamesOfGroupsForNestedUser("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupMembershipsForGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "crowd-users");
        List groups = this.crowdClient.getParentGroupsForNestedGroup("badgers", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembershipsForGroup_NonExistent() throws Exception {
        List groups = this.crowdClient.getParentGroupsForNestedGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupNameMembershipsForGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "crowd-users");
        List groups = this.crowdClient.getNamesOfParentGroupsForNestedGroup("badgers", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groups.size());
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupNameMembershipsForGroup_NonExistent() throws Exception {
        List groups = this.crowdClient.getNamesOfParentGroupsForNestedGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testConnectToInvalidRestService() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH + "/badservice");
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        RestCrowdClient badCrowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        try {
            badCrowdClient.testConnection();
            RestCrowdClientTest.fail((String)"OperationFailedException expected.");
        }
        catch (OperationFailedException e) {
            // empty catch block
        }
    }

    public void testConnectToRestService_WrongPassword() throws Exception {
        String APPLICATION_AUTHENTICATION_ERROR_MSG = "Application failed to authenticate";
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", "blah");
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        RestCrowdClient badCrowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        try {
            badCrowdClient.testConnection();
            RestCrowdClientTest.fail((String)"OperationFailedException expected.");
        }
        catch (InvalidAuthenticationException e) {
            RestCrowdClientTest.assertEquals((String)"Application failed to authenticate", (String)e.getMessage());
        }
    }
}

