/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.migration;

import com.atlassian.crowd.acceptance.tests.persistence.migration.DataSourceSpringContextTestDelegate;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.migration.legacy.database.sql.HSQLLegacyTableQueries;
import com.atlassian.crowd.migration.legacy.database.sql.LegacyTableQueries;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdDatabaseMigrationTest {
    private static final String ID = "ID";
    private static final String CREATED_DATE = "CREATED_DATE";
    private static final String ACTIVE = "ACTIVE";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String DIRECTORY_ID = "DIRECTORY_ID";
    private static final String CREDENTIAL = "CREDENTIAL";
    private static final String DIRECTORY_NAME = "DIRECTORY_NAME";
    private static final String LOWER_DIRECTORY_NAME = "LOWER_DIRECTORY_NAME";
    private static final String IMPL_CLASS = "IMPL_CLASS";
    private static final String DIRECTORY_TYPE = "DIRECTORY_TYPE";
    private static final String LOWER_IMPL_CLASS = "LOWER_IMPL_CLASS";
    private static final String INTERNAL_DIRECTORY_IMPL = "com.atlassian.crowd.directory.InternalDirectory";
    private static final String ACTIVE_DIRECTORY_IMPL = "com.atlassian.crowd.directory.MicrosoftActiveDirectory";
    private static final String USER_NAME = "USER_NAME";
    private static final String LOWER_USER_NAME = "LOWER_USER_NAME";
    private static final String FIRST_NAME = "FIRST_NAME";
    private static final String LOWER_FIRST_NAME = "LOWER_FIRST_NAME";
    private static final String LAST_NAME = "LAST_NAME";
    private static final String LOWER_LAST_NAME = "LOWER_LAST_NAME";
    private static final String DISPLAY_NAME = "DISPLAY_NAME";
    private static final String LOWER_DISPLAY_NAME = "LOWER_DISPLAY_NAME";
    private static final String EMAIL_ADDRESS = "EMAIL_ADDRESS";
    private static final String LOWER_EMAIL_ADDRESS = "LOWER_EMAIL_ADDRESS";
    private static final String ATTRIBUTE_COLOUR = "colours";
    private static final String ATTRIBUTE_FOOD = "food";
    private static final String PASSWORD_LAST_CHANGED = "passwordLastChanged";
    private static final String REQUIRES_PASSWORD_CHANGE = "requiresPasswordChange";
    private static final String LAST_AUTHENTICATED = "lastAuthenticated";
    private static final String INVALID_PASSWORD_ATTEMPTS = "invalidPasswordAttempts";
    private static final String GROUP_NAME = "GROUP_NAME";
    private static final String LOWER_GROUP_NAME = "LOWER_GROUP_NAME";
    private static final String GROUP_TYPE = "GROUP_TYPE";
    private static final String MEMBERSHIP_TYPE = "MEMBERSHIP_TYPE";
    private static final String PARENT_NAME = "PARENT_NAME";
    private static final String LOWER_PARENT_NAME = "LOWER_PARENT_NAME";
    private static final String CHILD_NAME = "CHILD_NAME";
    private static final String LOWER_CHILD_NAME = "LOWER_CHILD_NAME";
    private static final String APPLICATION_NAME = "APPLICATION_NAME";
    private static final String LOWER_APPLICATION_NAME = "LOWER_APPLICATION_NAME";
    private static final String APPLICATION_TYPE = "APPLICATION_TYPE";
    private static final String APPLICATION_ID = "APPLICATION_ID";
    private static final String REMOTE_ADDRESS = "REMOTE_ADDRESS";
    private static final String REMOTE_ADDRESS_ENCODEDBYTES = "REMOTE_ADDRESS_BINARY";
    private static final String REMOTE_ADDRESS_MASK = "REMOTE_ADDRESS_MASK";
    private static final String LIST_INDEX = "LIST_INDEX";
    private static final String ALLOW_ALL = "ALLOW_ALL";
    private static final String PROPERTY_KEY = "PROPERTY_KEY";
    private final DataSourceSpringContextTestDelegate delegate = new DataSourceSpringContextTestDelegate();
    private JdbcTemplate jdbcTemplate;
    private DatabaseMapper databaseMapper;

    @Before
    public void setUp() throws Exception {
        this.delegate.setup();
        this.jdbcTemplate = this.delegate.getJdbcTemplate();
        SessionFactory sessionFactory = this.delegate.getSessionFactory();
        BatchProcessor batchProcessor = this.delegate.getBatchProcessor();
        Assert.assertNotNull((Object)this.jdbcTemplate);
        this.databaseMapper = new DatabaseMapper(sessionFactory, batchProcessor, (JdbcOperations)this.jdbcTemplate);
        Assert.assertEquals((long)1L, (long)this.countRowsInTable("hibernate_unique_key"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_user"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_property"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_group"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_membership"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_directory"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_application"));
    }

    @Test
    public void testDatabaseMigration() throws Exception {
        this.delegate.getLegacyDatabaseMigrator().importDatabase((LegacyTableQueries)new HSQLLegacyTableQueries());
        this.delegate.getUpgradeManager().doUpgrade();
        Assert.assertEquals((long)1L, (long)this.countRowsInTable("hibernate_unique_key"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_token"));
        this.assertDirectoryTables();
        this.assertUserTables();
        this.assertGroupTables();
        this.assertMembershipTables();
        this.assertApplicationTables();
        this.assertPropertyTables();
    }

    public void assertDirectoryTables() {
        Assert.assertEquals((long)3L, (long)this.countRowsInTable("cwd_directory"));
        Assert.assertEquals((long)43L, (long)this.countRowsInTable("cwd_directory_attribute"));
        Assert.assertEquals((long)28L, (long)this.countRowsInTable("cwd_directory_operation"));
        String sqlQuery = "SELECT id, directory_name, lower_directory_name, created_date, " + "active, description, impl_class, lower_impl_class, directory_type " + "FROM cwd_directory";
        List<Map<String, Object>> queriedDirectoriesList = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        List<Map<String, Object>> actualDirectoriesList = this.createActualDirectoriesList();
        Assert.assertEquals((long)actualDirectoriesList.size(), (long)queriedDirectoriesList.size());
        Assert.assertTrue((boolean)queriedDirectoriesList.containsAll(actualDirectoriesList));
        sqlQuery = "SELECT attribute_value, attribute_name " + "FROM cwd_directory_attribute " + "WHERE directory_id=1";
        Map directoryAttributes = this.databaseMapper.attributeListToMap(this.jdbcTemplate.query(sqlQuery, (RowMapper)new AttributeMapper()));
        HashMap<String, String> actualAttributes = new HashMap<String, String>();
        actualAttributes.put("password_history_count", "0");
        actualAttributes.put("password_max_attempts", "0");
        actualAttributes.put("password_max_change_time", "0");
        actualAttributes.put("user_encryption_method", "atlassian-sha1");
        Assert.assertEquals((long)actualAttributes.size(), (long)directoryAttributes.size());
        directoryAttributes.entrySet().containsAll(actualAttributes.entrySet());
        sqlQuery = "SELECT attribute_value, attribute_name " + "FROM cwd_directory_attribute " + "WHERE directory_id=3";
        directoryAttributes = this.databaseMapper.attributeListToMap(this.jdbcTemplate.query(sqlQuery, (RowMapper)new AttributeMapper()));
        Assert.assertEquals((long)35L, (long)directoryAttributes.size());
        actualAttributes = new HashMap();
        actualAttributes.put("ldap.roles.disabled", "false");
        actualAttributes.put("ldap.relaxed.dn.standardisation", "true");
        actualAttributes.put("com.atlassian.crowd.directory.sync.cache.enabled", "false");
        actualAttributes.put("ldap.basedn", "dc=sydney,dc=atlassian,dc=com");
        actualAttributes.put("ldap.user.filter", "(&(objectCategory=Person)(sAMAccountName=*))");
        actualAttributes.put("ldap.url", "ldap://crowd-ad1:389/");
        actualAttributes.put("ldap.pagedresults", "999");
        actualAttributes.put("ldap.userdn", "cn=Administrator,cn=Users,dc=sydney,dc=atlassian,dc=com");
        actualAttributes.put("ldap.password", "atlassian");
        actualAttributes.put("directory.cache.synchronise.interval", "3600");
        directoryAttributes.entrySet().containsAll(actualAttributes.entrySet());
        sqlQuery = "SELECT operation_type " + "FROM cwd_directory_operation " + "WHERE directory_id=1";
        List directoryOperations = this.jdbcTemplate.query(sqlQuery, (RowMapper)new OperationsMapper());
        Assert.assertEquals(EnumSet.allOf(OperationType.class), EnumSet.copyOf(directoryOperations));
        sqlQuery = "SELECT operation_type " + "FROM cwd_directory_operation " + "WHERE directory_id=2";
        directoryOperations = this.jdbcTemplate.query(sqlQuery, (RowMapper)new OperationsMapper());
        Assert.assertEquals(EnumSet.of(OperationType.CREATE_USER, OperationType.UPDATE_USER, OperationType.UPDATE_USER_ATTRIBUTE, OperationType.DELETE_USER), EnumSet.copyOf(directoryOperations));
    }

    public void assertUserTables() {
        Assert.assertEquals((long)4L, (long)this.countRowsInTable("cwd_user"));
        Assert.assertEquals((long)18L, (long)this.countRowsInTable("cwd_user_attribute"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_user_credential_record"));
        String sqlQuery = "SELECT user_name, lower_user_name, active, created_date, first_name, lower_first_name, " + "last_name, lower_last_name, display_name, lower_display_name, " + "email_address, lower_email_address, directory_id, credential " + "FROM cwd_user";
        List<Map<String, Object>> queriedUsers = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        List<Map<String, Object>> actualUsers = this.createActualUsersList();
        Assert.assertEquals((long)actualUsers.size(), (long)queriedUsers.size());
        Assert.assertTrue((boolean)queriedUsers.containsAll(actualUsers));
        sqlQuery = "SELECT COUNT(DISTINCT id) FROM cwd_user";
        Assert.assertEquals((long)actualUsers.size(), (long)this.jdbcTemplate.queryForInt(sqlQuery));
        sqlQuery = "SELECT attribute_name, attribute_value " + "FROM cwd_user_attribute " + "WHERE user_id=" + "(SELECT id FROM cwd_user WHERE user_name='test1' AND directory_id=1)";
        Map userAttributes = this.databaseMapper.attributeListToMultiAttributeMap(this.jdbcTemplate.query(sqlQuery, (RowMapper)new AttributeMapper()));
        Assert.assertEquals((long)4L, (long)userAttributes.size());
        Assert.assertEquals((long)3L, (long)((Set)userAttributes.get(ATTRIBUTE_COLOUR)).size());
        Assert.assertTrue((boolean)((Set)userAttributes.get(ATTRIBUTE_COLOUR)).containsAll(Arrays.asList("blue", "green", "red")));
        Assert.assertEquals((Object)"pastry", ((Set)userAttributes.get(ATTRIBUTE_FOOD)).iterator().next());
        Assert.assertEquals((Object)"1265170034108", ((Set)userAttributes.get(PASSWORD_LAST_CHANGED)).iterator().next());
        Assert.assertEquals((Object)"false", ((Set)userAttributes.get(REQUIRES_PASSWORD_CHANGE)).iterator().next());
        Assert.assertNull(userAttributes.get(LAST_AUTHENTICATED));
        sqlQuery = "SELECT attribute_name, attribute_value " + "FROM cwd_user_attribute " + "WHERE user_id=" + "(SELECT id FROM cwd_user WHERE user_name='admin' AND directory_id=1)";
        userAttributes = this.databaseMapper.attributeListToMultiAttributeMap(this.jdbcTemplate.query(sqlQuery, (RowMapper)new AttributeMapper()));
        Assert.assertEquals((long)4L, (long)userAttributes.size());
        Assert.assertEquals((Object)"1265774846524", ((Set)userAttributes.get(LAST_AUTHENTICATED)).iterator().next());
        Assert.assertEquals((Object)"0", ((Set)userAttributes.get(INVALID_PASSWORD_ATTEMPTS)).iterator().next());
        Assert.assertEquals((Object)"1265170401218", ((Set)userAttributes.get(PASSWORD_LAST_CHANGED)).iterator().next());
        Assert.assertEquals((Object)"false", ((Set)userAttributes.get(REQUIRES_PASSWORD_CHANGE)).iterator().next());
        Assert.assertNull(userAttributes.get(ATTRIBUTE_COLOUR));
        sqlQuery = "SELECT attribute_name, attribute_value " + "FROM cwd_user_attribute " + "WHERE user_id=" + "(SELECT id FROM cwd_user WHERE user_name='test1' AND directory_id=2)";
        userAttributes = this.databaseMapper.attributeListToMultiAttributeMap(this.jdbcTemplate.query(sqlQuery, (RowMapper)new AttributeMapper()));
        Assert.assertEquals((long)4L, (long)userAttributes.size());
        Assert.assertEquals((long)3L, (long)((Set)userAttributes.get(ATTRIBUTE_COLOUR)).size());
        Assert.assertTrue((boolean)((Set)userAttributes.get(ATTRIBUTE_COLOUR)).containsAll(Arrays.asList("Black", "White", "grey")));
        Assert.assertEquals((Object)"Chocolate", ((Set)userAttributes.get(ATTRIBUTE_FOOD)).iterator().next());
        Assert.assertEquals((Object)"1265170186131", ((Set)userAttributes.get(PASSWORD_LAST_CHANGED)).iterator().next());
        Assert.assertEquals((Object)"false", ((Set)userAttributes.get(REQUIRES_PASSWORD_CHANGE)).iterator().next());
        Assert.assertNull(userAttributes.get(LAST_AUTHENTICATED));
        sqlQuery = "SELECT attribute_name, attribute_value " + "FROM cwd_user_attribute " + "WHERE user_id=" + "(SELECT id FROM cwd_user WHERE user_name='testuser' AND directory_id=1)";
        userAttributes = this.databaseMapper.attributeListToMultiAttributeMap(this.jdbcTemplate.query(sqlQuery, (RowMapper)new AttributeMapper()));
        Assert.assertEquals((long)2L, (long)userAttributes.size());
        Assert.assertEquals((Object)"1265170333000", ((Set)userAttributes.get(PASSWORD_LAST_CHANGED)).iterator().next());
        Assert.assertEquals((Object)"false", ((Set)userAttributes.get(REQUIRES_PASSWORD_CHANGE)).iterator().next());
        Assert.assertNull(userAttributes.get(LAST_AUTHENTICATED));
        sqlQuery = "SELECT * FROM cwd_user_credential_record";
        Assert.assertEquals((long)0L, (long)this.jdbcTemplate.queryForList(sqlQuery).size());
    }

    public void assertGroupTables() {
        Assert.assertEquals((long)4L, (long)this.countRowsInTable("cwd_group"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_group_attribute"));
        String sqlQuery = "SELECT group_name, lower_group_name, active, created_date, description, group_type, directory_id " + "FROM cwd_group";
        List<Map<String, Object>> queriedGroups = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        List<Map<String, Object>> actualGroups = this.createActualGroupsList();
        Assert.assertEquals((long)actualGroups.size(), (long)queriedGroups.size());
        Assert.assertTrue((boolean)queriedGroups.containsAll(actualGroups));
        sqlQuery = "SELECT COUNT(DISTINCT id) FROM cwd_group";
        Assert.assertEquals((long)actualGroups.size(), (long)this.jdbcTemplate.queryForInt(sqlQuery));
        sqlQuery = "SELECT * FROM cwd_group_attribute";
        Assert.assertEquals((long)0L, (long)this.jdbcTemplate.queryForList(sqlQuery).size());
    }

    public void assertMembershipTables() {
        Assert.assertEquals((long)6L, (long)this.countRowsInTable("cwd_membership"));
        String sqlQuery = "SELECT membership_type, group_type, " + "parent_name, lower_parent_name, child_name, lower_child_name, " + "directory_id " + "FROM cwd_membership";
        List<Map<String, Object>> queriedMemberships = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        List<Map<String, Object>> actualMemberships = this.createActualMembershipsList();
        Assert.assertEquals((long)actualMemberships.size(), (long)queriedMemberships.size());
        Assert.assertTrue((boolean)queriedMemberships.containsAll(actualMemberships));
        sqlQuery = "SELECT COUNT(DISTINCT parent_id) FROM cwd_membership";
        Assert.assertEquals((long)4L, (long)this.jdbcTemplate.queryForInt(sqlQuery));
        sqlQuery = "SELECT COUNT(DISTINCT child_id) FROM cwd_membership";
        Assert.assertEquals((long)3L, (long)this.jdbcTemplate.queryForInt(sqlQuery));
    }

    public void assertApplicationTables() {
        Assert.assertEquals((long)4L, (long)this.countRowsInTable("cwd_application"));
        Assert.assertEquals((long)10L, (long)this.countRowsInTable("cwd_application_address"));
        Assert.assertEquals((long)0L, (long)this.countRowsInTable("cwd_application_alias"));
        Assert.assertEquals((long)8L, (long)this.countRowsInTable("cwd_application_attribute"));
        Assert.assertEquals((long)5L, (long)this.countRowsInTable("cwd_app_dir_mapping"));
        Assert.assertEquals((long)55L, (long)this.countRowsInTable("cwd_app_dir_operation"));
        Assert.assertEquals((long)5L, (long)this.countRowsInTable("cwd_app_dir_group_mapping"));
        String sqlQuery = "SELECT id, application_name FROM cwd_application";
        Map<Long, Long> convertedApplicationIdMap = this.getApplicationIdMappings(sqlQuery, new ApplicationIdMapper());
        sqlQuery = "SELECT application_name, lower_application_name, " + "created_date, active, description, application_type, credential " + "FROM cwd_application";
        List<Map<String, Object>> queriedValues = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        List<Map<String, Object>> actualValues = this.createActualApplicationsList();
        Assert.assertEquals((long)actualValues.size(), (long)queriedValues.size());
        Assert.assertTrue((String)"Table <cwd_application> does not match expected data", (boolean)queriedValues.containsAll(actualValues));
        sqlQuery = "SELECT * FROM cwd_application_address";
        queriedValues = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        actualValues = this.createActualAddressesList(convertedApplicationIdMap);
        Assert.assertEquals((long)actualValues.size(), (long)queriedValues.size());
        Assert.assertTrue((String)"Table <cwd_application_address> does not match expected data", (boolean)queriedValues.containsAll(actualValues));
        Assert.assertEquals((long)0L, (long)this.jdbcTemplate.queryForList("SELECT * FROM cwd_application_alias").size());
        sqlQuery = "SELECT * FROM cwd_application_attribute";
        queriedValues = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        actualValues = this.createActualAttributeList(convertedApplicationIdMap);
        Assert.assertEquals((long)actualValues.size(), (long)queriedValues.size());
        Assert.assertTrue((String)"Table <cwd_application_attribute> does not match expected data", (boolean)queriedValues.containsAll(actualValues));
        sqlQuery = "SELECT application_id, directory_id, allow_all, list_index FROM cwd_app_dir_mapping";
        queriedValues = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        actualValues = this.createActualAppDirMappingList(convertedApplicationIdMap);
        Assert.assertEquals((long)actualValues.size(), (long)queriedValues.size());
        Assert.assertTrue((String)"Table <cwd_app_dir_mapping> does not match expected data", (boolean)queriedValues.containsAll(actualValues));
        AppDirOperationMapper appDirOperationMapper = new AppDirOperationMapper();
        sqlQuery = "SELECT operation_type " + "FROM cwd_app_dir_operation " + "WHERE app_dir_mapping_id=" + "(SELECT id FROM cwd_app_dir_mapping " + "WHERE application_id=? " + "AND directory_id=?)";
        List operations = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163841L), 1L}, (RowMapper)appDirOperationMapper);
        Assert.assertEquals(EnumSet.allOf(OperationType.class), EnumSet.copyOf(operations));
        operations = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163842L), 1L}, (RowMapper)appDirOperationMapper);
        Assert.assertEquals(EnumSet.allOf(OperationType.class), EnumSet.copyOf(operations));
        operations = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163843L), 1L}, (RowMapper)appDirOperationMapper);
        Assert.assertEquals(EnumSet.allOf(OperationType.class), EnumSet.copyOf(operations));
        operations = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163844L), 1L}, (RowMapper)appDirOperationMapper);
        Assert.assertEquals(EnumSet.of(OperationType.CREATE_GROUP, new OperationType[]{OperationType.UPDATE_GROUP, OperationType.UPDATE_GROUP_ATTRIBUTE, OperationType.CREATE_USER, OperationType.UPDATE_USER, OperationType.UPDATE_USER_ATTRIBUTE, OperationType.DELETE_USER}), EnumSet.copyOf(operations));
        operations = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163844L), 2L}, (RowMapper)appDirOperationMapper);
        Assert.assertEquals(EnumSet.allOf(OperationType.class), EnumSet.copyOf(operations));
        AppDirGroupMapper appDirGroupMapper = new AppDirGroupMapper();
        sqlQuery = "SELECT group_name " + "FROM cwd_app_dir_group_mapping " + "WHERE app_dir_mapping_id=" + "(SELECT id FROM cwd_app_dir_mapping " + "WHERE application_id=? " + "AND directory_id=?)";
        List groups = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163841L), 1L}, (RowMapper)appDirGroupMapper);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"crowd-administrators", groups.get(0));
        groups = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163842L), 1L}, (RowMapper)appDirGroupMapper);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"crowd-administrators", groups.get(0));
        groups = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163843L), 1L}, (RowMapper)appDirGroupMapper);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"crowd-administrators", groups.get(0));
        groups = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163844L), 1L}, (RowMapper)appDirGroupMapper);
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertTrue((boolean)groups.containsAll(Arrays.asList("crowd-administrators", "test-group1")));
        groups = this.jdbcTemplate.query(sqlQuery, new Object[]{convertedApplicationIdMap.get(163844L), 2L}, (RowMapper)appDirGroupMapper);
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    public void assertPropertyTables() {
        Assert.assertEquals((long)29L, (long)this.countRowsInTable("cwd_property"));
        String sqlQuery = "SELECT property_name, property_value FROM cwd_property ORDER BY property_name";
        Map queriedValues = this.databaseMapper.attributeListToMap(this.jdbcTemplate.query(sqlQuery, (RowMapper)new PropertyTableMapper()));
        Assert.assertEquals((long)29L, (long)queriedValues.size());
        Assert.assertEquals((Object)"476", queriedValues.get("build.number"));
        Assert.assertEquals((Object)"true", queriedValues.get("cache.enabled"));
        Assert.assertEquals((Object)"0", queriedValues.get("current.license.resource.total"));
        Assert.assertEquals((Object)"true", queriedValues.get("database.token.storage.enabled"));
        Assert.assertEquals((Object)"Test Crowd Migration", queriedValues.get("deployment.title"));
        Assert.assertEquals((Object)"6dMZIOr0MZc=", queriedValues.get("des.encryption.key"));
        Assert.assertEquals((Object)"true", queriedValues.get("gzip.enabled"));
        Assert.assertEquals((Object)"localhost", queriedValues.get("mailserver.host"));
        Assert.assertEquals((Object)"", queriedValues.get("mailserver.jndi"));
        Assert.assertEquals((Object)"Hello $firstname $lastname, Your password has been reset by a $deploymenttitle administrator at $date. Your new password is: $password $deploymenttitle Administrator", queriedValues.get("mailserver.message.template"));
        Assert.assertEquals((Object)"", queriedValues.get("mailserver.password"));
        Assert.assertEquals((Object)"25", queriedValues.get("mailserver.port"));
        Assert.assertEquals((Object)"[Test Crowd Migration - Atlassian Crowd]", queriedValues.get("mailserver.prefix"));
        Assert.assertEquals((Object)"admin@example.com", queriedValues.get("mailserver.sender"));
        Assert.assertEquals((Object)"", queriedValues.get("mailserver.username"));
        Assert.assertEquals((Object)"admin@example.com", queriedValues.get("notification.email"));
        Assert.assertEquals((Object)"false", queriedValues.get("secure.cookie"));
        Assert.assertEquals((Object)"1800000", queriedValues.get("session.time"));
        Assert.assertEquals((Object)"YFWGPzH6", queriedValues.get("token.seed"));
        Assert.assertEquals((Object)"<list> <map> <entry> <string>password</string> <null/> </entry> <entry> <string>class</string> <java-class>com.atlassian.notifier.NotificationSubscriptionImpl</java-class> </entry> <entry> <string>username</string> <null/> </entry> <entry> <string>url</string> <string>http://localhost/wiki/plugins/servlet/crowdnotify</string> </entry> <entry> <string>authenticationType</string> <com.atlassian.notifier.AuthenticationType>NONE</com.atlassian.notifier.AuthenticationType> </entry> </map> <map> <entry> <string>password</string> <null/> </entry> <entry> <string>class</string> <java-class>com.atlassian.notifier.NotificationSubscriptionImpl</java-class> </entry> <entry> <string>username</string> <null/> </entry> <entry> <string>url</string> <string>http://localhost:3990/plugins/servlet/crowdnotify</string> </entry> <entry> <string>authenticationType</string> <com.atlassian.notifier.AuthenticationType>NONE</com.atlassian.notifier.AuthenticationType> </entry> </map> </list>", queriedValues.get("dummyName"));
        Assert.assertEquals((Object)"A not so interesting value", queriedValues.get("Some SAL Property Name"));
        Assert.assertEquals((Object)"(something here)", queriedValues.get("this.is.a.property.name"));
        Assert.assertEquals((Object)"1", queriedValues.get("com.sun.jndi.ldap.connect.pool.initsize"));
        Assert.assertEquals((Object)"10", queriedValues.get("com.sun.jndi.ldap.connect.pool.prefsize"));
        Assert.assertEquals((Object)"0", queriedValues.get("com.sun.jndi.ldap.connect.pool.maxsize"));
        Assert.assertEquals((Object)"30000", queriedValues.get("com.sun.jndi.ldap.connect.pool.timeout"));
        Assert.assertEquals((Object)"plain ssl", queriedValues.get("com.sun.jndi.ldap.connect.pool.protocol"));
        Assert.assertEquals((Object)"simple", queriedValues.get("com.sun.jndi.ldap.connect.pool.authentication"));
        sqlQuery = "SELECT count(property_key) FROM cwd_property WHERE property_key='crowd'";
        Assert.assertEquals((long)26L, (long)this.jdbcTemplate.queryForInt(sqlQuery));
        sqlQuery = "SELECT property_key FROM cwd_property WHERE property_key<>'crowd'";
        List<Map<String, Object>> propertyKeys = this.convertElementsToHashMap(this.jdbcTemplate.queryForList(sqlQuery));
        List<Map<String, Object>> actualKeys = this.createActualSalKeys();
        Assert.assertEquals((long)actualKeys.size(), (long)propertyKeys.size());
        Assert.assertTrue((boolean)propertyKeys.containsAll(actualKeys));
    }

    @After
    public void tearDown() throws Exception {
        this.delegate.teardown();
    }

    private List<Map<String, Object>> createActualSalKeys() {
        List<String> salColumns = Arrays.asList(PROPERTY_KEY);
        ArrayList<Map<String, Object>> actualKeys = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualKeys, salColumns, Arrays.asList("plugin.SAL"));
        this.addElementsTo(actualKeys, salColumns, Arrays.asList("plugin.Some SAL Key"));
        this.addElementsTo(actualKeys, salColumns, Arrays.asList("plugin.null"));
        return actualKeys;
    }

    private List<Map<String, Object>> createActualGroupsList() {
        List<String> groupColumns = Arrays.asList(GROUP_NAME, LOWER_GROUP_NAME, ACTIVE, CREATED_DATE, DESCRIPTION, GROUP_TYPE, DIRECTORY_ID);
        ArrayList<Map<String, Object>> actualGroups = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualGroups, groupColumns, Arrays.asList("crowd-administrators", "crowd-administrators", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:06:03"), null, GroupType.GROUP.toString(), 1L));
        this.addElementsTo(actualGroups, groupColumns, Arrays.asList("test-group1", "test-group1", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:09:22"), "Group One", GroupType.GROUP.toString(), 1L));
        this.addElementsTo(actualGroups, groupColumns, Arrays.asList("Another Group", "another group", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:15:58"), null, GroupType.GROUP.toString(), 1L));
        this.addElementsTo(actualGroups, groupColumns, Arrays.asList("testing-role", "testing-role", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:11:29"), "This is a role", GroupType.LEGACY_ROLE.toString(), 1L));
        return actualGroups;
    }

    private List<Map<String, Object>> createActualUsersList() {
        List<String> userColumns = Arrays.asList(USER_NAME, LOWER_USER_NAME, ACTIVE, CREATED_DATE, FIRST_NAME, LOWER_FIRST_NAME, LAST_NAME, LOWER_LAST_NAME, DISPLAY_NAME, LOWER_DISPLAY_NAME, EMAIL_ADDRESS, LOWER_EMAIL_ADDRESS, DIRECTORY_ID, CREDENTIAL);
        ArrayList<Map<String, Object>> actualUsers = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualUsers, userColumns, Arrays.asList("test1", "test1", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:07:14"), "Test", "test", "User1", "user1", "Test User1", "test user1", "test1@example.com", "test1@example.com", 1L, "7iaw3Ur350mqGo7jwQrpkj9hiYB3Lkc/iBml1JQODbJ6wYX4oOHV+E+IvIh/1nsUNzLDBMxfqa2Ob1f1ACio/w=="));
        this.addElementsTo(actualUsers, userColumns, Arrays.asList("admin", "admin", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:06:03"), "Super", "super", "User", "user", "Super User", "super user", "admin@example.com", "admin@example.com", 1L, "x61Ey612Kl2gpFL56FT9weDnpSo4AV8j8+qx2AuTHdRyY036xxzTTrw10Wq3+4qQyB+XURPWx1ONxp3Y3pB37A=="));
        this.addElementsTo(actualUsers, userColumns, Arrays.asList("test1", "test1", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:09:46"), "Test", "test", "User1Dir2", "user1dir2", "Test User1Dir2", "test user1dir2", "test1@example.com", "test1@example.com", 2L, "7iaw3Ur350mqGo7jwQrpkj9hiYB3Lkc/iBml1JQODbJ6wYX4oOHV+E+IvIh/1nsUNzLDBMxfqa2Ob1f1ACio/w=="));
        this.addElementsTo(actualUsers, userColumns, Arrays.asList("testuser", "testuser", "T", this.databaseMapper.getDateFromDatabase("2010-02-03 15:12:13"), "Normal", "normal", "User", "user", "Normal User", "normal user", "user@example.com", "user@example.com", 1L, "PGjVboTbmofzsWWwXcjNL332DjLxLZUIKAURYJmAzz3WNVtlAX3An6RtSqUf0UDz4A7JZE3UQ9780t37qPvROg=="));
        return actualUsers;
    }

    private List<Map<String, Object>> createActualDirectoriesList() {
        List<String> directoryColumns = Arrays.asList(ID, DIRECTORY_NAME, LOWER_DIRECTORY_NAME, CREATED_DATE, ACTIVE, DESCRIPTION, IMPL_CLASS, LOWER_IMPL_CLASS, DIRECTORY_TYPE);
        ArrayList<Map<String, Object>> actualDirectories = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualDirectories, directoryColumns, Arrays.asList(1L, "Internal Directory", "internal directory", this.databaseMapper.getDateFromDatabase("2010-02-03 15:05:54"), "T", "", INTERNAL_DIRECTORY_IMPL, IdentifierUtils.toLowerCase((String)INTERNAL_DIRECTORY_IMPL), DirectoryType.INTERNAL.toString()));
        this.addElementsTo(actualDirectories, directoryColumns, Arrays.asList(2L, "Second Internal", "second internal", this.databaseMapper.getDateFromDatabase("2010-02-03 15:08:53"), "T", "A Second Internal Directory", INTERNAL_DIRECTORY_IMPL, IdentifierUtils.toLowerCase((String)INTERNAL_DIRECTORY_IMPL), DirectoryType.INTERNAL.toString()));
        this.addElementsTo(actualDirectories, directoryColumns, Arrays.asList(3L, "Testing Active Directory", "testing active directory", this.databaseMapper.getDateFromDatabase("2010-02-03 15:22:16"), "T", "", ACTIVE_DIRECTORY_IMPL, IdentifierUtils.toLowerCase((String)ACTIVE_DIRECTORY_IMPL), DirectoryType.CONNECTOR.toString()));
        return actualDirectories;
    }

    private List<Map<String, Object>> createActualApplicationsList() {
        List<String> applicationColumns = Arrays.asList(APPLICATION_NAME, LOWER_APPLICATION_NAME, CREATED_DATE, ACTIVE, DESCRIPTION, APPLICATION_TYPE, CREDENTIAL);
        ArrayList<Map<String, Object>> actualApplications = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualApplications, applicationColumns, Arrays.asList("crowd", "crowd", this.databaseMapper.getDateFromDatabase("2010-02-03 15:06:03"), "T", "Crowd Console", ApplicationType.CROWD.toString(), "dqW5gPwYpt7Mg+3Xc3Kb3W6xY3fnmp+BDgvazWVEtpHtPTf6/ZuUFwZ5XCm3aFvUw+lmueE1kCW6ul3NykDWYg=="));
        this.addElementsTo(actualApplications, applicationColumns, Arrays.asList("crowd-openid-server", "crowd-openid-server", this.databaseMapper.getDateFromDatabase("2010-02-03 15:06:07"), "T", "CrowdID OpenID Provider", ApplicationType.GENERIC_APPLICATION.toString(), "sQnzu7wkTrgkQZF+0G1hi5AI3Qmzvv0bXgc5THBqi7mAsdd4Xll27ASbRt9fEyavWi6m0QP9B8lThf+rDKy8hg=="));
        this.addElementsTo(actualApplications, applicationColumns, Arrays.asList("demo", "demo", this.databaseMapper.getDateFromDatabase("2010-02-03 15:06:07"), "T", "Crowd Demo Application", ApplicationType.GENERIC_APPLICATION.toString(), "sQnzu7wkTrgkQZF+0G1hi5AI3Qmzvv0bXgc5THBqi7mAsdd4Xll27ASbRt9fEyavWi6m0QP9B8lThf+rDKy8hg=="));
        this.addElementsTo(actualApplications, applicationColumns, Arrays.asList("google-apps", "google-apps", this.databaseMapper.getDateFromDatabase("2010-02-03 15:05:22"), "T", "Google Applications Connector", ApplicationType.PLUGIN.toString(), "/iPwhVwwDOlh0cQqlpvtrYdwBLQ78c81Ld7yHhljWuoPT6RURvH1ZoSDYi2lQ9LfoPSyImrqQ0InFcv99NPSRg=="));
        return actualApplications;
    }

    private List<Map<String, Object>> createActualMembershipsList() {
        List<String> membershipColumns = Arrays.asList(MEMBERSHIP_TYPE, GROUP_TYPE, PARENT_NAME, LOWER_PARENT_NAME, CHILD_NAME, LOWER_CHILD_NAME, DIRECTORY_ID);
        ArrayList<Map<String, Object>> actualMemberships = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualMemberships, membershipColumns, Arrays.asList(MembershipType.GROUP_USER.toString(), GroupType.GROUP.toString(), "Another Group", "another group", "testuser", "testuser", 1L));
        this.addElementsTo(actualMemberships, membershipColumns, Arrays.asList(MembershipType.GROUP_USER.toString(), GroupType.GROUP.toString(), "Another Group", "another group", "admin", "admin", 1L));
        this.addElementsTo(actualMemberships, membershipColumns, Arrays.asList(MembershipType.GROUP_USER.toString(), GroupType.GROUP.toString(), "Another Group", "another group", "test1", "test1", 1L));
        this.addElementsTo(actualMemberships, membershipColumns, Arrays.asList(MembershipType.GROUP_USER.toString(), GroupType.GROUP.toString(), "crowd-administrators", "crowd-administrators", "admin", "admin", 1L));
        this.addElementsTo(actualMemberships, membershipColumns, Arrays.asList(MembershipType.GROUP_USER.toString(), GroupType.GROUP.toString(), "test-group1", "test-group1", "testuser", "testuser", 1L));
        this.addElementsTo(actualMemberships, membershipColumns, Arrays.asList(MembershipType.GROUP_USER.toString(), GroupType.LEGACY_ROLE.toString(), "testing-role", "testing-role", "testuser", "testuser", 1L));
        return actualMemberships;
    }

    private List<Map<String, Object>> createActualAppDirMappingList(Map<Long, Long> convertedApplicationIdMap) {
        List<String> appDirColumns = Arrays.asList(APPLICATION_ID, DIRECTORY_ID, ALLOW_ALL, LIST_INDEX);
        Long applicationOneId = convertedApplicationIdMap.get(163841L);
        Long applicationTwoId = convertedApplicationIdMap.get(163842L);
        Long applicationThreeId = convertedApplicationIdMap.get(163843L);
        Long applicationFourId = convertedApplicationIdMap.get(163844L);
        ArrayList<Map<String, Object>> actualAppDirMappings = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualAppDirMappings, appDirColumns, Arrays.asList(applicationOneId, 1L, "F", 0));
        this.addElementsTo(actualAppDirMappings, appDirColumns, Arrays.asList(applicationTwoId, 1L, "T", 0));
        this.addElementsTo(actualAppDirMappings, appDirColumns, Arrays.asList(applicationThreeId, 1L, "T", 0));
        this.addElementsTo(actualAppDirMappings, appDirColumns, Arrays.asList(applicationFourId, 1L, "T", 0));
        this.addElementsTo(actualAppDirMappings, appDirColumns, Arrays.asList(applicationFourId, 2L, "F", 1));
        return actualAppDirMappings;
    }

    private List<Map<String, Object>> createActualAttributeList(Map<Long, Long> convertedApplicationIdMap) {
        List<String> attributeColumns = Arrays.asList(APPLICATION_ID, "ATTRIBUTE_NAME", "ATTRIBUTE_VALUE");
        Long applicationOneId = convertedApplicationIdMap.get(163841L);
        Long applicationTwoId = convertedApplicationIdMap.get(163842L);
        Long applicationThreeId = convertedApplicationIdMap.get(163843L);
        Long applicationFourId = convertedApplicationIdMap.get(163844L);
        ArrayList<Map<String, Object>> actualAttributes = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationOneId, "applicationType", ApplicationType.CROWD.toString()));
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationOneId, "atlassian_sha1_applied", "true"));
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationTwoId, "applicationType", "APPLICATION"));
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationTwoId, "atlassian_sha1_applied", "true"));
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationThreeId, "applicationType", "APPLICATION"));
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationThreeId, "atlassian_sha1_applied", "true"));
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationFourId, "applicationType", ApplicationType.PLUGIN.toString()));
        this.addElementsTo(actualAttributes, attributeColumns, Arrays.asList(applicationFourId, "atlassian_sha1_applied", "true"));
        return actualAttributes;
    }

    private Map<Long, Long> getApplicationIdMappings(String sqlQuery, RowMapper oldToNewIdMapper) {
        Map idMapping = this.databaseMapper.attributeListToMap(this.jdbcTemplate.query(sqlQuery, oldToNewIdMapper));
        HashMap<Long, Long> idMappingAsLong = new HashMap<Long, Long>();
        for (Map.Entry entry : idMapping.entrySet()) {
            idMappingAsLong.put(new Long((String)entry.getKey()), new Long((String)entry.getValue()));
        }
        return idMappingAsLong;
    }

    private List<Map<String, Object>> createActualAddressesList(Map<Long, Long> convertedApplicationIdMap) {
        List<String> addressColumns = Arrays.asList(APPLICATION_ID, REMOTE_ADDRESS, REMOTE_ADDRESS_ENCODEDBYTES, REMOTE_ADDRESS_MASK);
        Long applicationOneId = convertedApplicationIdMap.get(163841L);
        Long applicationTwoId = convertedApplicationIdMap.get(163842L);
        Long applicationThreeId = convertedApplicationIdMap.get(163843L);
        ArrayList<Map<String, Object>> actualAddresses = new ArrayList<Map<String, Object>>();
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationOneId, "127.0.0.1", "fwAAAQ==", 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationOneId, "172.20.3.56", "rBQDOA==", 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationOneId, "localhost", null, 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationOneId, "pyko.sydney.atlassian.com", null, 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationTwoId, "127.0.0.1", "fwAAAQ==", 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationTwoId, "172.20.3.56", "rBQDOA==", 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationTwoId, "localhost", null, 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationThreeId, "127.0.0.1", "fwAAAQ==", 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationThreeId, "172.20.3.56", "rBQDOA==", 0));
        this.addElementsTo(actualAddresses, addressColumns, Arrays.asList(applicationThreeId, "localhost", null, 0));
        return actualAddresses;
    }

    private void addElementsTo(List<Map<String, Object>> originalMap, List<String> keys, List<Object> values) {
        Assert.assertEquals((String)"Error creating new element. Keys/values must be matching pairs", (long)keys.size(), (long)values.size());
        HashMap<String, Object> newElement = new HashMap<String, Object>();
        for (int i = 0; i < keys.size(); ++i) {
            newElement.put(keys.get(i), values.get(i));
        }
        originalMap.add(newElement);
    }

    private int countRowsInTable(String tablename) {
        return this.delegate.countRowsInTable(tablename);
    }

    private List<Map<String, Object>> convertElementsToHashMap(List<Map<String, Object>> array) {
        ArrayList<Map<String, Object>> convertedArray = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> element : array) {
            convertedArray.add(new HashMap<String, Object>(element));
        }
        return convertedArray;
    }

    private class AppDirGroupMapper
    implements RowMapper {
        private AppDirGroupMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString("group_name");
        }
    }

    private class AppDirOperationMapper
    implements RowMapper {
        private AppDirOperationMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return OperationType.valueOf((String)rs.getString("operation_type"));
        }
    }

    private class PropertyTableMapper
    implements RowMapper {
        private PropertyTableMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            HashMap<String, String> property = new HashMap<String, String>();
            String propertyName = rs.getString("property_name");
            String propertyValue = rs.getString("property_value");
            property.put(propertyName, propertyValue);
            return property;
        }
    }

    private class ApplicationIdMapper
    implements RowMapper {
        private Map<String, String> originalIdMap = new HashMap<String, String>();

        private ApplicationIdMapper() {
            this.originalIdMap.put("crowd", "163841");
            this.originalIdMap.put("crowd-openid-server", "163842");
            this.originalIdMap.put("demo", "163843");
            this.originalIdMap.put("google-apps", "163844");
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString("id");
            String applicationName = rs.getString("application_name");
            String originalId = this.originalIdMap.get(applicationName);
            HashMap<String, String> idPair = new HashMap<String, String>();
            idPair.put(originalId, id);
            return idPair;
        }
    }

    private class OperationsMapper
    implements RowMapper {
        private OperationsMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return OperationType.valueOf((String)rs.getString("operation_type"));
        }
    }

    private class AttributeMapper
    implements RowMapper {
        private static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
        private static final String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";

        private AttributeMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            HashMap<String, String> attributePair = new HashMap<String, String>();
            String attributeName = rs.getString(ATTRIBUTE_NAME);
            String attributeValue = rs.getString(ATTRIBUTE_VALUE);
            attributePair.put(attributeName, attributeValue);
            return attributePair;
        }
    }
}

