/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.manager.application;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class ApplicationServiceIntegrationTest
extends BaseSpringTestCase {
    private ApplicationService applicationService;
    private ApplicationManager applicationManager;
    private DirectoryManager directoryManager;
    private PasswordEncoderFactory passwordEncoderFactory;
    private static final long DIRECTORY_1_ID = 32769L;
    private static final long DIRECTORY_2_ID = 32770L;

    public String getSampleDataFileName() {
        return "application-manager-test.xml";
    }

    protected String[] getConfigLocations() {
        ArrayList<String> configs = new ArrayList<String>(Arrays.asList(super.getConfigLocations()));
        configs.add("classpath:/applicationContext-CrowdManagers.xml");
        configs.add("classpath:/applicationContext-CrowdEncryption.xml");
        configs.add("classpath:/applicationContext-CrowdUtils.xml");
        configs.add("classpath:/applicationContext-internaldirectoryloader-config.xml");
        return configs.toArray(new String[configs.size()]);
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        this.passwordEncoderFactory.addEncoder((PasswordEncoder)new AtlassianSHA1PasswordEncoder());
    }

    public void testAddPrincipalOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        List directoryMappings = application.getDirectoryMappings();
        UserTemplateWithAttributes testUser = UserTemplateWithAttributes.ofUserWithNoAttributes((User)new UserTemplate("testuser"));
        testUser.setFirstName("beep");
        testUser.setLastName("boop");
        testUser.setEmailAddress("testuser@example.com");
        testUser.setAttribute("phone", "9568-7856");
        testUser.setAttribute("sn", "User");
        testUser.setAttribute("givenName", "Test");
        this.applicationService.addUser(application, (UserTemplate)testUser, new PasswordCredential("secret"));
        this.applicationService.storeUserAttributes(application, testUser.getName(), testUser.getAttributes());
        Long directoryID = ((DirectoryMapping)directoryMappings.get(0)).getDirectory().getId();
        UserWithAttributes savedUser = this.directoryManager.findUserWithAttributesByName(directoryID.longValue(), "testuser");
        ApplicationServiceIntegrationTest.assertEquals((String)testUser.getEmailAddress(), (String)savedUser.getEmailAddress());
        ApplicationServiceIntegrationTest.assertEquals((String)testUser.getName(), (String)savedUser.getName());
        ApplicationServiceIntegrationTest.assertEquals((String)testUser.getValue("sn"), (String)savedUser.getValue("sn"));
        ApplicationServiceIntegrationTest.assertEquals((String)testUser.getValue("phone"), (String)savedUser.getValue("phone"));
        ApplicationServiceIntegrationTest.assertEquals((String)testUser.getValue("givenName"), (String)savedUser.getValue("givenName"));
        directoryID = ((DirectoryMapping)directoryMappings.get(1)).getDirectory().getId();
        try {
            this.directoryManager.findUserWithAttributesByName(directoryID.longValue(), "testuser");
            ApplicationServiceIntegrationTest.fail((String)"The user should not have been created in the second directory.");
        }
        catch (UserNotFoundException ex) {
            // empty catch block
        }
    }

    public void testUpdatePrincipalOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        UserWithAttributes user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        ApplicationServiceIntegrationTest.assertEquals((String)"Super Man", (String)user1.getDisplayName());
        ApplicationServiceIntegrationTest.assertEquals((String)"Admin@example.com", (String)user1.getEmailAddress());
        UserWithAttributes user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        ApplicationServiceIntegrationTest.assertEquals((String)"Super Man", (String)user2.getDisplayName());
        ApplicationServiceIntegrationTest.assertEquals((String)"Admin@example.com", (String)user2.getEmailAddress());
        UserTemplate updatedUser = new UserTemplate((User)user1);
        updatedUser.setDisplayName("Peter Griffin");
        updatedUser.setEmailAddress("peterg@example.com");
        this.applicationService.updateUser(application, updatedUser);
        user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        ApplicationServiceIntegrationTest.assertEquals((String)"Peter Griffin", (String)user1.getDisplayName());
        ApplicationServiceIntegrationTest.assertEquals((String)"peterg@example.com", (String)user1.getEmailAddress());
        user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        ApplicationServiceIntegrationTest.assertEquals((String)"Super Man", (String)user2.getDisplayName());
        ApplicationServiceIntegrationTest.assertEquals((String)"Admin@example.com", (String)user2.getEmailAddress());
    }

    public void testAddPrincipalAttributeOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        UserWithAttributes user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        ApplicationServiceIntegrationTest.assertEquals((int)0, (int)user1.getValues("key").size());
        UserWithAttributes user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        ApplicationServiceIntegrationTest.assertEquals((int)0, (int)user2.getValues("key").size());
        HashSet<String> testValues = new HashSet<String>();
        testValues.add("val1");
        testValues.add("val2");
        TreeMap<String, HashSet<String>> testAttributes = new TreeMap<String, HashSet<String>>();
        testAttributes.put("key", testValues);
        this.applicationService.storeUserAttributes(application, "admin", testAttributes);
        user1 = this.directoryManager.findUserWithAttributesByName(32769L, "admin");
        Set savedValues = user1.getValues("key");
        ApplicationServiceIntegrationTest.assertEquals((int)2, (int)savedValues.size());
        ApplicationServiceIntegrationTest.assertTrue((boolean)savedValues.contains("val1"));
        ApplicationServiceIntegrationTest.assertTrue((boolean)savedValues.contains("val2"));
        user2 = this.directoryManager.findUserWithAttributesByName(32770L, "admin");
        ApplicationServiceIntegrationTest.assertEquals((int)0, (int)user2.getValues("key").size());
    }

    public void testAddGroupOverMultipleInternalDirectories() throws Exception {
        Application application = this.applicationManager.findByName("crowd");
        List directoryMappings = application.getDirectoryMappings();
        GroupTemplateWithAttributes testGroup = new GroupTemplateWithAttributes("testgroup", -1L, GroupType.GROUP);
        testGroup.setDescription("test description");
        testGroup.setActive(true);
        this.applicationService.addGroup(application, (GroupTemplate)testGroup);
        for (DirectoryMapping directoryMapping : directoryMappings) {
            GroupWithAttributes savedGroup = this.directoryManager.findGroupWithAttributesByName(directoryMapping.getDirectory().getId().longValue(), "testgroup");
            ApplicationServiceIntegrationTest.assertEquals((String)testGroup.getName(), (String)savedGroup.getName());
            ApplicationServiceIntegrationTest.assertEquals((String)testGroup.getDescription(), (String)savedGroup.getDescription());
            ApplicationServiceIntegrationTest.assertEquals((boolean)testGroup.isActive(), (boolean)savedGroup.isActive());
        }
    }

    public void testAddRoleOverMultipleInternalDirectories() throws Exception {
    }

    public void testStoreAndRemoveUserAttributes() throws Exception {
        Application application = this.applicationManager.findByName("demo");
        this.applicationService.storeUserAttributes(application, "testuser", Collections.singletonMap("testKey", Collections.singleton("testValue")));
        this.applicationService.removeUserAttributes(application, "testuser", "testKey");
    }

    public void testStoreAndRemoveGroupAttributes() throws Exception {
        Application application = this.applicationManager.findByName("demo");
        this.applicationService.storeGroupAttributes(application, "testgroup", Collections.singletonMap("testKey", Collections.singleton("testValue")));
        this.applicationService.removeGroupAttributes(application, "testgroup", "testKey");
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }
}

