/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.directory;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.Assert;

public class InternalDirectoryIntegrationTest
extends BaseSpringTestCase {
    private DirectoryDao directoryDao;
    private InternalDirectory internalDirectory;
    private DirectoryInstanceLoader directoryInstanceLoader;
    private static final long DIRECTORY_ID = 1L;
    private static final String DIRECTORY_NAME = "directory1";
    private static final String GROUP1_NAME = "administratorS";
    private static final String GROUP2_NAME = "users";
    private static final String GROUP_DESCRIPTION = "The Administrator Group";
    private static final String USER_NAME = "admin";
    private static final String USER_DISPLAYNAME = "Super Man";
    private static final long INVALID_DIRECTORY_ID = 4L;
    private static final String NEW_GROUP_NAME = "brand-New-group";
    private static final String NEW_GROUP_DESCRIPTION = "New Test Group";
    private GroupTemplate newGroup;
    private static final String NEW_GROUP_NAME2 = "brand-new-group2";
    private static final String NEW_GROUP_DESCRIPTION2 = "New Test Group2";
    private GroupTemplate newGroup2;
    private static final String NEW_GROUP_NAME3 = "brand-new-group3";
    private static final String NEW_GROUP_DESCRIPTION3 = "New Test Group3";
    private GroupTemplate newGroup3;
    private static final String NEW_USER_NAME = "New-User";
    private static final String NEW_USER_DISPLAY_NAME = "New Person";
    private UserTemplate newUser;
    private static final String NEW_USER_NAME2 = "new-user2";
    private static final String NEW_USER_DISPLAY_NAME2 = "New Person2";
    private UserTemplate newUser2;
    private static final String NEW_USER_NAME3 = "new-user3";
    private static final String NEW_USER_DISPLAY_NAME3 = "New Person3";
    private UserTemplate newUser3;
    private PasswordCredential passwordCredential;

    protected String[] getConfigLocations() {
        ArrayList<String> configs = new ArrayList<String>(Arrays.asList(super.getConfigLocations()));
        configs.add("classpath:/applicationContext-CrowdUtils.xml");
        return configs.toArray(new String[configs.size()]);
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.internalDirectory = this.getInternalDirectory();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("password_regex", "");
        attributes.put("user_encryption_method", "");
        this.internalDirectory.setAttributes(attributes);
        this.newGroup = this.makeGroup(NEW_GROUP_NAME, 1L, NEW_GROUP_DESCRIPTION);
        this.newGroup2 = this.makeGroup(NEW_GROUP_NAME2, 1L, NEW_GROUP_DESCRIPTION2);
        this.newGroup3 = this.makeGroup(NEW_GROUP_NAME3, 1L, NEW_GROUP_DESCRIPTION3);
        this.newUser = this.makeUser(NEW_USER_NAME, 1L, NEW_USER_DISPLAY_NAME);
        this.newUser2 = this.makeUser(NEW_USER_NAME2, 1L, NEW_USER_DISPLAY_NAME2);
        this.newUser3 = this.makeUser(NEW_USER_NAME3, 1L, NEW_USER_DISPLAY_NAME3);
        this.passwordCredential = new PasswordCredential("secret");
        this.passwordCredential.setEncryptedCredential(true);
    }

    private GroupTemplate makeGroup(String name, long directoryID, String description) {
        GroupTemplate group = new GroupTemplate(name, directoryID, GroupType.GROUP);
        group.setDescription(description);
        return group;
    }

    private UserTemplate makeUser(String name, long directoryID, String displayName) {
        UserTemplate user = new UserTemplate(name, directoryID);
        user.setDisplayName(displayName);
        user.setFirstName("first");
        user.setLastName("last");
        user.setEmailAddress(name + "@blah.com");
        return user;
    }

    public InternalDirectory getInternalDirectory() throws Exception {
        Directory directory = this.directoryDao.findByName(DIRECTORY_NAME);
        return (InternalDirectory)this.directoryInstanceLoader.getDirectory(directory);
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    public void setDirectoryInstanceLoader(DirectoryInstanceLoader directoryInstanceLoader) {
        this.directoryInstanceLoader = directoryInstanceLoader;
    }

    public String getSampleDataFileName() {
        return "sample-data.xml";
    }

    public void testAddUser() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, "New Guy");
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        InternalDirectoryIntegrationTest.assertEquals((String)"new", (String)foundUser.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"New Guy", (String)foundUser.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first", (String)foundUser.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last", (String)foundUser.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new@blah.com", (String)foundUser.getEmailAddress());
    }

    public void testAddUser_displayNameCalculated() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, null);
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        InternalDirectoryIntegrationTest.assertEquals((String)"new", (String)foundUser.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first last", (String)foundUser.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first", (String)foundUser.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last", (String)foundUser.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new@blah.com", (String)foundUser.getEmailAddress());
    }

    public void testAddUser_firstNameLastNameCalculated() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, "new guy");
        user.setFirstName(null);
        user.setLastName(null);
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        InternalDirectoryIntegrationTest.assertEquals((String)"new", (String)foundUser.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new guy", (String)foundUser.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new", (String)foundUser.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"guy", (String)foundUser.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new@blah.com", (String)foundUser.getEmailAddress());
    }

    public void testAddUser_AllCalculated() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, null);
        user.setFirstName(null);
        user.setLastName(null);
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        InternalDirectoryIntegrationTest.assertEquals((String)"new", (String)foundUser.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new", (String)foundUser.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"", (String)foundUser.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new", (String)foundUser.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"new@blah.com", (String)foundUser.getEmailAddress());
    }

    public void testUpdateUser_DisplayNameCalculated() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setDisplayName("");
        template.setFirstName("first");
        template.setLastName("last");
        this.internalDirectory.updateUser(template);
        TimestampedUser foundUser = this.internalDirectory.findUserByName(USER_NAME);
        InternalDirectoryIntegrationTest.assertEquals((String)USER_NAME, (String)foundUser.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first last", (String)foundUser.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first", (String)foundUser.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last", (String)foundUser.getLastName());
    }

    public void testUpdateUser_firstNameLastNameCalculated() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setDisplayName("first last");
        template.setFirstName(null);
        template.setLastName(null);
        this.internalDirectory.updateUser(template);
        TimestampedUser foundUser = this.internalDirectory.findUserByName(USER_NAME);
        InternalDirectoryIntegrationTest.assertEquals((String)USER_NAME, (String)foundUser.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first last", (String)foundUser.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first", (String)foundUser.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last", (String)foundUser.getLastName());
    }

    public void testUpdateUser_AllCalculated() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setDisplayName(null);
        template.setFirstName(null);
        template.setLastName(null);
        this.internalDirectory.updateUser(template);
        TimestampedUser foundUser = this.internalDirectory.findUserByName(USER_NAME);
        InternalDirectoryIntegrationTest.assertEquals((String)USER_NAME, (String)foundUser.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)USER_NAME, (String)foundUser.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"", (String)foundUser.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)USER_NAME, (String)foundUser.getLastName());
    }

    public void testAddGroup() throws Exception {
        try {
            this.internalDirectory.findGroupByName(NEW_GROUP_NAME);
            Assert.fail((String)"GroupNotFoundException exepcted since Group should not exist");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        this.internalDirectory.addGroup(this.newGroup);
        InternalDirectoryGroup group = this.internalDirectory.findGroupByName(NEW_GROUP_NAME);
        Assert.assertEquals((String)NEW_GROUP_DESCRIPTION, (String)group.getDescription());
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME}));
    }

    public void testAddGroupInvalidDirectoryId() throws Exception {
        GroupTemplate invalidGroup = new GroupTemplate(NEW_GROUP_NAME, 4L, GroupType.GROUP);
        try {
            this.internalDirectory.findGroupByName(NEW_GROUP_NAME);
            Assert.fail((String)"GroupNotFoundException exepcted since Group should not exist");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        try {
            this.internalDirectory.addGroup(invalidGroup);
            Assert.fail((String)"IllegalArgumentException expected - group has invalid directory id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME}), (int)0);
    }

    public void testUpdateGroup() throws Exception {
        GroupTemplate groupDiffDescription = this.makeGroup(GROUP1_NAME, 1L, NEW_GROUP_DESCRIPTION);
        InternalDirectoryGroup group = this.internalDirectory.findGroupByName(GROUP1_NAME);
        Assert.assertEquals((String)GROUP_DESCRIPTION, (String)group.getDescription());
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{GROUP1_NAME}));
        this.internalDirectory.updateGroup(groupDiffDescription);
        InternalDirectoryGroup updatedGroup = this.internalDirectory.findGroupByName(groupDiffDescription.getName());
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{groupDiffDescription.getName()}));
        Assert.assertEquals((long)group.getDirectoryId(), (long)updatedGroup.getDirectoryId());
        Assert.assertEquals((String)group.getName(), (String)updatedGroup.getName());
        Assert.assertEquals((String)NEW_GROUP_DESCRIPTION, (String)updatedGroup.getDescription());
    }

    public void testRemoveGroup() throws Exception {
        InternalDirectoryGroup group = this.internalDirectory.findGroupByName(GROUP1_NAME);
        Assert.assertEquals((String)GROUP_DESCRIPTION, (String)group.getDescription());
        Assert.assertTrue((this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ?", new Object[]{GROUP1_NAME}) > 0 ? 1 : 0) != 0);
        this.internalDirectory.removeGroup(GROUP1_NAME);
        try {
            this.internalDirectory.findGroupByName(GROUP1_NAME);
            Assert.fail((String)"GroupNotFoundException exepcted since Group should have been deleted");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ?", new Object[]{GROUP1_NAME}));
    }

    public void testRemoveUser() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        Assert.assertEquals((String)USER_DISPLAYNAME, (String)user.getDisplayName());
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, USER_NAME}));
        this.internalDirectory.removeUser(USER_NAME);
        try {
            this.internalDirectory.findUserByName(USER_NAME);
            Assert.fail((String)"UserNotFoundException exepcted since User should have been deleted");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, USER_NAME}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where child_name = ?", new Object[]{USER_NAME}));
    }

    public void testAddRemoveGroupToGroup() throws Exception {
        this.internalDirectory.addGroup(this.newGroup);
        Assert.assertFalse((boolean)this.internalDirectory.isGroupDirectGroupMember(this.newGroup.getName(), GROUP1_NAME));
        this.internalDirectory.addGroupToGroup(this.newGroup.getName(), GROUP1_NAME);
        Assert.assertTrue((boolean)this.internalDirectory.isGroupDirectGroupMember(this.newGroup.getName(), GROUP1_NAME));
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newGroup.getName()}));
        this.internalDirectory.removeGroupFromGroup(this.newGroup.getName(), GROUP1_NAME);
        Assert.assertFalse((boolean)this.internalDirectory.isGroupDirectGroupMember(this.newGroup.getName(), GROUP1_NAME));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newGroup.getName()}));
    }

    public void testRemoveGroupFromGroupNotMember() throws Exception {
        this.internalDirectory.addGroup(this.newGroup);
        try {
            this.internalDirectory.removeGroupFromGroup(this.newGroup.getName(), GROUP1_NAME);
            Assert.fail((String)"MembershipNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    public void testAddUserToGroup() throws Exception {
        this.internalDirectory.addUser(this.newUser, this.passwordCredential);
        Assert.assertFalse((boolean)this.internalDirectory.isUserDirectGroupMember(this.newUser.getName(), GROUP1_NAME));
        this.internalDirectory.addUserToGroup(this.newUser.getName(), GROUP1_NAME);
        Assert.assertTrue((boolean)this.internalDirectory.isUserDirectGroupMember(this.newUser.getName(), GROUP1_NAME));
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newUser.getName()}));
        this.internalDirectory.removeUserFromGroup(this.newUser.getName(), GROUP1_NAME);
        Assert.assertFalse((boolean)this.internalDirectory.isUserDirectGroupMember(this.newUser.getName(), GROUP1_NAME));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newUser.getName()}));
    }

    public void testRemoveUserFromGroup() throws Exception {
        this.internalDirectory.addUser(this.newUser, this.passwordCredential);
        try {
            this.internalDirectory.removeUserFromGroup(this.newUser.getName(), GROUP1_NAME);
            Assert.fail((String)"MembershipNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    public void testAddAllUsers() throws Exception {
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.newUser, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.newUser2, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.newUser3, this.passwordCredential));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{NEW_USER_NAME}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{NEW_USER_NAME2}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{NEW_USER_NAME3}));
        this.internalDirectory.addAllUsers(usersToAdd);
        this.internalDirectory.findUserByName(this.newUser.getName());
        this.internalDirectory.findUserByName(this.newUser2.getName());
        this.internalDirectory.findUserByName(this.newUser3.getName());
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{NEW_USER_NAME}));
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{NEW_USER_NAME2}));
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{NEW_USER_NAME3}));
    }

    public void testAddAllUsers_displayNameCalculated() throws Exception {
        UserTemplate user1 = this.makeUser("user1", 1L, null);
        user1.setFirstName("first1");
        user1.setLastName("last1");
        UserTemplate user2 = this.makeUser("user2", 1L, null);
        user2.setFirstName("first2");
        user2.setLastName("last2");
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user1, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user2, this.passwordCredential));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{"user1"}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{"user2"}));
        this.internalDirectory.addAllUsers(usersToAdd);
        TimestampedUser foundUser1 = this.internalDirectory.findUserByName(user1.getName());
        TimestampedUser foundUser2 = this.internalDirectory.findUserByName(user2.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1", (String)foundUser1.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first1 last1", (String)foundUser1.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first1", (String)foundUser1.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last1", (String)foundUser1.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1@blah.com", (String)foundUser1.getEmailAddress());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2", (String)foundUser2.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first2 last2", (String)foundUser2.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first2", (String)foundUser2.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last2", (String)foundUser2.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2@blah.com", (String)foundUser2.getEmailAddress());
    }

    public void testAddAllUsers_firstNameLastNameCalculated() throws Exception {
        UserTemplate user1 = this.makeUser("user1", 1L, "first1 last1");
        user1.setFirstName(null);
        user1.setLastName(null);
        UserTemplate user2 = this.makeUser("user2", 1L, "first2 last2");
        user2.setFirstName(null);
        user2.setLastName(null);
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user1, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user2, this.passwordCredential));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{"user1"}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{"user2"}));
        this.internalDirectory.addAllUsers(usersToAdd);
        TimestampedUser foundUser1 = this.internalDirectory.findUserByName(user1.getName());
        TimestampedUser foundUser2 = this.internalDirectory.findUserByName(user2.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1", (String)foundUser1.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first1 last1", (String)foundUser1.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first1", (String)foundUser1.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last1", (String)foundUser1.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1@blah.com", (String)foundUser1.getEmailAddress());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2", (String)foundUser2.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first2 last2", (String)foundUser2.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"first2", (String)foundUser2.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"last2", (String)foundUser2.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2@blah.com", (String)foundUser2.getEmailAddress());
    }

    public void testAddAllUsers_AllCalculated() throws Exception {
        UserTemplate user1 = this.makeUser("user1", 1L, null);
        user1.setFirstName(null);
        user1.setLastName(null);
        UserTemplate user2 = this.makeUser("user2", 1L, null);
        user2.setFirstName(null);
        user2.setLastName(null);
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user1, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user2, this.passwordCredential));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{"user1"}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where user_name = ?", new Object[]{"user2"}));
        this.internalDirectory.addAllUsers(usersToAdd);
        TimestampedUser foundUser1 = this.internalDirectory.findUserByName(user1.getName());
        TimestampedUser foundUser2 = this.internalDirectory.findUserByName(user2.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1", (String)foundUser1.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1", (String)foundUser1.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"", (String)foundUser1.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1", (String)foundUser1.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user1@blah.com", (String)foundUser1.getEmailAddress());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2", (String)foundUser2.getName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2", (String)foundUser2.getDisplayName());
        InternalDirectoryIntegrationTest.assertEquals((String)"", (String)foundUser2.getFirstName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2", (String)foundUser2.getLastName());
        InternalDirectoryIntegrationTest.assertEquals((String)"user2@blah.com", (String)foundUser2.getEmailAddress());
    }

    public void testAddAllUsersToGroup() throws Exception {
        this.internalDirectory.addUser(this.newUser, this.passwordCredential);
        this.internalDirectory.addUser(this.newUser2, this.passwordCredential);
        this.internalDirectory.addUser(this.newUser3, this.passwordCredential);
        HashSet<String> usersToAdd = new HashSet<String>();
        usersToAdd.add(this.newUser.getName());
        usersToAdd.add(this.newUser2.getName());
        usersToAdd.add(this.newUser3.getName());
        Collection failedUsers = this.internalDirectory.addAllUsersToGroup(usersToAdd, GROUP1_NAME);
        Assert.assertEquals((int)0, (int)failedUsers.size());
        Assert.assertTrue((this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where parent_name = ? ", new Object[]{GROUP1_NAME}) >= 3 ? 1 : 0) != 0);
    }

    public void testAddAllGroups() throws Exception {
        HashSet<GroupTemplate> groupsToAdd = new HashSet<GroupTemplate>();
        groupsToAdd.add(this.newGroup);
        groupsToAdd.add(this.newGroup2);
        groupsToAdd.add(this.newGroup3);
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME2}));
        Assert.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME3}));
        this.internalDirectory.addAllGroups(groupsToAdd);
        this.internalDirectory.findGroupByName(this.newGroup.getName());
        this.internalDirectory.findGroupByName(this.newGroup2.getName());
        this.internalDirectory.findGroupByName(this.newGroup3.getName());
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME2}));
        Assert.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where group_name = ?", new Object[]{NEW_GROUP_NAME3}));
    }
}

