/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.group;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.BatchResult;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.support.rowset.SqlRowSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOHibernateTest
extends BaseSpringTestCase {
    private GroupDAOHibernate groupDAO;
    private MembershipDAOHibernate membershipDAO;
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_GROUP_1 = "administratorS";
    private static final String EXISTING_GROUP_1_DESC = "The Administrator Group";
    private static final String EXISTING_GROUP_2 = "users";
    private static final String EXISTING_GROUP_3 = "developers";
    private static final String NON_EXISTING_GROUP = "NewGroup";
    private static final String COUNTRY_ATTRIBUTE = "country";
    private static final String CITY_ATTRIBUTE = "city";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String NON_EXISTING_GROUP_DESC = "New Group";
    private static final String UPDATED_DESCRIPTION = "Updated Description";
    private static final String COUNTRY_VALUE_NZ = "New Zealand";
    private static final String COUNTRY_VALUE_AU = "Australia";
    private static final String COUNTRY_VALUE_CN = "China";
    private static final String CITY_VALUE_SYD = "Sydney";
    private static final String LANGUAGE_ATTRIBUTE_VALUE = "Sheepish";

    public void testFindByName() throws Exception {
        InternalGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        GroupDAOHibernateTest.assertEquals((String)EXISTING_GROUP_1, (String)group.getName());
        GroupDAOHibernateTest.assertEquals((String)EXISTING_GROUP_1_DESC, (String)group.getDescription());
        GroupDAOHibernateTest.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
        GroupDAOHibernateTest.assertTrue((boolean)group.isActive());
        GroupDAOHibernateTest.assertTrue((boolean)group.getCreatedDate().before(new Date()));
        GroupDAOHibernateTest.assertTrue((boolean)group.getUpdatedDate().before(new Date()));
        GroupDAOHibernateTest.assertEquals((long)1L, (long)group.getDirectoryId());
        GroupDAOHibernateTest.assertTrue((boolean)((HibernateProxy)group.getDirectory()).getHibernateLazyInitializer().isUninitialized());
    }

    public void testFindByNameMixedCase() throws Exception {
        InternalGroup group = this.groupDAO.findByName(2L, "teSterS");
        GroupDAOHibernateTest.assertEquals((String)"Testers", (String)group.getName());
        GroupDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"Testers"), (String)group.getLowerName());
        GroupDAOHibernateTest.assertEquals((String)"The Crowd Tester Crew", (String)group.getDescription());
        GroupDAOHibernateTest.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
        GroupDAOHibernateTest.assertTrue((boolean)group.isActive());
        GroupDAOHibernateTest.assertTrue((boolean)group.getCreatedDate().before(new Date()));
        GroupDAOHibernateTest.assertTrue((boolean)group.getUpdatedDate().before(new Date()));
        GroupDAOHibernateTest.assertEquals((long)2L, (long)group.getDirectoryId());
        GroupDAOHibernateTest.assertTrue((boolean)((HibernateProxy)group.getDirectory()).getHibernateLazyInitializer().isUninitialized());
    }

    public void testFindByNameDoesNotExist() throws Exception {
        try {
            this.groupDAO.findByName(1L, NON_EXISTING_GROUP);
            GroupDAOHibernateTest.fail((String)"Should of thrown GroupNotFoundException");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testFindByNameWithAttributes() throws Exception {
        InternalGroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        GroupDAOHibernateTest.assertEquals((String)EXISTING_GROUP_1, (String)group.getName());
        GroupDAOHibernateTest.assertTrue((boolean)group.isActive());
        GroupDAOHibernateTest.assertEquals((String)EXISTING_GROUP_1_DESC, (String)group.getDescription());
        GroupDAOHibernateTest.assertEquals((long)1L, (long)group.getDirectoryId());
        GroupDAOHibernateTest.assertEquals((int)2, (int)group.getKeys().size());
        GroupDAOHibernateTest.assertTrue((boolean)group.getKeys().contains(COUNTRY_ATTRIBUTE));
        GroupDAOHibernateTest.assertTrue((boolean)group.getKeys().contains(LANGUAGE_ATTRIBUTE));
        GroupDAOHibernateTest.assertEquals((int)2, (int)group.getValues(COUNTRY_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_NZ));
        GroupDAOHibernateTest.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_AU));
        GroupDAOHibernateTest.assertEquals((int)1, (int)group.getValues(LANGUAGE_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertEquals((String)LANGUAGE_ATTRIBUTE_VALUE, (String)group.getValue(LANGUAGE_ATTRIBUTE));
    }

    public void testFindByMixedCaseNameWithAttributes() throws Exception {
        InternalGroupWithAttributes group = this.groupDAO.findByNameWithAttributes(2L, "TestErs");
        GroupDAOHibernateTest.assertEquals((String)"Testers", (String)group.getName());
        GroupDAOHibernateTest.assertEquals((String)"testers", (String)group.getInternalGroup().getLowerName());
        GroupDAOHibernateTest.assertTrue((boolean)group.isActive());
        GroupDAOHibernateTest.assertEquals((String)"The Crowd Tester Crew", (String)group.getDescription());
        GroupDAOHibernateTest.assertEquals((long)2L, (long)group.getDirectoryId());
        GroupDAOHibernateTest.assertEquals((int)1, (int)group.getKeys().size());
        GroupDAOHibernateTest.assertTrue((boolean)group.getKeys().contains(CITY_ATTRIBUTE));
        GroupDAOHibernateTest.assertEquals((int)1, (int)group.getValues(CITY_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertTrue((boolean)group.getValues(CITY_ATTRIBUTE).contains("Perth"));
    }

    public void testAdd() throws Exception {
        Group createdGroup = this.createNewGroup(NON_EXISTING_GROUP);
        GroupDAOHibernateTest.assertNotNull((Object)createdGroup);
        GroupDAOHibernateTest.assertTrue((((InternalGroup)createdGroup).getId() > 0L ? 1 : 0) != 0);
        InternalGroup foundGroup = this.groupDAO.findByName(1L, NON_EXISTING_GROUP.toUpperCase());
        GroupDAOHibernateTest.assertEquals((String)NON_EXISTING_GROUP, (String)foundGroup.getName());
        GroupDAOHibernateTest.assertEquals((boolean)true, (boolean)foundGroup.isActive());
        GroupDAOHibernateTest.assertEquals((String)NON_EXISTING_GROUP_DESC, (String)foundGroup.getDescription());
        GroupDAOHibernateTest.assertEquals((Object)GroupType.GROUP, (Object)foundGroup.getType());
    }

    public void testAddMixedCaseDuplicate() throws Exception {
        try {
            this.createNewGroup("AdministratorS");
            this.flush();
            GroupDAOHibernateTest.fail((String)"DataIntegrityViolationException expected");
        }
        catch (DataIntegrityViolationException e) {
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testUpdate() throws Exception {
        InternalGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        GroupTemplate groupTemplate = new GroupTemplate((Group)group);
        groupTemplate.setActive(false);
        groupTemplate.setDescription(UPDATED_DESCRIPTION);
        this.groupDAO.update((Group)groupTemplate);
        InternalGroup foundGroup = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        GroupDAOHibernateTest.assertEquals((String)EXISTING_GROUP_1, (String)foundGroup.getName());
        GroupDAOHibernateTest.assertEquals((boolean)false, (boolean)foundGroup.isActive());
        GroupDAOHibernateTest.assertEquals((String)UPDATED_DESCRIPTION, (String)foundGroup.getDescription());
        GroupDAOHibernateTest.assertEquals((Object)GroupType.GROUP, (Object)foundGroup.getType());
    }

    public void testUpdateTypeChangeFail() throws Exception {
        InternalGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        GroupTemplate groupTemplate = new GroupTemplate((Group)group);
        groupTemplate.setActive(false);
        groupTemplate.setDescription(UPDATED_DESCRIPTION);
        groupTemplate.setType(GroupType.LEGACY_ROLE);
        try {
            this.groupDAO.update((Group)groupTemplate);
            GroupDAOHibernateTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRename() throws Exception {
        InternalGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        this.groupDAO.rename((Group)group, NON_EXISTING_GROUP);
        try {
            this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        InternalGroup renamedGroup = this.groupDAO.findByName(1L, NON_EXISTING_GROUP);
        GroupDAOHibernateTest.assertEquals((String)NON_EXISTING_GROUP, (String)renamedGroup.getName());
        GroupDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(EXISTING_GROUP_1).returningAtMost(10)).size());
        GroupDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(NON_EXISTING_GROUP.toUpperCase()).returningAtMost(10)).size());
        List groups = this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("admin").returningAtMost(10));
        this.assertContains(groups, NON_EXISTING_GROUP);
        List groupNames = this.membershipDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("admin").returningAtMost(10));
        GroupDAOHibernateTest.assertTrue((boolean)groupNames.contains(NON_EXISTING_GROUP));
    }

    public void testRemove() throws Exception {
        InternalGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_2);
        this.groupDAO.remove((Group)group);
        try {
            this.groupDAO.findByName(1L, EXISTING_GROUP_2);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        GroupDAOHibernateTest.assertTrue((boolean)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(EXISTING_GROUP_2).returningAtMost(10)).isEmpty());
        GroupDAOHibernateTest.assertTrue((boolean)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(EXISTING_GROUP_2).returningAtMost(10)).isEmpty());
        GroupDAOHibernateTest.assertTrue((boolean)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(EXISTING_GROUP_2).returningAtMost(10)).isEmpty());
    }

    public void testRemoveAll() {
        this.groupDAO.removeAll(1L);
        GroupDAOHibernateTest.assertTrue((boolean)this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(10)).isEmpty());
        GroupDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from cwd_membership where directory_id = 1"));
    }

    public void testStoreAttributesWithInsertForNewGroup() throws Exception {
        Group createdGroup = this.createNewGroup(NON_EXISTING_GROUP);
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"Blue", "Green"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.groupDAO.storeAttributes(createdGroup, attributes);
        InternalGroupWithAttributes returnedGroup = this.groupDAO.findByNameWithAttributes(1L, NON_EXISTING_GROUP.toUpperCase());
        GroupDAOHibernateTest.assertEquals((int)2, (int)returnedGroup.getKeys().size());
        GroupDAOHibernateTest.assertEquals((int)2, (int)returnedGroup.getValues("color").size());
        GroupDAOHibernateTest.assertTrue((boolean)returnedGroup.getValues("color").contains("Blue"));
        GroupDAOHibernateTest.assertTrue((boolean)returnedGroup.getValues("color").contains("Green"));
        GroupDAOHibernateTest.assertEquals((int)1, (int)returnedGroup.getValues("phone").size());
        GroupDAOHibernateTest.assertTrue((boolean)returnedGroup.getValues("phone").contains("131111"));
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("select attribute_lower_value from cwd_group_attribute where group_id = " + returnedGroup.getInternalGroup().getId());
        HashSet<String> lowerCaseAttributeValues = new HashSet<String>();
        while (sqlRowSet.next()) {
            lowerCaseAttributeValues.add(sqlRowSet.getString("attribute_lower_value"));
        }
        GroupDAOHibernateTest.assertEquals((int)3, (int)lowerCaseAttributeValues.size());
        GroupDAOHibernateTest.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Blue")));
        GroupDAOHibernateTest.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Green")));
        GroupDAOHibernateTest.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"131111")));
    }

    public void testStoreAttributesWithUpdateAndInsertForExistingGroup() throws Exception {
        InternalGroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        GroupDAOHibernateTest.assertEquals((int)2, (int)group.getKeys().size());
        GroupDAOHibernateTest.assertTrue((boolean)group.getKeys().contains(COUNTRY_ATTRIBUTE));
        GroupDAOHibernateTest.assertTrue((boolean)group.getKeys().contains(LANGUAGE_ATTRIBUTE));
        GroupDAOHibernateTest.assertEquals((int)2, (int)group.getValues(COUNTRY_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_NZ));
        GroupDAOHibernateTest.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_AU));
        GroupDAOHibernateTest.assertEquals((int)1, (int)group.getValues(LANGUAGE_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertEquals((String)LANGUAGE_ATTRIBUTE_VALUE, (String)group.getValue(LANGUAGE_ATTRIBUTE));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put(COUNTRY_ATTRIBUTE, Sets.newHashSet((Object[])new String[]{COUNTRY_VALUE_NZ, "UK", "U.S.A"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.groupDAO.storeAttributes((Group)group, attributes);
        InternalGroupWithAttributes returnedGroup = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1.toUpperCase());
        GroupDAOHibernateTest.assertEquals((int)3, (int)returnedGroup.getKeys().size());
        GroupDAOHibernateTest.assertEquals((int)3, (int)returnedGroup.getValues(COUNTRY_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertTrue((boolean)returnedGroup.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_NZ));
        GroupDAOHibernateTest.assertTrue((boolean)returnedGroup.getValues(COUNTRY_ATTRIBUTE).contains("UK"));
        GroupDAOHibernateTest.assertTrue((boolean)returnedGroup.getValues(COUNTRY_ATTRIBUTE).contains("U.S.A"));
        GroupDAOHibernateTest.assertEquals((int)1, (int)returnedGroup.getValues("phone").size());
        GroupDAOHibernateTest.assertTrue((boolean)returnedGroup.getValues("phone").contains("131111"));
        GroupDAOHibernateTest.assertEquals((int)1, (int)group.getValues(LANGUAGE_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertEquals((String)LANGUAGE_ATTRIBUTE_VALUE, (String)group.getValue(LANGUAGE_ATTRIBUTE));
    }

    public void testRemoveAttribute() throws Exception {
        InternalGroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        GroupDAOHibernateTest.assertEquals((int)2, (int)group.getKeys().size());
        this.groupDAO.removeAttribute((Group)group, COUNTRY_ATTRIBUTE);
        InternalGroupWithAttributes updatedGroup = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1.toUpperCase());
        GroupDAOHibernateTest.assertEquals((int)1, (int)updatedGroup.getKeys().size());
        GroupDAOHibernateTest.assertEquals((int)1, (int)updatedGroup.getValues(LANGUAGE_ATTRIBUTE).size());
        GroupDAOHibernateTest.assertEquals((String)LANGUAGE_ATTRIBUTE_VALUE, (String)updatedGroup.getValue(LANGUAGE_ATTRIBUTE));
    }

    private void assertContainsExactly(List<Group> groups, String ... groupnames) {
        GroupDAOHibernateTest.assertEquals((int)groupnames.length, (int)groups.size());
        int index = 0;
        for (Group group : groups) {
            GroupDAOHibernateTest.assertEquals((String)groupnames[index], (String)group.getName());
            ++index;
        }
    }

    private void assertContains(List<Group> groups, String groupname) {
        GroupDAOHibernateTest.assertTrue((String)("Group " + groupname + " not found in " + groups), (boolean)this.contains(groups, groupname));
    }

    private boolean contains(List<Group> groups, String groupname) {
        for (Group group : groups) {
            if (!group.getName().equals(groupname)) continue;
            return true;
        }
        return false;
    }

    public void testSearchAllGroupNames() {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(10);
        List groups = this.groupDAO.search(1L, query);
        GroupDAOHibernateTest.assertEquals(Arrays.asList(EXISTING_GROUP_1, EXISTING_GROUP_3), (Object)groups);
    }

    public void testSearchGroupNameStartsWith() {
        TermRestriction groupNameRestriction = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1);
    }

    public void testSearchGroupTypeRole() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).returningAtMost(-1);
        List groups = this.groupDAO.search(1L, query);
        this.assertContainsExactly(groups, EXISTING_GROUP_2);
    }

    public void testSearchGroupTypeGroup() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1);
        List groups = this.groupDAO.search(1L, query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1, EXISTING_GROUP_3);
    }

    public void testSearchForActiveGroupsUsingBuilder() {
        PropertyRestriction booleanRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)true);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)booleanRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1);
    }

    public void testSearchForInactiveGroupsUsingBuilder() {
        PropertyRestriction booleanRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)false);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)booleanRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_3);
    }

    public void testSearchCountryExact() {
        TermRestriction groupNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1);
    }

    public void testSearchCountryNoResults() {
        TermRestriction groupNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)"canada");
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        GroupDAOHibernateTest.assertEquals((int)0, (int)groups.size());
    }

    public void testSearchNullAttribute() {
        TermRestriction groupAttributeRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)LANGUAGE_ATTRIBUTE), MatchMode.NULL, null);
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupAttributeRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        GroupDAOHibernateTest.assertEquals((int)1, (int)groups.size());
    }

    public void testSearchFirstClassDisjunction() {
        TermRestriction groupNameRestriction1 = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        TermRestriction groupNameRestriction2 = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"u");
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{groupNameRestriction1, groupNameRestriction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1);
    }

    public void testSearchFirstClassConjunction() {
        TermRestriction groupNameRestriction = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)true);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{groupNameRestriction, activeRestriction});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1);
    }

    public void testSearchSecondClassDisjuction() {
        TermRestriction countryRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        TermRestriction countryRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)CITY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)CITY_VALUE_SYD);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{countryRestriction1, countryRestriction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1, EXISTING_GROUP_3);
    }

    public void testSearchSecondClassConjunction() {
        TermRestriction countryRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        TermRestriction countryRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_CN);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{countryRestriction1, countryRestriction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.LEGACY_ROLE, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_2);
    }

    public void testSearchMixedClassDisjunction() {
        TermRestriction countryRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_AU);
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)false);
        BooleanRestrictionImpl groupNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{countryRestriction, activeRestriction});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)groupNameDisjunction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1, EXISTING_GROUP_3);
    }

    public void testSearchMixedClassConjunction() {
        TermRestriction cityRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)CITY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)CITY_VALUE_SYD);
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)true);
        BooleanRestrictionImpl groupNameConjuction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{cityRestriction, activeRestriction});
        GroupQuery query = new GroupQuery(Group.class, GroupType.LEGACY_ROLE, (SearchRestriction)groupNameConjuction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_2);
    }

    public void testSearchNested() {
        TermRestriction cityRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)CITY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)CITY_VALUE_SYD);
        TermRestriction activeRestriction = new TermRestriction(GroupTermKeys.ACTIVE, (Object)true);
        BooleanRestrictionImpl conjunction1 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{cityRestriction, activeRestriction});
        TermRestriction countryRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)COUNTRY_ATTRIBUTE), MatchMode.EXACTLY_MATCHES, (Object)COUNTRY_VALUE_NZ);
        TermRestriction groupNameRestriction = new TermRestriction(GroupTermKeys.NAME, MatchMode.STARTS_WITH, (Object)"a");
        BooleanRestrictionImpl conjunction2 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{countryRestriction, groupNameRestriction});
        BooleanRestrictionImpl nestedRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{conjunction1, conjunction2});
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)nestedRestriction, 0, 100);
        List groups = this.groupDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(groups, EXISTING_GROUP_1);
    }

    public void testSearchByMixedName() {
        List results = this.groupDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"t")).returningAtMost(10));
        this.assertContainsExactly(results, "Testers");
    }

    private Group createNewGroup(String groupName) throws DirectoryNotFoundException, GroupNotFoundException {
        GroupTemplate group = new GroupTemplate(groupName, 1L, GroupType.GROUP);
        group.setActive(true);
        group.setDescription(NON_EXISTING_GROUP_DESC);
        return this.groupDAO.add((Group)group);
    }

    public void testAddAll() throws Exception {
        HashSet<GroupTemplate> groups = new HashSet<GroupTemplate>();
        for (int i = 0; i < 50; ++i) {
            GroupTemplate group = new GroupTemplate("Group" + i, 1L, GroupType.LEGACY_ROLE);
            group.setDescription("description");
            groups.add(group);
        }
        BatchResult result = this.groupDAO.addAll(groups);
        GroupDAOHibernateTest.assertEquals((long)50L, (long)result.getTotalSuccessful());
        GroupDAOHibernateTest.assertEquals((long)50L, (long)result.getTotalAttempted());
        GroupDAOHibernateTest.assertTrue((boolean)result.getFailedEntities().isEmpty());
        GroupDAOHibernateTest.assertEquals((int)50, (int)this.groupDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.role()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"group")).returningAtMost(100)).size());
    }

    public void testAddAllWithErrorsAndDuplicates() throws Exception {
        int groupCount = this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).returningAtMost(100)).size();
        HashSet<GroupTemplate> groups = new HashSet<GroupTemplate>();
        GroupTemplate group = new GroupTemplate("group", 1L, GroupType.LEGACY_ROLE);
        group.setDescription("description");
        groups.add(group);
        GroupTemplate existinggroup = new GroupTemplate((Group)this.groupDAO.findByName(1L, EXISTING_GROUP_1));
        group.setDescription("something different");
        groups.add(existinggroup);
        GroupTemplate differentDirectoryGroup = new GroupTemplate("group3", 2L, GroupType.LEGACY_ROLE);
        group.setDescription("description");
        groups.add(differentDirectoryGroup);
        BatchResult result = this.groupDAO.addAll(groups);
        GroupDAOHibernateTest.assertEquals((long)2L, (long)result.getTotalSuccessful());
        GroupDAOHibernateTest.assertEquals((long)groups.size(), (long)result.getTotalAttempted());
        this.assertContainsExactly(result.getFailedEntities(), EXISTING_GROUP_1);
        GroupDAOHibernateTest.assertEquals((int)(groupCount + 1), (int)this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).returningAtMost(100)).size());
    }

    public void testFindByNames() {
        ArrayList<Group> groups = new ArrayList<Group>(this.groupDAO.findByNames(1L, Arrays.asList(EXISTING_GROUP_1, "bogus", EXISTING_GROUP_3)));
        this.assertContainsExactly(groups, EXISTING_GROUP_1, EXISTING_GROUP_3);
    }

    @Override
    public String getSampleDataFileName() {
        return "sample-data.xml";
    }

    public void setGroupDAO(GroupDAOHibernate groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setMembershipDAO(MembershipDAOHibernate membershipDAO) {
        this.membershipDAO = membershipDAO;
    }
}

