/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.alias;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.alias.AliasDAOHibernate;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.AliasTermKeys;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasDAOHibernateTest
extends BaseSpringTestCase {
    private static final Long APPLICATION1_ID = 1L;
    private static final Long APPLICATION2_ID = 2L;
    private static final String USER1 = "Robert";
    private static final String USER2 = "William";
    private static final String USER1_ALIAS1 = "bob";
    private static final String USER1_ALIAS2 = "Robbie";
    private static final String USER2_ALIAS = "BiLL";
    private AliasDAOHibernate aliasDAO;
    private ApplicationImpl application1;
    private Application application2;

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        InternalEntityTemplate template1 = new InternalEntityTemplate();
        template1.setId(APPLICATION1_ID);
        template1.setName("");
        InternalEntityTemplate template2 = new InternalEntityTemplate();
        template2.setId(APPLICATION2_ID);
        template2.setName("");
        this.application1 = new ApplicationImpl(template1);
        this.application2 = new ApplicationImpl(template2);
    }

    public void testFindAliasByUsername() {
        String alias = this.aliasDAO.findAliasByUsername((Application)this.application1, USER1);
        AliasDAOHibernateTest.assertEquals((String)USER1_ALIAS1, (String)alias);
        alias = this.aliasDAO.findAliasByUsername(this.application2, USER1.toUpperCase());
        AliasDAOHibernateTest.assertEquals((String)USER1_ALIAS2, (String)alias);
        alias = this.aliasDAO.findAliasByUsername((Application)this.application1, USER2);
        AliasDAOHibernateTest.assertEquals((String)USER2_ALIAS, (String)alias);
    }

    public void testFindAliasByUsernameNotFound() {
        String alias = this.aliasDAO.findAliasByUsername((Application)this.application1, "bleh");
        AliasDAOHibernateTest.assertNull((Object)alias);
        alias = this.aliasDAO.findAliasByUsername(this.application2, USER2);
        AliasDAOHibernateTest.assertNull((Object)alias);
    }

    public void testFindUsernameByAlias() {
        String username = this.aliasDAO.findUsernameByAlias((Application)this.application1, USER1_ALIAS1);
        AliasDAOHibernateTest.assertEquals((String)USER1, (String)username);
        username = this.aliasDAO.findUsernameByAlias(this.application2, USER1_ALIAS2.toUpperCase());
        AliasDAOHibernateTest.assertEquals((String)USER1, (String)username);
        username = this.aliasDAO.findUsernameByAlias((Application)this.application1, USER2_ALIAS);
        AliasDAOHibernateTest.assertEquals((String)USER2, (String)username);
    }

    public void testFindUsernameByAliasNotFound() {
        String username = this.aliasDAO.findUsernameByAlias((Application)this.application1, "bleh");
        AliasDAOHibernateTest.assertNull((Object)username);
        username = this.aliasDAO.findUsernameByAlias(this.application2, USER2_ALIAS);
        AliasDAOHibernateTest.assertNull((Object)username);
    }

    public void testStoreAliasNew() {
        String username = "Yahya";
        String alias = "John";
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findAliasByUsername((Application)this.application1, username));
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findUsernameByAlias((Application)this.application1, alias));
        this.aliasDAO.storeAlias((Application)this.application1, username, alias);
        AliasDAOHibernateTest.assertEquals((String)alias, (String)this.aliasDAO.findAliasByUsername((Application)this.application1, username.toUpperCase()));
        AliasDAOHibernateTest.assertEquals((String)username, (String)this.aliasDAO.findUsernameByAlias((Application)this.application1, alias.toUpperCase()));
    }

    public void testStoreAliasUpdate() {
        String username = USER1;
        String oldAlias = USER1_ALIAS1;
        String newAlias = "aWesome";
        AliasDAOHibernateTest.assertEquals((String)oldAlias, (String)this.aliasDAO.findAliasByUsername((Application)this.application1, username.toUpperCase()));
        AliasDAOHibernateTest.assertEquals((String)username, (String)this.aliasDAO.findUsernameByAlias((Application)this.application1, oldAlias.toUpperCase()));
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findUsernameByAlias((Application)this.application1, newAlias.toUpperCase()));
        this.aliasDAO.storeAlias((Application)this.application1, username, newAlias);
        AliasDAOHibernateTest.assertEquals((String)newAlias, (String)this.aliasDAO.findAliasByUsername((Application)this.application1, username.toUpperCase()));
        AliasDAOHibernateTest.assertEquals((String)username, (String)this.aliasDAO.findUsernameByAlias((Application)this.application1, newAlias.toUpperCase()));
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findUsernameByAlias((Application)this.application1, oldAlias.toUpperCase()));
    }

    public void testStoreAliasInvalid() {
        try {
            this.aliasDAO.storeAlias((Application)this.application1, USER1, "");
            AliasDAOHibernateTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveAlias() {
        AliasDAOHibernateTest.assertEquals((String)USER1_ALIAS1, (String)this.aliasDAO.findAliasByUsername((Application)this.application1, USER1));
        AliasDAOHibernateTest.assertEquals((String)USER1, (String)this.aliasDAO.findUsernameByAlias((Application)this.application1, USER1_ALIAS1));
        this.aliasDAO.removeAlias((Application)this.application1, USER1);
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findAliasByUsername((Application)this.application1, USER1));
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findUsernameByAlias((Application)this.application1, USER1_ALIAS1));
    }

    public void testRemoveAliasSilentlySucceed() {
        String username = "user3";
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findAliasByUsername((Application)this.application1, username));
        this.aliasDAO.removeAlias((Application)this.application1, username);
        AliasDAOHibernateTest.assertNull((Object)this.aliasDAO.findAliasByUsername((Application)this.application1, username));
    }

    public void testRemoveAliases() {
        int aliasCount = this.jdbcTemplate.queryForInt("select count(*) from cwd_application_alias where application_id = " + APPLICATION1_ID);
        AliasDAOHibernateTest.assertEquals((int)2, (int)aliasCount);
        this.aliasDAO.removeAliases((Application)this.application1);
        aliasCount = this.jdbcTemplate.queryForInt("select count(*) from cwd_application_alias where application_id = " + APPLICATION1_ID);
        AliasDAOHibernateTest.assertEquals((int)0, (int)aliasCount);
        aliasCount = this.jdbcTemplate.queryForInt("select count(*) from cwd_application_alias where application_id = " + APPLICATION2_ID);
        AliasDAOHibernateTest.assertEquals((int)1, (int)aliasCount);
    }

    public void testFindAll() {
        List aliases = this.aliasDAO.findAll();
        AliasDAOHibernateTest.assertEquals((int)3, (int)aliases.size());
    }

    public void testSearchByNameContainingWithMixedCase() {
        List matchingUsernames = this.aliasDAO.search(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.alias()).with((SearchRestriction)Restriction.on((Property)AliasTermKeys.ALIAS).containing((Object)"IL")).returningAtMost(10));
        this.assertContainsExactly(matchingUsernames, USER2);
    }

    public void testSearchByNameContainingAndApplication() {
        List matchingUsernames = this.aliasDAO.search(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.alias()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)AliasTermKeys.ALIAS).containing((Object)"ob"), Restriction.on((Property)AliasTermKeys.APPLICATION_ID).exactlyMatching((Object)1L)})).returningAtMost(10));
        this.assertContainsExactly(matchingUsernames, USER1);
    }

    private void assertContainsExactly(List<String> aliases, String ... aliasNames) {
        AliasDAOHibernateTest.assertEquals((int)aliasNames.length, (int)aliases.size());
        for (String aliasName : aliasNames) {
            this.assertContains(aliases, aliasName);
        }
    }

    private void assertContains(List<String> aliases, String aliasName) {
        AliasDAOHibernateTest.assertTrue((String)("Alias " + aliasName + " not found in " + aliases), (boolean)this.contains(aliases, aliasName));
    }

    private boolean contains(List<String> aliases, String aliasName) {
        for (String alias : aliases) {
            if (!alias.equals(aliasName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSampleDataFileName() {
        return "sample-data.xml";
    }

    public void setAliasDAO(AliasDAOHibernate aliasDAO) {
        this.aliasDAO = aliasDAO;
    }
}

