/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory.suite;

import com.atlassian.crowd.acceptance.tests.directory.BasicTest;
import com.atlassian.crowd.acceptance.tests.directory.DnRangeTest;
import com.atlassian.crowd.acceptance.tests.directory.NestedGroupsTest;
import com.atlassian.crowd.acceptance.tests.directory.PageAndRangeTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ActiveDirectory2K3Test
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(AD2K3BasicTest.class);
        suite.addTestSuite(AD2K3NestedGroupsTest.class);
        suite.addTestSuite(AD2K3ForwardslashTest.class);
        suite.addTestSuite(AD2K3BackslashTest.class);
        suite.addTestSuite(AD2K3DnRangeTestCacheEnabled.class);
        suite.addTestSuite(AD2K3DnRangeTestCacheDisabled.class);
        suite.addTestSuite(AD2K3PageAndRangeTest.class);
        return suite;
    }

    public static class AD2K3DnRangeTestCacheDisabled
    extends DnRangeTest {
        public AD2K3DnRangeTestCacheDisabled() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.roles.disabled", Boolean.TRUE.toString());
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.FALSE.toString());
        }
    }

    public static class AD2K3DnRangeTestCacheEnabled
    extends DnRangeTest {
        public AD2K3DnRangeTestCacheEnabled() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.roles.disabled", Boolean.TRUE.toString());
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
        }
    }

    public static class AD2K3PageAndRangeTest
    extends PageAndRangeTest {
        public AD2K3PageAndRangeTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }
    }

    public static class AD2K3ForwardslashTest
    extends BasicTest {
        public AD2K3ForwardslashTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        public String getAutoTestFirstName() {
            return "user/name";
        }

        public String getAutoTestGroupName() {
            return "My / Group //Name auto-t";
        }
    }

    public static class AD2K3BackslashTest
    extends BasicTest {
        public AD2K3BackslashTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        public String getAutoTestFirstName() {
            return "First\\ Name";
        }

        public String getAutoTestGroupName() {
            return "My \\ Group\\Name auto-t";
        }
    }

    public static class AD2K3NestedGroupsTest
    extends NestedGroupsTest {
        public AD2K3NestedGroupsTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }
    }

    public static class AD2K3BasicTest
    extends BasicTest {
        public AD2K3BasicTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }
    }
}

