/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.ImmutableUser;
import com.atlassian.crowd.acceptance.tests.directory.ModelAssertions;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class LocalAttributesTest
extends BaseTest {
    private static final String USER_NAME = "bsmith";
    private static final String USER_FIRSTNAME = "Bob";
    private static final String USER_LASTNAME = "Smith";
    private static final String USER_DISPLAYNAME = "Bob Smith";
    private static final String USER_EMAIL = "bsmith@example.com";
    private static final String USER2_NAME = "jsmith";
    private static final String USER2_FIRSTNAME = "John";
    private static final String USER2_LASTNAME = "Smith";
    private static final String USER2_DISPLAYNAME = "John Smith";
    private static final String USER2_EMAIL = "jsmith@example.com";
    private static final String USER3_NAME = "jdoe";
    private static final String USER3_FIRSTNAME = "Jane";
    private static final String USER3_LASTNAME = "Doe";
    private static final String USER3_DISPLAYNAME = "Jane Doe";
    private static final String USER3_EMAIL = "jdoe@example.com";
    private static final String GROUP_NAME = "cool-crew";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private User user;
    private Group group;

    protected void configureDirectory(Properties directorySettings) {
        super.configureDirectory(directorySettings);
        this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
    }

    protected void loadTestData() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        this.user = new ImmutableUser(this.directory.getId(), USER_NAME, USER_FIRSTNAME, "Smith", USER_DISPLAYNAME, USER_EMAIL);
        remoteDirectory.addUser(new UserTemplate(this.user), new PasswordCredential("password"));
        ImmutableUser user2 = new ImmutableUser(this.directory.getId(), USER2_NAME, USER2_FIRSTNAME, "Smith", USER2_DISPLAYNAME, USER2_EMAIL);
        remoteDirectory.addUser(new UserTemplate((User)user2), new PasswordCredential("password"));
        ImmutableUser user3 = new ImmutableUser(this.directory.getId(), USER3_NAME, USER3_FIRSTNAME, USER3_LASTNAME, USER3_DISPLAYNAME, USER3_EMAIL);
        remoteDirectory.addUser(new UserTemplate((User)user3), new PasswordCredential("password"));
        this.group = remoteDirectory.addGroup(new GroupTemplate(GROUP_NAME, this.directory.getId().longValue()));
        remoteDirectory.addGroup(new GroupTemplate(GROUP2_NAME, this.directory.getId().longValue()));
        remoteDirectory.addGroup(new GroupTemplate(GROUP3_NAME, this.directory.getId().longValue()));
    }

    protected void removeTestData() {
        this.removeUser(USER_NAME);
        this.removeUser(USER2_NAME);
        this.removeUser(USER3_NAME);
        this.removeGroup(GROUP_NAME);
        this.removeGroup(GROUP2_NAME);
        this.removeGroup(GROUP3_NAME);
    }

    public void testFindUserWithAttributesByNameAfterStoringNoAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        UserWithAttributes foundUser = remoteDirectory.findUserWithAttributesByName(this.user.getName());
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((int)0, (int)foundUser.getKeys().size());
        remoteDirectory.storeUserAttributes(USER_NAME, Collections.emptyMap());
        foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((int)0, (int)foundUser.getKeys().size());
    }

    public void testFindUserWithAttributesByNameWithNoAttributes() throws Exception {
        UserWithAttributes foundUser = this.directory.getImplementation().findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((int)0, (int)foundUser.getKeys().size());
    }

    public void testStoreUserAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        UserWithAttributes foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((int)0, (int)foundUser.getKeys().size());
        ImmutableSet letters = ImmutableSet.builder().add((Object)"a").add((Object)"b").add((Object)"c").build();
        ImmutableSet numbers = ImmutableSet.builder().add((Object)"1").add((Object)"2").add((Object)"3").build();
        ImmutableSet nigel = ImmutableSet.builder().add((Object)"No Friends").build();
        remoteDirectory.storeUserAttributes(USER_NAME, (Map)ImmutableMap.builder().put((Object)"numbers", (Object)numbers).put((Object)"letters", (Object)letters).put((Object)"nigel", (Object)nigel).put((Object)"nothing", Collections.emptySet()).build());
        foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((int)3, (int)foundUser.getKeys().size());
        LocalAttributesTest.assertEquals((Object)letters, (Object)foundUser.getValues("letters"));
        LocalAttributesTest.assertEquals((Object)numbers, (Object)foundUser.getValues("numbers"));
        LocalAttributesTest.assertEquals((Object)nigel, (Object)foundUser.getValues("nigel"));
    }

    public void testRemoveUserAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        ImmutableSet letters = ImmutableSet.builder().add((Object)"a").add((Object)"b").add((Object)"c").build();
        ImmutableSet numbers = ImmutableSet.builder().add((Object)"1").add((Object)"2").add((Object)"3").build();
        remoteDirectory.storeUserAttributes(USER_NAME, (Map)ImmutableMap.builder().put((Object)"numbers", (Object)numbers).put((Object)"letters", (Object)letters).build());
        UserWithAttributes foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((Object)ImmutableSet.builder().add((Object)"numbers").add((Object)"letters").build(), (Object)foundUser.getKeys());
        remoteDirectory.removeUserAttributes(USER_NAME, "numbers");
        foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((Object)ImmutableSet.builder().add((Object)"letters").build(), (Object)foundUser.getKeys());
    }

    public void testRemoveUserAttributeWithNoAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        remoteDirectory.removeUserAttributes(USER_NAME, "stuff");
        UserWithAttributes foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((int)0, (int)foundUser.getKeys().size());
    }

    public void testRemoveUserRemovesAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        ImmutableSet letters = ImmutableSet.builder().add((Object)"a").add((Object)"b").add((Object)"c").build();
        ImmutableSet numbers = ImmutableSet.builder().add((Object)"1").add((Object)"2").add((Object)"3").build();
        remoteDirectory.storeUserAttributes(USER_NAME, (Map)ImmutableMap.builder().put((Object)"numbers", (Object)numbers).put((Object)"letters", (Object)letters).build());
        UserWithAttributes foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        ModelAssertions.assertUsersEqual(this.user, (User)foundUser);
        LocalAttributesTest.assertEquals((Object)ImmutableSet.builder().add((Object)"numbers").add((Object)"letters").build(), (Object)foundUser.getKeys());
        remoteDirectory.removeUser(USER_NAME);
        this.sessionFactory.getCurrentSession().flush();
        ImmutableUser newUser = new ImmutableUser(this.directory.getId(), USER_NAME, USER_FIRSTNAME, "Smith", USER_DISPLAYNAME, USER_EMAIL);
        remoteDirectory.addUser(new UserTemplate((User)newUser), new PasswordCredential("password"));
        foundUser = remoteDirectory.findUserWithAttributesByName(USER_NAME);
        LocalAttributesTest.assertEquals((int)0, (int)foundUser.getKeys().size());
    }

    public void testSearchAllUsers() throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        List users = remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10));
        LocalAttributesTest.assertEquals((int)3, (int)users.size());
    }

    public void testSearchUsersOnLdapOnlyAttributes() throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        List users = remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)USER_NAME), Restriction.on((Property)UserTermKeys.FIRST_NAME).exactlyMatching((Object)USER2_FIRSTNAME)})).returningAtMost(10));
        LocalAttributesTest.assertEquals((int)2, (int)users.size());
        ImmutableSet result = ImmutableSet.of((Object)((User)users.get(0)).getName(), (Object)((User)users.get(1)).getName());
        LocalAttributesTest.assertTrue((boolean)result.contains(USER_NAME));
        LocalAttributesTest.assertTrue((boolean)result.contains(USER2_NAME));
    }

    public void testSearchUsernamesOnLdapOnlyAttributes() throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        List usernames = remoteDirectory.searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)USER_NAME), Restriction.on((Property)UserTermKeys.FIRST_NAME).exactlyMatching((Object)USER2_FIRSTNAME)})).returningAtMost(10));
        LocalAttributesTest.assertEquals((int)2, (int)usernames.size());
        LocalAttributesTest.assertTrue((boolean)usernames.contains(USER_NAME));
        LocalAttributesTest.assertTrue((boolean)usernames.contains(USER2_NAME));
    }

    public void testFindGroupWithAttributesByNameAfterStoringNoAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        GroupWithAttributes foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((int)0, (int)foundGroup.getKeys().size());
        remoteDirectory.storeGroupAttributes(GROUP_NAME, Collections.emptyMap());
        foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((int)0, (int)foundGroup.getKeys().size());
    }

    public void testFindGroupWithAttributesByNameWithNoAttributes() throws Exception {
        GroupWithAttributes foundGroup = this.directory.getImplementation().findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((int)0, (int)foundGroup.getKeys().size());
    }

    public void testStoreGroupAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        GroupWithAttributes foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((int)0, (int)foundGroup.getKeys().size());
        ImmutableSet letters = ImmutableSet.builder().add((Object)"a").add((Object)"b").add((Object)"c").build();
        ImmutableSet numbers = ImmutableSet.builder().add((Object)"1").add((Object)"2").add((Object)"3").build();
        ImmutableSet nigel = ImmutableSet.builder().add((Object)"No Friends").build();
        remoteDirectory.storeGroupAttributes(GROUP_NAME, (Map)ImmutableMap.builder().put((Object)"numbers", (Object)numbers).put((Object)"letters", (Object)letters).put((Object)"nigel", (Object)nigel).put((Object)"nothing", Collections.emptySet()).build());
        foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((int)3, (int)foundGroup.getKeys().size());
        LocalAttributesTest.assertEquals((Object)letters, (Object)foundGroup.getValues("letters"));
        LocalAttributesTest.assertEquals((Object)numbers, (Object)foundGroup.getValues("numbers"));
        LocalAttributesTest.assertEquals((Object)nigel, (Object)foundGroup.getValues("nigel"));
    }

    public void testRemoveGroupAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        ImmutableSet letters = ImmutableSet.builder().add((Object)"a").add((Object)"b").add((Object)"c").build();
        ImmutableSet numbers = ImmutableSet.builder().add((Object)"1").add((Object)"2").add((Object)"3").build();
        remoteDirectory.storeGroupAttributes(GROUP_NAME, (Map)ImmutableMap.builder().put((Object)"numbers", (Object)numbers).put((Object)"letters", (Object)letters).build());
        GroupWithAttributes foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((Object)ImmutableSet.builder().add((Object)"numbers").add((Object)"letters").build(), (Object)foundGroup.getKeys());
        remoteDirectory.removeGroupAttributes(GROUP_NAME, "numbers");
        foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((Object)ImmutableSet.builder().add((Object)"letters").build(), (Object)foundGroup.getKeys());
    }

    public void testRemoveGroupAttributeWithNoAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        remoteDirectory.removeGroupAttributes(GROUP_NAME, "stuff");
        GroupWithAttributes foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((int)0, (int)foundGroup.getKeys().size());
    }

    public void testRemoveGroupRemovesAttributes() throws Exception {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        ImmutableSet letters = ImmutableSet.builder().add((Object)"a").add((Object)"b").add((Object)"c").build();
        ImmutableSet numbers = ImmutableSet.builder().add((Object)"1").add((Object)"2").add((Object)"3").build();
        remoteDirectory.storeGroupAttributes(GROUP_NAME, (Map)ImmutableMap.builder().put((Object)"numbers", (Object)numbers).put((Object)"letters", (Object)letters).build());
        GroupWithAttributes foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.group, (Group)foundGroup);
        LocalAttributesTest.assertEquals((Object)ImmutableSet.builder().add((Object)"numbers").add((Object)"letters").build(), (Object)foundGroup.getKeys());
        remoteDirectory.removeGroup(GROUP_NAME);
        this.sessionFactory.getCurrentSession().flush();
        GroupTemplate groupTemplate = new GroupTemplate(GROUP_NAME, this.directory.getId().longValue());
        this.directory.getImplementation().addGroup(groupTemplate);
        foundGroup = remoteDirectory.findGroupWithAttributesByName(GROUP_NAME);
        LocalAttributesTest.assertEquals((int)0, (int)foundGroup.getKeys().size());
    }

    public void testSearchAllGroups() throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        List groups = remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(10));
        LocalAttributesTest.assertEquals((int)3, (int)groups.size());
    }

    public void testSearchGroupsOnLdapOnlyAttributes() throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        List groups = remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)GROUP2_NAME), Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)GROUP3_NAME)})).returningAtMost(10));
        LocalAttributesTest.assertEquals((int)2, (int)groups.size());
        ImmutableSet result = ImmutableSet.of((Object)((Group)groups.get(0)).getName(), (Object)((Group)groups.get(1)).getName());
        LocalAttributesTest.assertTrue((boolean)result.contains(GROUP2_NAME));
        LocalAttributesTest.assertTrue((boolean)result.contains(GROUP3_NAME));
    }

    public void testSearchGroupNamesOnLdapOnlyAttributes() throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        List groupnames = remoteDirectory.searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)GROUP2_NAME), Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)GROUP3_NAME)})).returningAtMost(10));
        LocalAttributesTest.assertEquals((int)2, (int)groupnames.size());
        LocalAttributesTest.assertTrue((boolean)groupnames.contains(GROUP2_NAME));
        LocalAttributesTest.assertTrue((boolean)groupnames.contains(GROUP3_NAME));
    }
}

