/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.utils.AbstractDbCachingLoadTest;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.rest.service.RestCrowdClient;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class DbCachingLoadAndOperateTest
extends AbstractDbCachingLoadTest {
    private static final String TEST_USERNAME = "testuser-LDAP";
    private static final String USER_DETAILS_TABLE_ID = "user-details";
    private static final String APPLICATION_NAME = "crowd";
    private static final String APPLICATION_PASSWORD = "Mqb7CAcR";

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
        this.createLoadTestingDirectory(CONNECTOR_URL, CONNECTOR_BASEDN, CONNECTOR_USERDN, CONNECTOR_USERPW);
    }

    public void tearDown() throws Exception {
        this.restoreBaseSetup();
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testOperationsDuringSync() throws Exception {
        this.log("Starting testOperationsDuringSync");
        this.synchroniseDirectoryWithoutWaiting();
        this.doAddUser();
        this.doRemoveUser();
        this.doLogoutLogin();
        this.doGetAllUsers();
        this.doRestoreCrowd();
        DbCachingLoadAndOperateTest.assertTrue((String)"Failed to test performing operations while synchronising the directory. Synchronisation might havefinished already.", (boolean)this.directoryIsStillSynchronising());
        this.waitForExistingSyncToFinish();
    }

    private void doAddUser() {
        this.log("Starting doAddUser()");
        this.gotoAddPrincipal();
        String username = TEST_USERNAME;
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", username);
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Test Connector Directory");
        this.submit();
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Connector Directory");
        this.setTextField("search", TEST_USERNAME);
        this.submit("submit-search");
        this.assertTableRowCountEquals(USER_DETAILS_TABLE_ID, 2);
    }

    private void doRemoveUser() {
        this.log("Starting doRemoveUser()");
        this.gotoRemovePrincipal(TEST_USERNAME, "Test Connector Directory");
        this.submit();
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Connector Directory");
        this.setTextField("search", TEST_USERNAME);
        this.submit("submit-search");
        this.assertTableRowCountEquals(USER_DETAILS_TABLE_ID, 1);
    }

    private void doGetAllUsers() throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        this.log("Starting doGetAllUsers");
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        RestCrowdClient crowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        List usernames = crowdClient.searchUserNames((SearchRestriction)new NullRestriction(){}, 0, -1);
        DbCachingLoadAndOperateTest.assertTrue((boolean)usernames.contains("admin"));
    }

    private void doRestoreCrowd() {
        this.log("Starting doRestoreCrowd");
        this.gotoRestore();
        this.submit();
        this.assertKeyPresent("administration.restore.directory.synchronising.error", Arrays.asList("Test Connector Directory"));
        this.assertErrorPresentWithKey("administration.restore.filePath.error");
    }

    private void doLogoutLogin() {
        this.log("Starting doLogoutLogin");
        this._logout();
        this._loginAdminUser();
    }

    private boolean directoryIsStillSynchronising() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Test Connector Directory");
        return this.isSynchronising();
    }

    private void synchroniseDirectoryWithoutWaiting() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Test Connector Directory");
        if (!this.isSynchronising()) {
            this.clickButton("synchroniseDirectoryButton");
        }
    }
}

