/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.ImmutableUser;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.acceptance.tests.directory.ModelAssertions;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.password.encoder.LdapShaPasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.spring.container.ContainerManager;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class DbCachingLdapTest
extends BaseTest {
    private static final String LDAP_USER_NAME = "user1";
    private static final String LDAP_USER2_NAME = "user2";
    private static final String LDAP_USER3_NAME = "user3";
    private static final String LDAP_GROUP_NAME = "ldap-group";
    private static final String LDAP_GROUP2_NAME = "ldap-group2";
    private static final String LDAP_GROUP3_NAME = "ldap-group3";
    private static final String LOCAL_GROUP_NAME = "local-group";
    private static final String LOCAL_GROUP2_NAME = "local-group2";
    private RemoteDirectory remoteDirectory;
    private RemoteDirectory ldapDirectory;
    private RemoteDirectory internalDirectory;
    private User ldapUser;
    private Group ldapGroup;
    private UserDao userDao;
    private GroupDao groupDao;

    public DbCachingLdapTest() {
        this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/dbCachingRemoteDirectoryApplicationContext.xml", "classpath:/applicationContext-CrowdEncryption.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-config.xml"};
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
        passwordEncoderFactory.addEncoder((PasswordEncoder)new LdapShaPasswordEncoder());
    }

    protected void configureDirectory(Properties directorySettings) {
        super.configureDirectory(directorySettings);
        this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
    }

    protected void loadTestData() throws Exception {
        this.remoteDirectory = this.directory.getImplementation();
        this.ldapDirectory = ((DirectoryInstanceLoader)ContainerManager.getComponent((String)"ldapDirectoryInstanceLoader")).getDirectory((Directory)this.directory);
        this.internalDirectory = this.getRawInternalDirectory((Directory)this.directory);
        this.userDao = (UserDao)ContainerManager.getComponent((String)"userDao");
        this.groupDao = (GroupDao)ContainerManager.getComponent((String)"groupDao");
        ImmutableUser user = new ImmutableUser(this.directory.getId(), LDAP_USER_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        ImmutableUser user2 = new ImmutableUser(this.directory.getId(), LDAP_USER2_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        ImmutableUser user3 = new ImmutableUser(this.directory.getId(), LDAP_USER3_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        this.ldapUser = this.ldapDirectory.addUser(new UserTemplate((User)user), new PasswordCredential("password"));
        this.ldapDirectory.addUser(new UserTemplate((User)user2), new PasswordCredential("password"));
        this.ldapDirectory.addUser(new UserTemplate((User)user3), new PasswordCredential("password"));
        GroupTemplate groupTemplate1 = new GroupTemplate(LDAP_GROUP_NAME, this.directory.getId().longValue());
        groupTemplate1.setDescription("LDAP Group 1");
        this.ldapGroup = this.ldapDirectory.addGroup(groupTemplate1);
        GroupTemplate groupTemplate2 = new GroupTemplate(LDAP_GROUP2_NAME, this.directory.getId().longValue());
        groupTemplate2.setDescription("LDAP Group 2");
        this.ldapDirectory.addGroup(groupTemplate2);
        this.ldapDirectory.addUserToGroup(LDAP_USER2_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.addUserToGroup(LDAP_USER3_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.addGroupToGroup(LDAP_GROUP_NAME, LDAP_GROUP2_NAME);
        this.synchroniseCache(this.remoteDirectory);
    }

    private InternalRemoteDirectory getRawInternalDirectory(Directory directory) throws DirectoryInstantiationException {
        HashMap<String, String> newAttributes = new HashMap<String, String>(directory.getAttributes());
        newAttributes.put("user_encryption_method", "sha");
        InternalDirectoryInstanceLoader internalDirectoryInstanceLoader = (InternalDirectoryInstanceLoader)ContainerManager.getComponent((String)"internalDirectoryInstanceLoader");
        return internalDirectoryInstanceLoader.getRawDirectory(directory.getId(), InternalDirectory.class.getName(), newAttributes);
    }

    private void synchroniseCache(RemoteDirectory remoteDirectory) throws OperationFailedException {
        ((SynchronisableDirectory)remoteDirectory).synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
    }

    protected void removeTestData() {
        this.removeUser(LDAP_USER_NAME);
        this.removeUser(LDAP_USER2_NAME);
        this.removeUser(LDAP_USER3_NAME);
        this.removeGroup(LOCAL_GROUP_NAME);
        this.removeGroup(LOCAL_GROUP2_NAME);
        this.removeGroup(LDAP_GROUP_NAME);
        this.removeGroup(LDAP_GROUP2_NAME);
        this.removeGroup(LDAP_GROUP3_NAME);
    }

    public void testSearchOperations() throws Exception {
        User user = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        ModelAssertions.assertUsersEqual(this.ldapUser, user);
        Group group = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.ldapGroup, group);
        DbCachingLdapTest.assertFalse((boolean)this.remoteDirectory.isUserDirectGroupMember(LDAP_USER_NAME, LDAP_GROUP_NAME));
        DbCachingLdapTest.assertTrue((boolean)this.remoteDirectory.isUserDirectGroupMember(LDAP_USER2_NAME, LDAP_GROUP2_NAME));
        DbCachingLdapTest.assertTrue((boolean)this.remoteDirectory.isGroupDirectGroupMember(LDAP_GROUP_NAME, LDAP_GROUP2_NAME));
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        List users = this.remoteDirectory.searchUsers(query);
        DbCachingLdapTest.assertEquals((int)3, (int)users.size());
        DbCachingLdapTest.assertTrue((boolean)users.contains(LDAP_USER_NAME));
        DbCachingLdapTest.assertTrue((boolean)users.contains(LDAP_USER2_NAME));
        DbCachingLdapTest.assertTrue((boolean)users.contains(LDAP_USER3_NAME));
        query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroups(query);
        DbCachingLdapTest.assertEquals((int)3, (int)users.size());
        DbCachingLdapTest.assertTrue((boolean)groups.contains(LDAP_GROUP_NAME));
        DbCachingLdapTest.assertTrue((boolean)groups.contains(LDAP_GROUP2_NAME));
        MembershipQuery membershipquery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP_NAME).returningAtMost(-1);
        List members = this.remoteDirectory.searchGroupRelationships(membershipquery);
        DbCachingLdapTest.assertEquals((int)0, (int)members.size());
        membershipquery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        members = this.remoteDirectory.searchGroupRelationships(membershipquery);
        DbCachingLdapTest.assertEquals((int)2, (int)members.size());
        DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
        DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddUserViaLdap() throws Exception {
        ImmutableUser newUser = new ImmutableUser(this.directory.getId(), "USER99", "Alice", "Jones", "Alice Jones", "ajones@example.com");
        this.ldapUser = this.ldapDirectory.addUser(new UserTemplate((User)newUser), new PasswordCredential("password"));
        try {
            User retrievedUser = null;
            try {
                retrievedUser = this.remoteDirectory.findUserByName("USER99");
                DbCachingLdapTest.fail((String)"User should not be seen locally yet");
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
            this.synchroniseCache(this.remoteDirectory);
            retrievedUser = this.remoteDirectory.findUserByName("USER99");
            ModelAssertions.assertUsersEqual(newUser, retrievedUser);
        }
        finally {
            this.ldapDirectory.removeUser("USER99");
        }
    }

    public void testRemoveUserViaLdap() throws Exception {
        this.ldapDirectory.removeUser(LDAP_USER_NAME);
        User retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedUser);
        ModelAssertions.assertUsersEqual(this.ldapUser, retrievedUser);
        this.synchroniseCache(this.remoteDirectory);
        try {
            retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
            DbCachingLdapTest.fail((String)"User should have been removed");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateUserViaLdap() throws Exception {
        User testUser = this.ldapDirectory.findUserByName(LDAP_USER_NAME);
        UserTemplate template = new UserTemplate(testUser);
        template.setDisplayName("Updated display name");
        template.setEmailAddress("updated@example.org");
        User updatedUser = this.ldapDirectory.updateUser(template);
        User retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedUser);
        DbCachingLdapTest.assertEquals((String)this.ldapUser.getDisplayName(), (String)retrievedUser.getDisplayName());
        DbCachingLdapTest.assertEquals((String)this.ldapUser.getEmailAddress(), (String)retrievedUser.getEmailAddress());
        this.synchroniseCache(this.remoteDirectory);
        retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedUser);
        DbCachingLdapTest.assertEquals((String)"Updated display name", (String)retrievedUser.getDisplayName());
        DbCachingLdapTest.assertEquals((String)"updated@example.org", (String)retrievedUser.getEmailAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddGroupViaLdap() throws Exception {
        this.ldapGroup = this.ldapDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
        try {
            Group retrievedGroup = null;
            try {
                retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
                DbCachingLdapTest.fail((String)"Group should not be seen locally yet");
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
            this.synchroniseCache(this.remoteDirectory);
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
            ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
        }
        finally {
            this.ldapDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    public void testRemoveGroupViaLdap() throws Exception {
        this.ldapDirectory.removeGroup(LDAP_GROUP_NAME);
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedGroup);
        ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
        this.synchroniseCache(this.remoteDirectory);
        try {
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
            DbCachingLdapTest.fail((String)"Group should have been removed");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateGroupViaLdap() throws Exception {
        Group testGroup = this.ldapDirectory.findGroupByName(LDAP_GROUP_NAME);
        GroupTemplate template = new GroupTemplate(testGroup);
        template.setDescription("Updated description");
        Group updatedGroup = this.ldapDirectory.updateGroup(template);
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedGroup);
        DbCachingLdapTest.assertEquals((String)this.ldapGroup.getDescription(), (String)retrievedGroup.getDescription());
        this.synchroniseCache(this.remoteDirectory);
        retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedGroup);
        DbCachingLdapTest.assertEquals((String)"Updated description", (String)retrievedGroup.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddMembershipViaLdap() throws Exception {
        try {
            this.ldapGroup = this.ldapDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
            this.synchroniseCache(this.remoteDirectory);
            this.ldapDirectory.addUserToGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.addUserToGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.addGroupToGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            DbCachingLdapTest.assertEquals((int)0, (int)members.size());
            MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            DbCachingLdapTest.assertEquals((int)0, (int)groupMembers.size());
            this.synchroniseCache(this.remoteDirectory);
            membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            DbCachingLdapTest.assertEquals((int)2, (int)members.size());
            DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
            DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
            groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            DbCachingLdapTest.assertEquals((int)1, (int)groupMembers.size());
            DbCachingLdapTest.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
        }
        finally {
            this.ldapDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.removeUserFromGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    public void testRemoveMembershipViaLdap() throws Exception {
        this.ldapDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP2_NAME);
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        DbCachingLdapTest.assertEquals((int)2, (int)members.size());
        DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
        DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        DbCachingLdapTest.assertEquals((int)1, (int)groupMembers.size());
        DbCachingLdapTest.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
        this.synchroniseCache(this.remoteDirectory);
        membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        DbCachingLdapTest.assertEquals((int)1, (int)members.size());
        DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        DbCachingLdapTest.assertEquals((int)0, (int)groupMembers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddUserViaCachingDirectory() throws Exception {
        ImmutableUser newUser = new ImmutableUser(this.directory.getId(), "USER99", "Alice", "Jones", "Alice Jones", "ajones@example.com");
        this.ldapUser = this.remoteDirectory.addUser(new UserTemplate((User)newUser), new PasswordCredential("password"));
        try {
            User retrievedUser = this.remoteDirectory.findUserByName("USER99");
            ModelAssertions.assertUsersEqual(newUser, retrievedUser);
            this.synchroniseCache(this.remoteDirectory);
            retrievedUser = this.remoteDirectory.findUserByName("USER99");
            ModelAssertions.assertUsersEqual(newUser, retrievedUser);
        }
        finally {
            this.remoteDirectory.removeUser("USER99");
        }
    }

    public void testRemoveUserViaCachingDirectory() throws Exception {
        User retrievedUser;
        this.remoteDirectory.removeUser(LDAP_USER_NAME);
        try {
            retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
            DbCachingLdapTest.fail((String)"User should have been removed");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        this.synchroniseCache(this.remoteDirectory);
        try {
            retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
            DbCachingLdapTest.fail((String)"User should have been removed");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateUserViaCachingDirectory() throws Exception {
        User testUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        UserTemplate template = new UserTemplate(testUser);
        template.setDisplayName("Updated display name");
        template.setEmailAddress("updated@example.org");
        User updatedUser = this.remoteDirectory.updateUser(template);
        User retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedUser);
        DbCachingLdapTest.assertEquals((String)"Updated display name", (String)retrievedUser.getDisplayName());
        DbCachingLdapTest.assertEquals((String)"updated@example.org", (String)retrievedUser.getEmailAddress());
        this.synchroniseCache(this.remoteDirectory);
        retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedUser);
        DbCachingLdapTest.assertEquals((String)"Updated display name", (String)retrievedUser.getDisplayName());
        DbCachingLdapTest.assertEquals((String)"updated@example.org", (String)retrievedUser.getEmailAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddGroupViaCachingDirectory() throws Exception {
        this.ldapGroup = this.remoteDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
        try {
            Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
            ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
            this.synchroniseCache(this.remoteDirectory);
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
            ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
        }
        finally {
            this.remoteDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    public void testRemoveGroupViaCachingDirectory() throws Exception {
        Group retrievedGroup;
        this.remoteDirectory.removeGroup(LDAP_GROUP_NAME);
        try {
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
            DbCachingLdapTest.fail((String)"Group should have been removed");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        this.synchroniseCache(this.remoteDirectory);
        try {
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
            DbCachingLdapTest.fail((String)"Group should have been removed");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateGroupViaCachingDirectory() throws Exception {
        Group testGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        GroupTemplate template = new GroupTemplate(testGroup);
        template.setDescription("Updated description");
        Group updatedGroup = this.remoteDirectory.updateGroup(template);
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedGroup);
        DbCachingLdapTest.assertEquals((String)"Updated description", (String)retrievedGroup.getDescription());
        this.synchroniseCache(this.remoteDirectory);
        retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        DbCachingLdapTest.assertNotNull((Object)retrievedGroup);
        DbCachingLdapTest.assertEquals((String)"Updated description", (String)retrievedGroup.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddMembershipViaCachingDirectory() throws Exception {
        try {
            this.ldapGroup = this.remoteDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
            this.synchroniseCache(this.remoteDirectory);
            this.remoteDirectory.addUserToGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.addUserToGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.addGroupToGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            DbCachingLdapTest.assertEquals((int)2, (int)members.size());
            DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
            DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
            MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            DbCachingLdapTest.assertEquals((int)1, (int)groupMembers.size());
            DbCachingLdapTest.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
            this.synchroniseCache(this.remoteDirectory);
            membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            DbCachingLdapTest.assertEquals((int)2, (int)members.size());
            DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
            DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
            groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            DbCachingLdapTest.assertEquals((int)1, (int)groupMembers.size());
            DbCachingLdapTest.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
        }
        finally {
            this.remoteDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.removeUserFromGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    public void testRemoveMembershipViaCachingDirectory() throws Exception {
        this.remoteDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP2_NAME);
        this.remoteDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP2_NAME);
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        DbCachingLdapTest.assertEquals((int)1, (int)members.size());
        DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        DbCachingLdapTest.assertEquals((int)0, (int)groupMembers.size());
        this.synchroniseCache(this.remoteDirectory);
        membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        DbCachingLdapTest.assertEquals((int)1, (int)members.size());
        DbCachingLdapTest.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        DbCachingLdapTest.assertEquals((int)0, (int)groupMembers.size());
    }
}

