/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.SpringLDAPConnector;
import com.atlassian.crowd.directory.SpringLDAPConnectorAccessor;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.SearchContext;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.UserUtils;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class BasicTest
extends BaseTest {
    private static final Logger logger = Logger.getLogger(BaseTest.class);
    private final String autoTestUserName = "auto-test-user";
    private final String autoTestUserName2 = "auto-2-test-user";
    private final String autoTestFirstName = "Auto";
    private final String autoTestFirstName2 = "Sir Auto";
    private final String autoTestLastName = "Test";
    private final String autoTestPassword = "My-test-password1";
    private final String autoTestPassword2 = "My-test-password1-again";
    private final String autoTestPassword3 = "My-test-password1\u20ac";
    private final String autoTestValidEmail = "test.emailextension@test-ad-example.com";
    private final String autoTestValidEmail2 = "test.2.emailextension@test-ad-example.com";
    private final String autoTestInvalidEmail = "test_borkborkbork";
    private final String autoTestDisplayName = "My Test User";
    private final String autoTestDisplayName2 = "My Test User, Again";
    private final String autoTestDisplayName3 = "My Test User, Yet Again";
    private final String autoTestGroupName = "auto-test-group";
    private final String autoTestGroupName2 = "auto-2-test-group";
    private final String autoTestGroupDescription = "My First Group";
    private final String autoTestGroupDescription2 = "My First Group With A Better Description";
    private final String autoTestRoleName = "auto-test-role-name";
    private final String autoTestRoleName2 = "auto-2-test-role-name";
    private final String autoTestRoleDescription = "My First Role";
    private final String autoTestRoleDescription2 = "My First Role With A Description of Awesomeness!";

    protected BasicTest() {
    }

    protected BasicTest(String name) {
        super(name);
    }

    protected void configureDirectory(Properties directorySettings) {
        super.configureDirectory(directorySettings);
        this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
    }

    private User addUserAndAssertCreation(String name, String displayName, String firstName, String lastName, String email, String password, boolean active) throws InvalidUserException, RemoteException, InvalidCredentialException, UserNotFoundException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException {
        UserTemplate user = new UserTemplate(name, this.directory.getId().longValue());
        user.setActive(true);
        user.setName(name);
        user.setDisplayName(displayName);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmailAddress(email);
        PasswordCredential credential = null;
        if (password != null) {
            credential = new PasswordCredential(password);
        }
        User addedUser = this.directory.getImplementation().addUser(user, credential);
        BasicTest.assertNotNull((Object)addedUser);
        BasicTest.assertEquals((String)name, (String)addedUser.getName());
        User populatedUser = UserUtils.populateNames((User)user);
        BasicTest.assertEquals((String)populatedUser.getDisplayName(), (String)addedUser.getDisplayName());
        BasicTest.assertEquals((String)populatedUser.getFirstName(), (String)addedUser.getFirstName());
        BasicTest.assertEquals((String)populatedUser.getLastName(), (String)addedUser.getLastName());
        if (StringUtils.isNotBlank((String)email)) {
            BasicTest.assertEquals((String)email, (String)addedUser.getEmailAddress());
        }
        return addedUser;
    }

    private void addUserWithDefaults() throws InvalidUserException, RemoteException, InvalidCredentialException, UserNotFoundException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException {
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
    }

    private void authenticate(String password) throws RemoteException, InvalidUserException, InactiveAccountException, InvalidAuthenticationException, UserNotFoundException, ExpiredCredentialException, OperationFailedException {
        this.directory.getImplementation().authenticate(this.getAutoTestUserName(), new PasswordCredential(password));
    }

    private Group addGroup() throws InvalidGroupException, RemoteException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        return this.addGroupWithDescription(this.getAutoTestGroupName(), "Default Description");
    }

    private Group addGroupWithDescription(String groupName, String description) throws InvalidGroupException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        GroupTemplate group = new GroupTemplate(groupName, this.directory.getId().longValue(), GroupType.GROUP);
        group.setActive(true);
        group.setName(groupName);
        group.setDescription(description);
        Group addedGroup = this.directory.getImplementation().addGroup(group);
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)addedGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)addedGroup.getName());
        BasicTest.assertEquals((String)description, (String)addedGroup.getDescription());
        return addedGroup;
    }

    private Group addRole(String roleName) throws InvalidGroupException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        GroupTemplate role = new GroupTemplate(roleName, this.directory.getId().longValue(), GroupType.LEGACY_ROLE);
        role.setActive(true);
        role.setName(roleName);
        Group addedRole = this.directory.getImplementation().addGroup(role);
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)addedRole.getDirectoryId());
        BasicTest.assertEquals((String)role.getName(), (String)addedRole.getName());
        return addedRole;
    }

    private Group addRole() throws InvalidGroupException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        return this.addRole(this.getAutoTestRoleName());
    }

    private Group addRoleWithDescription(String roleName, String description) throws InvalidGroupException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        GroupTemplate role = new GroupTemplate(roleName, this.directory.getId().longValue(), GroupType.LEGACY_ROLE);
        role.setActive(true);
        role.setName(roleName);
        role.setDescription(description);
        Group addedRole = this.directory.getImplementation().addGroup(role);
        BasicTest.assertEquals((Object)role, (Object)addedRole);
        return addedRole;
    }

    private int getTotalUserCount() throws OperationFailedException {
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        return users.size();
    }

    private void addUserToGroup() throws RemoteException, InvalidUserException, InvalidCredentialException, InvalidGroupException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        this.addGroup();
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestGroupName());
    }

    private void addUserToRole() throws RemoteException, InvalidUserException, InvalidCredentialException, InvalidGroupException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        this.addRole(this.getAutoTestRoleName());
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestRoleName());
    }

    protected void loadTestData() {
    }

    protected void removeTestData() {
        this.removeUser(this.getAutoTestUserName());
        this.removeUser(this.getAutoTestUserName2());
        this.removeGroup(this.getAutoTestGroupName());
        this.removeGroup(this.getAutoTestGroupName2());
        this.removeRole(this.getAutoTestRoleName());
        this.removeRole(this.getAutoTestRoleName2());
    }

    public void testAddUserWithNullPassword() throws InvalidUserException, RemoteException, InvalidCredentialException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException, UserNotFoundException {
        logger.info((Object)"Running testAddUserWithNullPassword");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), null, true);
    }

    public void testAddUserExisting() throws InvalidUserException, RemoteException, InvalidCredentialException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException, UserNotFoundException {
        logger.info((Object)"Running testAddUserExisting");
        this.addUserWithDefaults();
        try {
            this.addUserWithDefaults();
            BasicTest.fail((String)("Created same user (" + this.getAutoTestUserName() + ") twice."));
        }
        catch (InvalidUserException invalidUserException) {
            // empty catch block
        }
    }

    public void testAddUserNull() throws Exception {
        logger.info((Object)"Running testAddUserNull");
        try {
            this.directory.getImplementation().addUser(null, null);
            BasicTest.fail((String)"Passing in a null user should have thrown an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddUserInactive() throws Exception {
        logger.info((Object)"Running testAddUserInactive");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), false);
    }

    public void testAddUserWithFirstnameNoPassword() throws Exception {
        logger.info((Object)"Running testAddUserWithFirstnameNoPassword");
        UserTemplate user = new UserTemplate(this.getAutoTestUserName());
        user.setFirstName(this.getAutoTestFirstName());
        this.addUserAndAssertCreation(this.getAutoTestUserName(), null, this.getAutoTestFirstName(), null, null, null, true);
    }

    public void testAddUserWithFirstname() throws Exception {
        logger.info((Object)"Running testAddUserWithFirstname");
        UserTemplate user = new UserTemplate(this.getAutoTestUserName());
        user.setFirstName(this.getAutoTestFirstName());
        this.addUserAndAssertCreation(this.getAutoTestUserName(), null, this.getAutoTestFirstName(), null, null, this.getAutoTestPassword(), true);
    }

    public void testAddUserWithLastnameNoPassword() throws Exception {
        logger.info((Object)"Running testAddUserWithLastnameNoPassword");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), null, null, this.getAutoTestLastName(), null, null, true);
    }

    public void testAddUserWithLastnameAndPassword() throws Exception {
        logger.info((Object)"Running testAddUserWithLastnameAndPassword");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), null, null, this.getAutoTestLastName(), null, this.getAutoTestPassword(), true);
    }

    public void testAddUserWithEmailAndPassword() throws Exception {
        logger.info((Object)"Running testAddUserWithEmail");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), null, null, null, this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
    }

    public void testAddUserWithDisplayName() throws Exception {
        logger.info((Object)"Running testAddUserWithDisplayName");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), null, null, null, this.getAutoTestPassword(), true);
    }

    public void testAddUserWithFirstnameLastnameEmailPassword() throws Exception {
        logger.info((Object)"Running testAddUserWithFirstnameLastnameEmailPassword");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), null, this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        this.authenticate(this.getAutoTestPassword());
    }

    public void testAddUserWithFirstnameLastnameEmailDisplayNamePassword() throws Exception {
        logger.info((Object)"Running testAddUserWithFirstnameLastnameEmailDisplayNamePassword");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        this.authenticate(this.getAutoTestPassword());
    }

    public void testAddUserWithEmptyPassword() throws Exception {
        logger.info((Object)"Running testAddUserWithEmptyPassword");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test_borkborkbork", "", true);
    }

    public void testAuthenticateEmptyPassword() throws Exception {
        logger.info((Object)"Running testAuthenticateEmptyPassword");
        this.addUser("auto-test-user", this.directory.getId(), "");
        try {
            this.authenticate("");
            BasicTest.fail((String)"Should not be able to authenticate with a blank password");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testUpdateUserCredentialAfterNullCreation() throws Exception {
        logger.info((Object)"Running testUpdateUserCredentialAfterNullCreation");
        this.addUser("auto-test-user", this.directory.getId(), null);
        PasswordCredential credential = new PasswordCredential(this.getAutoTestPassword());
        this.directory.getImplementation().updateUserCredential(this.getAutoTestUserName(), credential);
    }

    public void testAuthenticateAfterPasswordAdd() throws Exception {
        logger.info((Object)"Running testAuthenticateAfterPasswordAdd");
        this.addUser("auto-test-user", this.directory.getId(), null);
        PasswordCredential credential = new PasswordCredential(this.getAutoTestPassword());
        this.directory.getImplementation().updateUserCredential(this.getAutoTestUserName(), credential);
        this.authenticate(this.getAutoTestPassword());
    }

    public void testUpdateUserAfterPasswordAdded() throws Exception {
        logger.info((Object)"Running testUpdateUserAfterPasswordAdded");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        PasswordCredential credential = new PasswordCredential(this.getAutoTestPassword2());
        this.directory.getImplementation().updateUserCredential(this.getAutoTestUserName(), credential);
    }

    public void testAuthenticateAfterPasswordUpdate() throws Exception {
        logger.info((Object)"Running testAuthenticateAfterPasswordUpdate");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        this.authenticate(this.getAutoTestPassword());
        PasswordCredential credential = new PasswordCredential(this.getAutoTestPassword2());
        this.directory.getImplementation().updateUserCredential(this.getAutoTestUserName(), credential);
        this.authenticate(this.getAutoTestPassword2());
    }

    public void testAuthenticateAfterUnicodePasswordUpdate() throws Exception {
        logger.info((Object)"Running testAuthenticateAfterUnicodePasswordUpdate");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        this.authenticate(this.getAutoTestPassword());
        PasswordCredential credential = new PasswordCredential(this.getAutoTestPassword3());
        this.directory.getImplementation().updateUserCredential(this.getAutoTestUserName(), credential);
        this.authenticate(this.getAutoTestPassword3());
    }

    public void testAddUserWithPassword() throws Exception {
        logger.info((Object)"Running testAddUserWithPassword");
        UserTemplate user = new UserTemplate(this.getAutoTestUserName(), this.directory.getId().longValue());
        user.setActive(true);
        user.setName(this.getAutoTestUserName());
        user.setLastName(this.getAutoTestUserName());
        this.directory.getImplementation().addUser(user, new PasswordCredential(this.getAutoTestPassword()));
    }

    public void testAuthenticateAfterUserAdd() throws Exception {
        logger.info((Object)"Running testAuthenticateAfterUserAdd");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        this.authenticate(this.getAutoTestPassword());
    }

    public void testAuthenticateAfterUserAddWithUnicodePassword() throws Exception {
        logger.info((Object)"Running testAuthenticateAfterUserAddWithUnicodePassword");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword3(), true);
        this.authenticate(this.getAutoTestPassword3());
    }

    public void testAuthenticateWithNullPasswordArray() throws Exception {
        logger.info((Object)"Running testAuthenticateWithNullPasswordArray");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        try {
            this.directory.getImplementation().authenticate(this.getAutoTestUserName(), null);
            BasicTest.fail((String)"Should have thrown InvalidAuthenticationException");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticateWithNullPasswordCredentialInArray() throws Exception {
        logger.info((Object)"Running testAuthenticateWithNullPasswordCredentialInArray");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().authenticate(this.getAutoTestUserName(), null);
            BasicTest.fail((String)"Should have thrown InvalidAuthenticationException");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticateWithNullPassword() throws Exception {
        logger.info((Object)"Running testAuthenticateWithNullPassword");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().authenticate(this.getAutoTestUserName(), new PasswordCredential());
            BasicTest.fail((String)"Should have thrown InvalidAuthenticationException");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticateWithEmptyPassword() throws Exception {
        logger.info((Object)"Running testAuthenticateWithEmptyPassword");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().authenticate(this.getAutoTestUserName(), new PasswordCredential(""));
            BasicTest.fail((String)"Should have thrown InvalidAuthenticationException");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticateWithIncorrectPassword() throws Exception {
        logger.info((Object)"Running testAuthenticateWithIncorrectPassword");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().authenticate(this.getAutoTestUserName(), new PasswordCredential("boop-boop-be-doop"));
            BasicTest.fail((String)"Should have thrown InvalidAuthenticationException");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticateWithInvalidUser() throws Exception {
        logger.info((Object)"Running testAuthenticateWithInvalidUser");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().authenticate("my-made-up-user-name", new PasswordCredential("this-shouldnt-matter"));
            BasicTest.fail((String)"Should have thrown UserNotFoundException");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserNull() throws Exception {
        logger.info((Object)"Running testRemoveUserNull");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().removeUser(null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveUserEmptyString() throws Exception {
        logger.info((Object)"Running testRemoveUserEmptyString");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().removeUser("");
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveUserInvalid() throws Exception {
        logger.info((Object)"Running testRemoveUserInvalid");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().removeUser("i-wanna-be-a-small-furry-animal");
            BasicTest.fail((String)"Should have thrown UserNotFoundException");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUser() throws Exception {
        logger.info((Object)"Running testRemoveUser");
        this.addUserWithDefaults();
        this.directory.getImplementation().removeUser(this.getAutoTestUserName());
    }

    public void testUpdateUserNull() throws Exception {
        logger.info((Object)"Running testUpdateUserNull");
        try {
            this.directory.getImplementation().updateUser(null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUpdateUserInvalidName() throws Exception {
        logger.info((Object)"Running testUpdateUserInvalidName");
        this.addUserWithDefaults();
        UserTemplate user = new UserTemplate("mice-dont-live-in-ldap-directories", this.directory.getId().longValue());
        try {
            this.directory.getImplementation().updateUser(user);
            BasicTest.fail((String)"Should have thrown UserNotFoundException");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateUserEmail() throws Exception {
        logger.info((Object)"Running testUpdateUserEmail");
        User addedUser = this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        UserTemplate modifiedUser = new UserTemplate(addedUser);
        modifiedUser.setEmailAddress(this.getAutoTestValidEmail2());
        User updatedUser = this.directory.getImplementation().updateUser(modifiedUser);
        BasicTest.assertEquals((String)modifiedUser.getName(), (String)updatedUser.getName());
        BasicTest.assertEquals((String)modifiedUser.getEmailAddress(), (String)updatedUser.getEmailAddress());
    }

    public void testUpdateUserEmailExplicitCheck() throws Exception {
        logger.info((Object)"Running testUpdateUserEmailExplicitCheck");
        User addedUser = this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        UserTemplate updatingUser = new UserTemplate(addedUser);
        updatingUser.setEmailAddress(this.getAutoTestValidEmail());
        this.directory.getImplementation().updateUser(updatingUser);
        User updatedUser = this.directory.getImplementation().findUserByName(this.getAutoTestUserName());
        BasicTest.assertEquals((String)updatingUser.getName(), (String)updatedUser.getName());
        BasicTest.assertEquals((String)updatingUser.getEmailAddress(), (String)updatedUser.getEmailAddress());
    }

    public void testUpdateUserEmailInvalid() throws Exception {
        logger.info((Object)"Running testUpdateUserEmailInvalid");
        User addedUser = this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        UserTemplate updatingUser = new UserTemplate(addedUser);
        updatingUser.setEmailAddress(this.getAutoTestInvalidEmail());
        User updatedUser = this.directory.getImplementation().updateUser(updatingUser);
        BasicTest.assertEquals((String)updatingUser.getName(), (String)updatedUser.getName());
        BasicTest.assertEquals((String)updatingUser.getEmailAddress(), (String)updatedUser.getEmailAddress());
    }

    public void testFindUserByNameNull() throws Exception {
        logger.info((Object)"Running testFindUserByNameNull");
        try {
            this.directory.getImplementation().findUserByName(null);
            BasicTest.fail((String)"Should not have found null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindUserByNameEmpty() throws RemoteException, OperationFailedException {
        logger.info((Object)"Running testFindUserByNameEmpty");
        try {
            this.directory.getImplementation().findUserByName("");
            BasicTest.fail((String)"Should not have found empty user");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testFindUserByNameNonExistent() throws Exception {
        logger.info((Object)"Running testFindUserByNameNonExistent");
        this.addUserWithDefaults();
        try {
            this.directory.getImplementation().findUserByName("I've-been-to-paradise-but-I've-never-been-to-me");
            BasicTest.fail((String)"Should not have found user \"I've-been-to-paradise-but-I've-never-been-to-me\"");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testFindUserByName() throws Exception {
        logger.info((Object)"Running testFindUserByName");
        this.addUserWithDefaults();
        User user = this.directory.getImplementation().findUserByName(this.getAutoTestUserName());
        BasicTest.assertEquals((String)this.getAutoTestUserName(), (String)user.getName());
    }

    public void testFindUserByNameDisplayNamePopulatedInLdap() throws Exception {
        logger.info((Object)"Running testFindUserByName_displayNamePopulated");
        this.addUserWithDefaults();
        SpringLDAPConnectorAccessor accessor = new SpringLDAPConnectorAccessor((SpringLDAPConnector)this.directory.getRawImplementation());
        LDAPUserWithAttributes currentUser = (LDAPUserWithAttributes)this.directory.getRawImplementation().findUserByName(this.getAutoTestUserName());
        String displayNameAttributeKey = accessor.getLdapPropertiesMapper().getUserDisplayNameAttribute();
        ModificationItem[] items = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(displayNameAttributeKey, " "))};
        accessor.getLdapTemplate().modifyAttributes(currentUser.getDn(), items);
        User user = this.directory.getRawImplementation().findUserByName(this.getAutoTestUserName());
        BasicTest.assertEquals((String)this.getAutoTestUserName(), (String)user.getName());
        BasicTest.assertEquals((String)(this.getAutoTestFirstName() + " " + this.getAutoTestLastName()), (String)user.getDisplayName());
    }

    public void testAddGroupNull() throws Exception {
        logger.info((Object)"Running testAddGroupNull");
        try {
            this.directory.getImplementation().addGroup(null);
            BasicTest.fail((String)"Should not have created null group");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddGroup() throws Exception {
        logger.info((Object)"Running testAddGroup");
        Group addedGroup = this.addGroup();
        Group foundGroup = this.directory.getImplementation().findGroupByName(this.getAutoTestGroupName());
        BasicTest.assertEquals((String)addedGroup.getName(), (String)foundGroup.getName());
        BasicTest.assertEquals((Object)addedGroup.getType(), (Object)foundGroup.getType());
        BasicTest.assertEquals((long)addedGroup.getDirectoryId(), (long)foundGroup.getDirectoryId());
        BasicTest.assertEquals((String)addedGroup.getDescription(), (String)foundGroup.getDescription());
    }

    public void testAddGroupExisting() throws Exception {
        logger.info((Object)"Running testAddGroupExisting");
        this.addGroup();
        try {
            this.addGroup();
            BasicTest.fail((String)"Created same group twice");
        }
        catch (InvalidGroupException invalidGroupException) {
            // empty catch block
        }
    }

    public void testAddGroupWithDescription() throws Exception {
        logger.info((Object)"Running testAddGroupWithDescription");
        GroupTemplate group = new GroupTemplate(this.getAutoTestGroupName(), this.directory.getId().longValue(), GroupType.GROUP);
        group.setDescription(this.getAutoTestGroupDescription());
        Group addedGroup = this.directory.getImplementation().addGroup(group);
        Group foundGroup = this.directory.getImplementation().findGroupByName(this.getAutoTestGroupName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)addedGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)addedGroup.getName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)foundGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)foundGroup.getName());
        BasicTest.assertEquals((String)group.getDescription(), (String)addedGroup.getDescription());
        BasicTest.assertEquals((String)group.getDescription(), (String)foundGroup.getDescription());
    }

    public void testIsGroupMemberBothNull() throws Exception {
        logger.info((Object)"Running testIsGroupMemberBothNull");
        try {
            this.directory.getImplementation().isUserDirectGroupMember(null, null);
            BasicTest.fail((String)"Should have thrown illegal argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsGroupMemberBothEmpty() throws Exception {
        logger.info((Object)"Running testIsGroupMemberBothEmpty");
        try {
            this.directory.getImplementation().isUserDirectGroupMember("", "");
            BasicTest.fail((String)"should of thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsGroupMemberNonExistentUser() throws Exception {
        logger.info((Object)"Running testIsGroupMemberNonExistentUser");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        BasicTest.assertFalse((boolean)this.directory.getImplementation().isUserDirectGroupMember("meeep-meep-moop", this.getAutoTestGroupName()));
    }

    public void testIsGroupMemberNonExistentGroup() throws Exception {
        logger.info((Object)"Running testIsGroupMemberNonExistentGroup");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        BasicTest.assertFalse((boolean)this.directory.getImplementation().isUserDirectGroupMember(this.getAutoTestUserName(), "meeep-meep-moop"));
    }

    public void testIsGroupMember() throws Exception {
        logger.info((Object)"Running testIsGroupMember");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestGroupName());
        BasicTest.assertTrue((boolean)this.directory.getImplementation().isUserDirectGroupMember(this.getAutoTestUserName(), this.getAutoTestGroupName()));
    }

    public void testSearchGroupsEmptyContext() throws Exception {
        logger.info((Object)"Running testSearchGroupsEmptyContext");
        this.addGroup();
        List groups = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
        BasicTest.assertTrue((groups.size() >= 1 ? 1 : 0) != 0);
    }

    public void testSearchGroupsNameEmptyString() throws Exception {
        logger.info((Object)"Running testSearchGroupsNameEmptyString");
        this.addGroup();
        List groups = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)"")).returningAtMost(-1));
        BasicTest.assertTrue((groups.size() != 0 ? 1 : 0) != 0);
    }

    public void testSearchGroupsNameNonExistent() throws Exception {
        logger.info((Object)"Running testSearchGroupsNameNonExistent");
        this.addGroup();
        List groups = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)"wibble-wobble-up-and-down")).returningAtMost(-1));
        BasicTest.assertTrue((groups.size() == 0 ? 1 : 0) != 0);
    }

    public void testSearchGroupsNameSingleMatch() throws Exception {
        logger.info((Object)"Running testSearchGroupsNameSingleMatch");
        this.addGroup();
        List groups = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)this.getAutoTestGroupName())).returningAtMost(-1));
        BasicTest.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
    }

    public void testSearchGroupsNameWildcardSingleMatch() throws Exception {
        logger.info((Object)"Running testSearchGroupsNameWildcardSingleMatch");
        this.addGroupWithDescription(this.getAutoTestGroupName(), null);
        this.addGroupWithDescription(this.getAutoTestGroupName2(), null);
        List groups = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)"auto-t")).returningAtMost(-1));
        BasicTest.assertEquals((int)1, (int)groups.size());
    }

    public void testSearchGroupsNameWildcardDualMatch() throws Exception {
        logger.info((Object)"Running testSearchGroupsNameWildcardDualMatch");
        this.addGroupWithDescription(this.getAutoTestGroupName(), null);
        this.addGroupWithDescription(this.getAutoTestGroupName2(), null);
        List groups = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)"auto")).returningAtMost(-1));
        BasicTest.assertEquals((int)2, (int)groups.size());
    }

    public void testSearchGroupsContainingNull() throws Exception {
        logger.info((Object)"Running testSearchGroupsContainingNull");
        this.addGroup();
        try {
            this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(null).returningAtMost(-1));
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSearchGroupsContainingEmptyString() throws Exception {
        logger.info((Object)"Running testSearchGroupsContainingEmptyString");
        this.addGroup();
        List groups = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("").returningAtMost(-1));
        BasicTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testSearchGroupsContainingNonExistentUser() throws Exception {
        logger.info((Object)"Running testSearchGroupsContainingNonExistentUser");
        this.addGroupWithDescription(this.getAutoTestGroupName(), null);
        this.addGroupWithDescription(this.getAutoTestGroupName2(), null);
        List groups = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("I'm-a-hippy-and-I-wanna-get...").returningAtMost(-1));
        BasicTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testSearchGroupsNotContainingUser() throws Exception {
        logger.info((Object)"Running testSearchGroupsNotContainingUser");
        this.addUserWithDefaults();
        this.addGroupWithDescription(this.getAutoTestGroupName(), null);
        this.addGroupWithDescription(this.getAutoTestGroupName2(), null);
        List groups = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(-1));
        BasicTest.assertTrue((groups != null ? 1 : 0) != 0);
        BasicTest.assertTrue((String)"There should be no groups containing this user", (groups.size() == 0 ? 1 : 0) != 0);
    }

    public void testSearchGroupsContainingUser() throws Exception {
        logger.info((Object)"Running testSearchGroupsContainingUser");
        this.addUserWithDefaults();
        this.addGroupWithDescription(this.getAutoTestGroupName(), null);
        this.addGroupWithDescription(this.getAutoTestGroupName2(), null);
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestGroupName());
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestGroupName2());
        List groups = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(-1));
        BasicTest.assertTrue((groups != null ? 1 : 0) != 0);
        BasicTest.assertTrue((String)"There should be two groups containing this user", (groups.size() == 2 ? 1 : 0) != 0);
        BasicTest.assertTrue((String)("One of groups should be " + this.getAutoTestGroupName()), (((Group)groups.get(0)).getName().equals(this.getAutoTestGroupName()) || ((Group)groups.get(1)).getName().equals(this.getAutoTestGroupName()) ? 1 : 0) != 0);
        BasicTest.assertTrue((String)("One of groups should be " + this.getAutoTestGroupName2()), (((Group)groups.get(1)).getName().equals(this.getAutoTestGroupName2()) || ((Group)groups.get(0)).getName().equals(this.getAutoTestGroupName2()) ? 1 : 0) != 0);
    }

    public void testFindGroupByNameNull() throws Exception {
        logger.info((Object)"Running testFindGroupByNameNull");
        try {
            this.directory.getImplementation().findGroupByName(null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindGroupByNameEmptyString() throws RemoteException, OperationFailedException {
        logger.info((Object)"Running testFindGroupByNameEmptyString");
        try {
            this.directory.getImplementation().findGroupByName("");
            BasicTest.fail((String)"Should have thrown GroupNotFoundException");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testFindGroupByNameNonExistent() throws RemoteException, OperationFailedException {
        logger.info((Object)"Running testFindGroupByNameNonExistent");
        try {
            this.directory.getImplementation().findGroupByName("Ill-fix-ya-with-a-drumstick-and-Ill-do-it-for-free");
            BasicTest.fail((String)"Should have thrown GroupNotFoundException");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testFindGroupByName() throws Exception {
        logger.info((Object)"Running testFindGroupByName");
        this.addGroup();
        Group group = this.directory.getImplementation().findGroupByName(this.getAutoTestGroupName());
        BasicTest.assertTrue((group != null ? 1 : 0) != 0);
        BasicTest.assertEquals((String)this.getAutoTestGroupName(), (String)group.getName());
    }

    public void testUpdateGroupNull() throws Exception {
        logger.info((Object)"Running testUpdateGroupNull");
        try {
            this.directory.getImplementation().updateGroup(null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUpdateGroupNonExistent() throws Exception {
        logger.info((Object)"Running testUpdateGroupNonExistent");
        GroupTemplate group = new GroupTemplate("i-bet-we-dont-have-a-badger-appreciation-society-group", this.directory.getId().longValue(), GroupType.GROUP);
        try {
            this.directory.getImplementation().updateGroup(group);
            BasicTest.fail((String)"Should have thrown GroupNotFoundException");
        }
        catch (GroupNotFoundException e) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUpdateGroupSetDescriptionFromNull() throws Exception {
        logger.info((Object)"Running testUpdateGroupSetDescriptionFromNull");
        Group addedGroup = this.addGroup();
        GroupTemplate group = new GroupTemplate(addedGroup);
        group.setActive(true);
        group.setName(this.getAutoTestGroupName());
        group.setDescription(this.getAutoTestGroupDescription());
        Group updatedGroup = this.directory.getImplementation().updateGroup(group);
        Group foundGroup = this.directory.getImplementation().findGroupByName(this.getAutoTestGroupName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)updatedGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)updatedGroup.getName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)foundGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)foundGroup.getName());
        BasicTest.assertEquals((String)group.getDescription(), (String)updatedGroup.getDescription());
        BasicTest.assertEquals((String)group.getDescription(), (String)foundGroup.getDescription());
    }

    public void testUpdateGroupSetDescriptionToNull() throws Exception {
        logger.info((Object)"Running testUpdateGroupSetDescriptionToNull");
        Group addedGroup = this.addGroupWithDescription(this.getAutoTestGroupName(), this.getAutoTestGroupDescription());
        GroupTemplate group = new GroupTemplate(addedGroup);
        group.setActive(true);
        group.setName(this.getAutoTestGroupName());
        Group updatedGroup = this.directory.getImplementation().updateGroup(group);
        Group foundGroup = this.directory.getImplementation().findGroupByName(this.getAutoTestGroupName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)updatedGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)updatedGroup.getName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)foundGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)foundGroup.getName());
        BasicTest.assertEquals((String)group.getDescription(), (String)updatedGroup.getDescription());
        BasicTest.assertEquals((String)group.getDescription(), (String)foundGroup.getDescription());
    }

    public void testUpdateGroupUpdateDescription() throws Exception {
        logger.info((Object)"Running testUpdateGroupUpdateDescription");
        Group addedGroup = this.addGroupWithDescription(this.getAutoTestGroupName(), this.getAutoTestGroupDescription());
        GroupTemplate group = new GroupTemplate(addedGroup);
        group.setActive(true);
        group.setName(this.getAutoTestGroupName());
        group.setDescription(this.getAutoTestGroupDescription2());
        Group updatedGroup = this.directory.getImplementation().updateGroup(group);
        Group foundGroup = this.directory.getImplementation().findGroupByName(this.getAutoTestGroupName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)updatedGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)updatedGroup.getName());
        BasicTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)foundGroup.getDirectoryId());
        BasicTest.assertEquals((String)group.getName(), (String)foundGroup.getName());
        BasicTest.assertEquals((String)group.getDescription(), (String)updatedGroup.getDescription());
        BasicTest.assertEquals((String)group.getDescription(), (String)foundGroup.getDescription());
    }

    public void testRemoveGroupNull() throws Exception {
        logger.info((Object)"Running testRemoveGroupNull");
        this.addGroup();
        try {
            this.directory.getImplementation().removeGroup(null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveGroupEmptyString() throws Exception {
        logger.info((Object)"Running testRemoveGroupEmptyString");
        this.addGroup();
        try {
            this.directory.getImplementation().removeGroup("");
            BasicTest.fail((String)"should of thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveGroupNonExistent() throws Exception {
        logger.info((Object)"Running testRemoveGroupNonExistent");
        this.addGroup();
        try {
            this.directory.getImplementation().removeGroup("badger-badger-badger-SNAKE!-SNAAKE!-Oh-it's-a-snaaaaake");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveGroup() throws Exception {
        logger.info((Object)"Running testRemoveGroup");
        this.addGroup();
        this.directory.getImplementation().removeGroup(this.getAutoTestGroupName());
    }

    public void testSearchUsersNull() throws Exception {
        logger.info((Object)"Running testSearchUsersNull");
        try {
            this.directory.getImplementation().searchUsers(null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSearchUsersEmptyContext() throws Exception {
        logger.info((Object)"Running testSearchUsersEmptyContext");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), this.getAutoTestFirstName(), this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10));
        BasicTest.assertTrue((users.size() >= 1 ? 1 : 0) != 0);
    }

    public void testSearchUsersNameEmptyString() throws Exception {
        logger.info((Object)"Running testSearchUsersNameEmptyString");
        this.addUserAndAssertCreation(this.getAutoTestUserName(), this.getAutoTestDisplayName(), " ", this.getAutoTestLastName(), this.getAutoTestValidEmail(), this.getAutoTestPassword(), true);
        SearchContext searchContext = new SearchContext();
        searchContext.put((Object)"principal.name", (Object)" ");
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.FIRST_NAME).exactlyMatching((Object)" ")).returningAtMost(10));
        BasicTest.assertEquals((int)0, (int)users.size());
    }

    public void testSearchUsersNameNonExistent() throws Exception {
        logger.info((Object)"Running testSearchUsersNameNonExistent");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)"wibble-wobble-up-and-down")).returningAtMost(10));
        BasicTest.assertEquals((int)0, (int)users.size());
    }

    public void testSearchUsersNameSingleMatch() throws Exception {
        logger.info((Object)"Running testSearchUsersNameSingleMatch");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)"auto-test-user")).returningAtMost(10));
        BasicTest.assertEquals((int)1, (int)users.size());
    }

    public void testSearchUsersNameWildcardSingleMatch() throws Exception {
        logger.info((Object)"Running testSearchUsersNameWildcardSingleMatch");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addUserAndAssertCreation("auto-2-test-user", "My Test User", "Sir Auto", "Test", "test.2.emailextension@test-ad-example.com", "My-test-password1-again", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).startingWith((Object)"auto-t")).returningAtMost(10));
        BasicTest.assertEquals((int)1, (int)users.size());
    }

    public void testSearchUsersNameWildcardDualMatch() throws Exception {
        logger.info((Object)"Running testSearchUsersNameWildcardDualMatch");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addUserAndAssertCreation("auto-2-test-user", "My Test User", "Sir Auto", "Test", "test.2.emailextension@test-ad-example.com", "My-test-password1-again", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)"auto")).returningAtMost(10));
        BasicTest.assertEquals((int)2, (int)users.size());
    }

    public void testSearchUsersEmailNonExistent() throws Exception {
        logger.info((Object)"Running testSearchUsersEmailNonExistent");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)"if-anyone-has.this_email@Ill_be_very.surprised.com")).returningAtMost(10));
        BasicTest.assertEquals((int)0, (int)users.size());
    }

    public void testSearchUsersEmailSingleMatch() throws Exception {
        logger.info((Object)"Running testSearchUsersEmailSingleMatch");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)"test.emailextension@test-ad-example.com")).returningAtMost(10));
        BasicTest.assertEquals((int)1, (int)users.size());
    }

    public void testSearchUsersEmailWildcardSingleMatch() throws Exception {
        logger.info((Object)"Running testSearchUsersEmailWildcardSingleMatch");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addUserAndAssertCreation("auto-2-test-user", "My Test User", "Sir Auto", "Test", "test.2.emailextension@test-ad-example.com", "My-test-password1-again", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).startingWith((Object)"test.email")).returningAtMost(10));
        BasicTest.assertEquals((int)1, (int)users.size());
    }

    public void testSearchUsersEmailWildcardDualMatch() throws Exception {
        logger.info((Object)"Running testSearchUsersEmailWildcardDualMatch");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addUserAndAssertCreation("auto-2-test-user", "My Test User", "Sir Auto", "Test", "test.2.emailextension@test-ad-example.com", "My-test-password1-again", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)"test-ad-example.com")).returningAtMost(10));
        BasicTest.assertEquals((int)2, (int)users.size());
    }

    public void testSearchUsersFullnameEmptyString() throws Exception {
        this.addUserAndAssertCreation("auto-test-user", null, "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.DISPLAY_NAME).exactlyMatching((Object)"")).returningAtMost(10));
        BasicTest.assertEquals((String)"No users should have been returned", (int)0, (int)users.size());
    }

    public void testSearchUsersFullnameNonExistent() throws Exception {
        this.addUserAndAssertCreation("auto-test-user", null, "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.DISPLAY_NAME).exactlyMatching((Object)"My Auntie Married A Badger")).returningAtMost(10));
        BasicTest.assertEquals((String)"No users should have been returned", (int)0, (int)users.size());
    }

    public void testSearchUsersFullnameSingleMatch() throws Exception {
        User firstUser = this.addUserAndAssertCreation("auto-test-user", null, "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addUserAndAssertCreation("auto-2-test-user", null, "Sir Auto", "Test", "test.2.emailextension@test-ad-example.com", "My-test-password1-again", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.DISPLAY_NAME).exactlyMatching((Object)firstUser.getDisplayName())).returningAtMost(10));
        BasicTest.assertEquals((String)"One user should have been returned", (int)1, (int)users.size());
        BasicTest.assertEquals((String)"One user should have been returned", (String)firstUser.getName(), (String)((String)users.get(0)));
    }

    public void testSearchUsersFullnameWildcardSingleMatch() throws Exception {
        this.addUserAndAssertCreation("auto-test-user", null, "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addUserAndAssertCreation("auto-2-test-user", null, "Sir Auto", "Test", "test.2.emailextension@test-ad-example.com", "My-test-password1-again", true);
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.DISPLAY_NAME).startingWith((Object)"Auto")).returningAtMost(10));
        BasicTest.assertEquals((String)"One user should have been returned", (int)1, (int)users.size());
    }

    public void testSearchUsersFullnameWildcardDualMatch() throws Exception {
        this.addUserAndAssertCreation("auto-test-user", null, "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addUserAndAssertCreation("auto-2-test-user", null, "Sir Auto", "Test", "test.2.emailextension@test-ad-example.com", "My-test-password1-again", true);
        SearchContext searchContext = new SearchContext();
        searchContext.put((Object)"principal.fullname", (Object)"*Auto*");
        List users = this.directory.getImplementation().searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)"Auto")).returningAtMost(10));
        BasicTest.assertEquals((String)"Two users should have been returned", (int)2, (int)users.size());
    }

    public void testAddUserToGroupBothNull() throws Exception {
        logger.info((Object)"Running testAddUserToGroupBothNull");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().addUserToGroup(null, null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddUserToGroupNullAndEmpty1() throws Exception {
        logger.info((Object)"Running testAddUserToGroupNullAndEmpty1");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().addUserToGroup(null, "");
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddUserToGroupNullAndEmpty2() throws Exception {
        logger.info((Object)"Running testAddUserToGroupNullAndEmpty2");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().addUserToGroup("", null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddUserToGroupBothEmpty() throws Exception {
        logger.info((Object)"Running testAddUserToGroupBothEmpty");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().addUserToGroup("", "");
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddUserToGroupNonExistentUser() throws Exception {
        logger.info((Object)"Running testAddUserToGroupNonExistentUser");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().addUserToGroup("meeep-meep-moop", this.getAutoTestGroupName());
            BasicTest.fail((String)"Should have thrown UserNotFoundException");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testAddUserToGroupNonExistentGroup() throws Exception {
        logger.info((Object)"Running testAddUserToGroupNonExistentGroup");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), "meeep-meep-moop");
            BasicTest.fail((String)"Should have thrown GroupNotFoundException");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testAddUserToGroup() throws Exception {
        logger.info((Object)"Running testAddUserToGroup");
        this.addUserToGroup();
        List groupList = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(10));
        BasicTest.assertNotNull((String)"Group list should not be null", (Object)groupList);
        BasicTest.assertEquals((String)"User should only belong to one group", (int)1, (int)groupList.size());
        BasicTest.assertEquals((String)("User should belong to the group " + this.getAutoTestGroupName()), (String)this.getAutoTestGroupName(), (String)((String)groupList.get(0)));
    }

    public void testAddUserToTwoGroups() throws Exception {
        logger.info((Object)"Running testAddUserToTwoGroups");
        this.addUserToGroup();
        this.addGroup(this.getAutoTestGroupName2(), this.directory.getId());
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestGroupName2());
        List groupList = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(10));
        BasicTest.assertNotNull((String)"Group list should not be null", (Object)groupList);
        BasicTest.assertEquals((String)"User should belong to two groups", (int)2, (int)groupList.size());
        BasicTest.assertTrue((String)("User should belong to the group " + this.getAutoTestGroupName()), (boolean)groupList.contains(this.getAutoTestGroupName()));
        BasicTest.assertTrue((String)("User should belong to the group " + this.getAutoTestGroupName2()), (boolean)groupList.contains(this.getAutoTestGroupName2()));
    }

    public void testRemoveUserFromGroupBothNull() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroupBothNull");
        this.addUserToGroup();
        try {
            this.directory.getImplementation().removeUserFromGroup(null, null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroupNullAndEmpty1() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroupNullAndEmpty1");
        this.addUserToGroup();
        try {
            this.directory.getImplementation().removeUserFromGroup(null, "");
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroupNullAndEmpty2() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroupNullAndEmpty2");
        this.addUserToGroup();
        try {
            this.directory.getImplementation().removeUserFromGroup("", null);
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroupBothEmpty() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroupBothEmpty");
        this.addUserToGroup();
        try {
            this.directory.getImplementation().removeUserFromGroup("", "");
            BasicTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroupNonExistentUser() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroupNonExistentUser");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().removeUserFromGroup("meeep-meep-moop", this.getAutoTestGroupName());
            BasicTest.fail((String)"Should have thrown UserNotFoundException");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroupNonExistentGroup() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroupNonExistentGroup");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroup();
        try {
            this.directory.getImplementation().removeUserFromGroup(this.getAutoTestUserName(), "meeep-meep-moop");
            BasicTest.fail((String)"Should have thrown GroupNotFoundException");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroupWhereThereIsNoMembership() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroup");
        this.addGroup(this.getAutoTestGroupName2(), this.directory.getId());
        this.addUserToGroup();
        try {
            this.directory.getImplementation().removeUserFromGroup(this.getAutoTestUserName(), this.getAutoTestGroupName2());
            BasicTest.fail((String)"We should not have a membership and this call should of failed");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromGroup() throws Exception {
        logger.info((Object)"Running testRemoveUserFromGroup");
        this.addUserToGroup();
        this.directory.getImplementation().removeUserFromGroup(this.getAutoTestUserName(), this.getAutoTestGroupName());
        List groupList = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(10));
        BasicTest.assertEquals((String)"Group list should be empty", (int)0, (int)groupList.size());
    }

    public void testFindGroupMembershipsNull() throws Exception {
        logger.info((Object)"Running testFindGroupMembershipsNull");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        try {
            this.directory.getImplementation().searchGroupRelationships(null);
            BasicTest.fail((String)"Should not have found memberships for null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindGroupMembershipsNoGroups() throws Exception {
        logger.info((Object)"Running testFindGroupMembershipsNoGroups");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        List groups = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(10));
        BasicTest.assertNotNull((Object)groups);
        BasicTest.assertEquals((String)"User should not be a member of any groups", (int)0, (int)groups.size());
    }

    public void testFindGroupMemberships() throws Exception {
        logger.info((Object)"Running testFindGroupMemberships");
        this.addUserAndAssertCreation("auto-test-user", "My Test User", "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        this.addGroupWithDescription(this.getAutoTestGroupName(), null);
        this.addGroupWithDescription(this.getAutoTestGroupName2(), null);
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestGroupName());
        this.directory.getImplementation().addUserToGroup(this.getAutoTestUserName(), this.getAutoTestGroupName2());
        List groups = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(10));
        BasicTest.assertNotNull((Object)groups);
        BasicTest.assertEquals((String)"User should be a member of two groups", (int)2, (int)groups.size());
        BasicTest.assertTrue((String)("Groups should contain " + this.getAutoTestGroupName() + " and " + this.getAutoTestGroupName2()), (boolean)groups.containsAll(Arrays.asList(this.getAutoTestGroupName(), this.getAutoTestGroupName2())));
    }

    public void testUpdateUserWithNullDisplayName() throws Exception {
        logger.info((Object)"Running testUpdateUserWithNullFirstNameAndLastName");
        User addedUser = this.addUserAndAssertCreation("auto-test-user", null, "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        UserTemplate modifiedUser = new UserTemplate(addedUser);
        modifiedUser.setDisplayName(null);
        modifiedUser.setFirstName("Auto");
        modifiedUser.setLastName("Test");
        User updatedUser = this.directory.getImplementation().updateUser(modifiedUser);
        BasicTest.assertEquals((String)"calculated displayName", (String)"Auto Test", (String)updatedUser.getDisplayName());
        BasicTest.assertEquals((String)"specified first name", (String)"Auto", (String)updatedUser.getFirstName());
        BasicTest.assertEquals((String)"specified last name", (String)"Test", (String)updatedUser.getLastName());
    }

    public void testUpdateUserWithNullFirstNameAndLastName() throws Exception {
        logger.info((Object)"Running testUpdateUserWithNullFirstNameAndLastName");
        User addedUser = this.addUserAndAssertCreation("auto-test-user", null, "Auto", "Test", "test.emailextension@test-ad-example.com", "My-test-password1", true);
        UserTemplate modifiedUser = new UserTemplate(addedUser);
        modifiedUser.setDisplayName("Auto Test");
        modifiedUser.setFirstName(null);
        modifiedUser.setLastName(null);
        User updatedUser = this.directory.getImplementation().updateUser(modifiedUser);
        BasicTest.assertEquals((String)"newly defined displayName", (String)"Auto Test", (String)updatedUser.getDisplayName());
        BasicTest.assertEquals((String)"calculated first name", (String)"Auto", (String)updatedUser.getFirstName());
        BasicTest.assertEquals((String)"calculated last name", (String)"Test", (String)updatedUser.getLastName());
    }

    public void testSynchroniseUserWithNoDisplayName() throws Exception {
        SpringLDAPConnector ldapDirectory = (SpringLDAPConnector)this.directory.getRawImplementation();
        SpringLDAPConnectorAccessor accessor = new SpringLDAPConnectorAccessor(ldapDirectory);
        UserTemplate userTemplate = new UserTemplate(this.getAutoTestUserName(), -1L);
        userTemplate.setActive(true);
        userTemplate.setDisplayName(this.getAutoTestDisplayName());
        userTemplate.setFirstName(this.getAutoTestFirstName());
        userTemplate.setLastName(this.getAutoTestLastName());
        userTemplate.setEmailAddress(this.getAutoTestValidEmail());
        ldapDirectory.addUser(userTemplate, null);
        LDAPUserWithAttributes currentUser = (LDAPUserWithAttributes)this.directory.getRawImplementation().findUserByName(this.getAutoTestUserName());
        String displayNameAttributeKey = accessor.getLdapPropertiesMapper().getUserDisplayNameAttribute();
        ModificationItem[] items = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(displayNameAttributeKey, " "))};
        accessor.getLdapTemplate().modifyAttributes(currentUser.getDn(), items);
        DbCachingRemoteDirectory internalDirectory = (DbCachingRemoteDirectory)this.directory.getImplementation();
        internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        User user = internalDirectory.findUserByName(this.getAutoTestUserName());
        BasicTest.assertEquals((String)"Display name should have been constructed", (String)(this.getAutoTestFirstName() + " " + this.getAutoTestLastName()), (String)user.getDisplayName());
        internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        User refreshedUser = internalDirectory.findUserByName(this.getAutoTestUserName());
        BasicTest.assertTrue((String)"User should not be updated between syncs", (user == refreshedUser ? 1 : 0) != 0);
    }

    public void testSynchroniseUserWithNoLastName() throws Exception {
        SpringLDAPConnector ldapDirectory = (SpringLDAPConnector)this.directory.getRawImplementation();
        SpringLDAPConnectorAccessor accessor = new SpringLDAPConnectorAccessor(ldapDirectory);
        UserTemplate userTemplate = new UserTemplate(this.getAutoTestUserName(), -1L);
        userTemplate.setActive(true);
        userTemplate.setDisplayName("Bob Smith");
        userTemplate.setFirstName(this.getAutoTestFirstName());
        userTemplate.setLastName(this.getAutoTestLastName());
        userTemplate.setEmailAddress(this.getAutoTestValidEmail());
        ldapDirectory.addUser(userTemplate, null);
        LDAPUserWithAttributes currentUser = (LDAPUserWithAttributes)this.directory.getRawImplementation().findUserByName(this.getAutoTestUserName());
        String lastNameAttributeKey = accessor.getLdapPropertiesMapper().getUserLastNameAttribute();
        ModificationItem[] items = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(lastNameAttributeKey, " "))};
        accessor.getLdapTemplate().modifyAttributes(currentUser.getDn(), items);
        DbCachingRemoteDirectory internalDirectory = (DbCachingRemoteDirectory)this.directory.getImplementation();
        internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        User user = internalDirectory.findUserByName(this.getAutoTestUserName());
        BasicTest.assertEquals((String)"Last name should have been constructed", (String)"Smith", (String)user.getLastName());
        internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        User refreshedUser = internalDirectory.findUserByName(this.getAutoTestUserName());
        BasicTest.assertTrue((String)"User should not be updated between syncs", (user == refreshedUser ? 1 : 0) != 0);
    }

    public void testSynchroniseUserWithNoFirstName() throws Exception {
        SpringLDAPConnector ldapDirectory = (SpringLDAPConnector)this.directory.getRawImplementation();
        SpringLDAPConnectorAccessor accessor = new SpringLDAPConnectorAccessor(ldapDirectory);
        UserTemplate userTemplate = new UserTemplate(this.getAutoTestUserName(), -1L);
        userTemplate.setActive(true);
        userTemplate.setDisplayName("Bob Smith");
        userTemplate.setFirstName(this.getAutoTestFirstName());
        userTemplate.setLastName(this.getAutoTestLastName());
        userTemplate.setEmailAddress(this.getAutoTestValidEmail());
        ldapDirectory.addUser(userTemplate, null);
        LDAPUserWithAttributes currentUser = (LDAPUserWithAttributes)this.directory.getRawImplementation().findUserByName(this.getAutoTestUserName());
        String firstNameAttributeKey = accessor.getLdapPropertiesMapper().getUserFirstNameAttribute();
        ModificationItem[] items = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(firstNameAttributeKey, " "))};
        accessor.getLdapTemplate().modifyAttributes(currentUser.getDn(), items);
        DbCachingRemoteDirectory internalDirectory = (DbCachingRemoteDirectory)this.directory.getImplementation();
        internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        User user = internalDirectory.findUserByName(this.getAutoTestUserName());
        BasicTest.assertEquals((String)"First name should have been constructed", (String)"Bob", (String)user.getFirstName());
        internalDirectory.synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        User refreshedUser = internalDirectory.findUserByName(this.getAutoTestUserName());
        BasicTest.assertTrue((String)"User should not be updated between syncs", (user == refreshedUser ? 1 : 0) != 0);
    }

    public void testFindRoleMembershipsNoRoles() throws Exception {
        logger.info((Object)"Running testFindRoleMembershipsNoRoles");
        this.addUserWithDefaults();
        List roles = this.directory.getImplementation().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.user()).withName(this.getAutoTestUserName()).returningAtMost(-1));
        BasicTest.assertNotNull((Object)roles);
        BasicTest.assertEquals((String)"User should not be a member of any roles", (int)0, (int)roles.size());
    }

    protected String getAutoTestUserName() {
        return "auto-test-user";
    }

    protected String getAutoTestUserName2() {
        return "auto-2-test-user";
    }

    protected String getAutoTestFirstName() {
        return "Auto";
    }

    protected String getAutoTestFirstName2() {
        return "Sir Auto";
    }

    protected String getAutoTestLastName() {
        return "Test";
    }

    protected String getAutoTestPassword() {
        return "My-test-password1";
    }

    protected String getAutoTestPassword2() {
        return "My-test-password1-again";
    }

    protected String getAutoTestPassword3() {
        return "My-test-password1\u20ac";
    }

    protected String getAutoTestValidEmail() {
        return "test.emailextension@test-ad-example.com";
    }

    protected String getAutoTestValidEmail2() {
        return "test.2.emailextension@test-ad-example.com";
    }

    protected String getAutoTestInvalidEmail() {
        return "test_borkborkbork";
    }

    protected String getAutoTestDisplayName() {
        return "My Test User";
    }

    protected String getAutoTestDisplayName2() {
        return "My Test User, Again";
    }

    public String getAutoTestDisplayName3() {
        return "My Test User, Yet Again";
    }

    public String getAutoTestGroupName() {
        return "auto-test-group";
    }

    public String getAutoTestGroupName2() {
        return "auto-2-test-group";
    }

    public String getAutoTestGroupDescription() {
        return "My First Group";
    }

    public String getAutoTestGroupDescription2() {
        return "My First Group With A Better Description";
    }

    public String getAutoTestRoleName() {
        return "auto-test-role-name";
    }

    public String getAutoTestRoleName2() {
        return "auto-2-test-role-name";
    }

    public String getAutoTestRoleDescription() {
        return "My First Role";
    }

    public String getAutoTestRoleDescription2() {
        return "My First Role With A Description of Awesomeness!";
    }
}

