/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.load;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.Action;
import com.atlassian.crowd.acceptance.utils.ActionRunner;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.rmi.RemoteException;
import java.util.Properties;

public class PrincipalAuthenticationLoadTest
extends CrowdAcceptanceTestCase {
    private static final int THREADS = 5;
    private static final int ITERATIONS_PER_THREAD = 30;
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;
    private Properties sscProperties;

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("authloadtest.xml");
        this.sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)this.sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public void testHammerAuthentications() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, InterruptedException {
        this.log("Running testHammerAuthentications");
        this.userAuthenticationContext.setName("user");
        this.userAuthenticationContext.setCredential(new PasswordCredential("user"));
        Action action = new Action(){

            public void execute() throws Exception {
                PrincipalAuthenticationLoadTest.this.securityServerClient.authenticatePrincipal(PrincipalAuthenticationLoadTest.this.userAuthenticationContext);
            }
        };
        ActionRunner runner = new ActionRunner(5, 30, action);
        runner.execute();
        if (runner.getFailures() > 0) {
            PrincipalAuthenticationLoadTest.fail((String)("" + runner.getFailures() + " of the " + 150 + " iterations failed"));
        }
    }
}

