/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;

public class JiraSingleSignOnTest
extends JiraAcceptanceTestCase {
    protected static final String CROWD_ONLY_USER_USERNAME = "crowd-only";
    protected static final String JIRA_ONLY_USER_USERNAME = "jira-admin";
    protected static final String DUAL_ACCESS_USER_USERNAME = "crowd-jira";
    protected static final String PASSWORD = "password";

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("crowdjirasso.xml");
        this.logoutFromCrowd();
        this.logoutFromJira();
    }

    public void testLoginToCrowdConsequentlyLoggedInToJira() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToJira");
        this.logoutFromCrowd();
        this.logoutFromJira();
        String crowdUser = this.loginToCrowd("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertEquals((String)crowdUser, (String)jiraUser);
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        JiraSingleSignOnTest.assertEquals((String)crowdUser, (String)jiraUser);
    }

    public void testLoginToJiraConsequentlyLoggedInToCrowd() {
        this.log("Running testLoginToJiraConsequentlyLoggedInToCrowd");
        this.logoutFromCrowd();
        this.logoutFromJira();
        String jiraUser = this.loginToJira("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        JiraSingleSignOnTest.assertEquals((String)jiraUser, (String)crowdUser);
        jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertEquals((String)jiraUser, (String)crowdUser);
    }

    public void testLogoutOfCrowdConsequentlyLoggedOutOfJira() {
        this.log("Running testLogoutOfCrowdConsequentlyLoggedOutOfJira");
        String crowdUser = this.loginToCrowd("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        this.logoutFromCrowd();
        jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNull((Object)jiraUser);
    }

    public void testLogoutOfJiraConsequentlyLoggedOutOfCrowd() {
        this.log("Running testLogoutOfJiraConsequentlyLoggedOutOfCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        this.logoutFromJira();
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        JiraSingleSignOnTest.assertNull((String)("Should be null, but was <" + crowdUser + ">"), (Object)crowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInJira() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInJira");
        String crowdUser = this.loginToCrowd("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd(DUAL_ACCESS_USER_USERNAME, PASSWORD);
        JiraSingleSignOnTest.assertTrue((!newCrowdUser.equals(crowdUser) ? 1 : 0) != 0);
        String newJiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertEquals((String)newCrowdUser, (String)newJiraUser);
    }

    public void testSwitchUserInJiraConsequentlySwitchesUserInCrowd() {
        this.log("Running testSwitchUserInJiraConsequentlySwitchesUserInCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        this.logoutFromJira();
        String newJiraUser = this.loginToJira(DUAL_ACCESS_USER_USERNAME, PASSWORD);
        JiraSingleSignOnTest.assertNotNull((Object)newJiraUser);
        JiraSingleSignOnTest.assertTrue((!newJiraUser.equals(jiraUser) ? 1 : 0) != 0);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        JiraSingleSignOnTest.assertEquals((String)newCrowdUser, (String)newJiraUser);
    }

    public void testLoginToJiraConsequentlyLoggedInToCrowd_unauthorisedFailure() {
        this.log("Running testLoginToJiraConsequentlyLoggedInToCrowd_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromJira();
        String jiraUser = this.loginToJira(JIRA_ONLY_USER_USERNAME, PASSWORD);
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        JiraSingleSignOnTest.assertNull((Object)crowdUser);
        String currentJiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertEquals((String)jiraUser, (String)currentJiraUser);
    }

    public void testLoginToCrowdConsequentlyLoggedInToJira_unauthorisedFailure() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToJira_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromJira();
        String crowdUser = this.loginToCrowd(CROWD_ONLY_USER_USERNAME, PASSWORD);
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNull((Object)jiraUser);
        String currentCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        JiraSingleSignOnTest.assertEquals((String)crowdUser, (String)currentCrowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInJira_unauthorisedFailure() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInJira_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd(CROWD_ONLY_USER_USERNAME, PASSWORD);
        JiraSingleSignOnTest.assertTrue((!newCrowdUser.equals(crowdUser) ? 1 : 0) != 0);
        String newJiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNull((Object)newJiraUser);
    }

    public void testSwitchUserInJiraConsequentlySwitchesUserInCrowd_unauthorisedFailure() {
        this.log("Running testSwitchUserInJiraConsequentlySwitchesUserInCrowd_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        JiraSingleSignOnTest.assertNotNull((Object)crowdUser);
        String jiraUser = this.getCurrentlyLoggedInJiraUserFullName();
        JiraSingleSignOnTest.assertNotNull((Object)jiraUser);
        this.logoutFromJira();
        String newJiraUser = this.loginToJira(JIRA_ONLY_USER_USERNAME, PASSWORD);
        JiraSingleSignOnTest.assertNotNull((Object)newJiraUser);
        JiraSingleSignOnTest.assertTrue((!newJiraUser.equals(jiraUser) ? 1 : 0) != 0);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        JiraSingleSignOnTest.assertNull((Object)newCrowdUser);
    }
}

