/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;

public class JiraMixedCaseUserTest
extends JiraAcceptanceTestCase {
    protected static final String JIRA_USER_USERNAME = "MixedCaseUser";
    protected static final String JIRA_USER_PASSWORD = "password";
    protected static final String JIRA_USER_FIRSTNAME = "Mixed";
    protected static final String JIRA_USER_LASTNAME = "User";
    protected static final String JIRA_USER_FULLNAME = "Mixed User";
    protected static final String JIRA_USER_EMAIL = "mixedCase@example.com";
    protected static final String JIRA_USER_FIRSTNAME_UPDATED = "MixedCase";
    protected static final String JIRA_USER_LASTNAME_UPDATED = "User";
    protected static final String JIRA_USER_FULLNAME_UPDATED = "MixedCase User";
    protected static final String JIRA_USER_EMAIL_UPDATED = "mixedCase@updatedemail.com";

    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToJira();
    }

    public void testJiraUserCrud() {
        this._testUpdateJiraUser();
        this._testAddJiraUserGroupMembership();
        this._testUserLogin();
        this._testRemoveJiraUserGroupMembership();
        this._testDeleteJiraUser();
    }

    private void _testUpdateJiraUser() {
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME, "User", JIRA_USER_EMAIL, "jira-users");
        this.gotoBrowseUsers();
        this.clickLink(JIRA_USER_USERNAME);
        this.clickLinkWithText("Edit Details");
        this.setWorkingForm("jiraform");
        this.setTextField("fullName", JIRA_USER_FULLNAME_UPDATED);
        this.setTextField("email", JIRA_USER_EMAIL_UPDATED);
        this.submit();
        this.assertTextPresent("User: MixedCase User");
        this.assertTextPresent(JIRA_USER_USERNAME);
        this.assertTextPresent(JIRA_USER_EMAIL_UPDATED);
        this.assertTextPresent("jira-users");
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, "User", JIRA_USER_EMAIL_UPDATED, "jira-users");
    }

    private void _testAddJiraUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLink(JIRA_USER_USERNAME);
        this.clickLink("editgroups_link");
        this.assertTextPresent("Edit User Groups");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "jira-developers", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users"});
        this.setWorkingForm("jiraform");
        this.selectOptionByValue("groupsToJoin", "jira-developers");
        this.submit("join");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users", "jira-developers"});
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, "User", JIRA_USER_EMAIL_UPDATED, "jira-users", "jira-developers");
    }

    private void _testUserLogin() {
        this.loginToJira(JIRA_USER_USERNAME, JIRA_USER_PASSWORD);
        this.assertTextPresent(JIRA_USER_FULLNAME_UPDATED);
    }

    private void _testRemoveJiraUserGroupMembership() {
        this.adminLoginToJira();
        this.gotoBrowseUsers();
        this.clickLink(JIRA_USER_USERNAME);
        this.clickLink("editgroups_link");
        this.assertTextPresent("Edit User Groups");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users", "jira-developers"});
        this.setWorkingForm("jiraform");
        this.selectOptionByValue("groupsToLeave", "jira-developers");
        this.submit("leave");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "jira-developers", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users"});
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, "User", JIRA_USER_EMAIL_UPDATED, "jira-users");
    }

    private void _testDeleteJiraUser() {
        this.gotoBrowseUsers();
        this.clickLink("deleteuser_link_MixedCaseUser");
        this.assertTextPresent("Delete User: MixedCaseUser");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("User Browser");
        this.assertTextNotInTable("user_browser_table", new String[]{JIRA_USER_USERNAME});
        this.verifyUserDoesNotExistInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, "User", JIRA_USER_EMAIL_UPDATED, new String[0]);
    }
}

