/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid.client;

import com.atlassian.crowd.acceptance.tests.applications.crowdid.client.CrowdIDClientAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;

public class OpenIDAuthenticationTest
extends CrowdIDClientAcceptanceTestCase {
    protected static String OPENIDSERVER_LOGIN_URL_ADMIN;
    protected static String OPENID_CLIENT_LOGIN;
    protected static String OPENID_SERVER_URL;
    protected static final String SERVER_NAME = "crowdid";

    public void setUp() throws Exception {
        super.setUp();
        this.loginToCrowd();
        this.restoreCrowdFromXML("basesetup.xml");
        this.logoutFromCrowd();
        this.specProperties = AcceptanceTestHelper.loadProperties("localtest.properties");
        String client_port = this.getTestProperty(this.getApplicationName() + ".port");
        String client_context = this.getTestProperty(this.getApplicationName() + ".context");
        String client_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + client_port;
        String server_port = this.getTestProperty("crowdid.port");
        String server_context = this.getTestProperty("crowdid.context");
        String server_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + server_port;
        OPENID_CLIENT_LOGIN = client_rootUrl + client_context + "/login.openid";
        OPENID_SERVER_URL = server_rootUrl + server_context;
        OPENIDSERVER_LOGIN_URL_ADMIN = OPENID_SERVER_URL + "/users/" + "admin";
    }

    protected void assertAtClientLoginPage() {
        this.assertKeyPresent("login.title");
        this.assertKeyNotPresent("menu.logout.label");
        this.assertKeyNotPresent("menu.profile.label");
    }

    protected void assertAtServerLoginPage() {
        this.assertTitleEquals("Atlassian CrowdID - Login");
    }

    protected void assertAtServerAllowDenyPage() {
        this.assertTitleEquals("Atlassian CrowdID - OpenID Verification");
        this.assertTextInElement("requestingSite", OPENID_CLIENT_LOGIN);
        this.assertTextInElement("requestingIdentity", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.assertTextInElement("requestingAttributes", "nickname   email   fullname   dob   gender   postcode   country   language   timezone");
        this.assertTextInTable("attributeTable", new String[]{"Nickname", "admin"});
        this.assertTextInTable("attributeTable", new String[]{"Full Name", "Super User"});
        this.assertTextInTable("attributeTable", new String[]{"Email", "admin@example.com"});
        this.assertTextInTable("attributeTable", "Country");
        this.assertTextInTable("attributeTable", "Language");
    }

    protected void assertAtClientProfilePage() {
        this.assertKeyNotPresent("login.title");
        this.assertKeyPresent("menu.logout.label");
        this.assertKeyPresent("menu.profile.label");
        this.assertTextInTable("identifierTable", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.assertTextInTable("attributesTable", new String[]{"nickname", "admin"});
        this.assertTextInTable("attributesTable", new String[]{"email", "admin@example.com"});
        this.assertTextInTable("attributesTable", new String[]{"fullname", "Super User"});
        this.assertTextInTable("attributesTable", "language");
        this.assertTextInTable("attributesTable", "country");
    }

    public void testOpenIDAuthenticationAllow() {
        this.log("Running testOpenIDAuthenticationAllow");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.assertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertAtServerAllowDenyPage();
        this.clickLink("allow");
        this.assertAtClientProfilePage();
    }

    public void testOpenIDAuthenticationDeny() {
        this.log("Running testOpenIDAuthenticationDeny");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.assertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertAtServerAllowDenyPage();
        this.clickLink("deny");
        this.assertAtClientLoginPage();
        this.assertTextPresent("Authentication Failed: Your OpenID provider was unable to authenticate the OpenID URL. Log in to your OpenID provider and try again.");
    }

    public void testOpenIDAuthenticationStateless() {
        this.log("Running testOpenIDAuthenticationStateless");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.checkCheckbox("dummyMode");
        this.submit();
        this.assertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertAtServerAllowDenyPage();
        this.clickLink("allow");
        this.assertAtClientProfilePage();
    }

    public void testOpenIDAuthenticationImmediate_fail() {
        this.log("Running testOpenIDAuthenticationImmediate_fail");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.checkCheckbox("checkImmediate");
        this.submit();
        this.assertAtClientLoginPage();
        this.assertTextPresent("Authentication Failed: Your OpenID provider was unable to authenticate the OpenID URL. Log in to your OpenID provider and try again.");
    }
}

