/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ViewRoleTest
extends CrowdAcceptanceTestCase {
    private static final String CROWD_USERS_ROLE = "crowd-users";
    private static final String CROWD_DEVELOPERS_ROLE = "crowd-developers";

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("viewroletest.xml");
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testUpdateRole() {
        this.log("Running: testUpdateRole");
        this.gotoViewRole(CROWD_USERS_ROLE, "Atlassian");
        this.setWorkingForm("roleForm");
        this.setTextField("description", "test-description");
        this.uncheckCheckbox("active");
        this.submit();
        this.setWorkingForm("roleForm");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("description", "test-description");
        this.assertCheckboxNotSelected("active");
    }

    public void testViewRoleMembers() {
        this.log("Running: testViewRoleMembers");
        this.gotoViewRole(CROWD_DEVELOPERS_ROLE, "Atlassian");
        this.clickLink("view-role-principals");
        this.assertTextInTable("view-role-principals", new String[]{"justin", "justin@atlassian.com", "true"});
    }

    public void testViewRoleMembersThenRemoveRole() {
        this.log("Running: testViewRoleMembersThenRemoveRole");
        this.gotoViewRole(CROWD_DEVELOPERS_ROLE, "Atlassian");
        this.clickLink("view-role-principals");
        this.clickLinkWithKey("menu.removerole.label");
        this.assertWarningNotPresent();
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
    }

    public void testViewRoleMembersNoneAssigned() {
        this.log("Running: testViewRoleMembersNoneAssigned");
        this.gotoViewRole(CROWD_USERS_ROLE, "Atlassian");
        this.clickLink("view-role-principals");
        this.assertKeyPresent("viewprincipals.role.noprincipals.assigned", EasyList.build((Object)CROWD_USERS_ROLE));
    }
}

