/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ViewGroupTest
extends CrowdAcceptanceTestCase {
    private static final String CROWD_ADMINISTRATORS_GROUP = "crowd-administrators";
    private static final String CROWD_DEVELOPERS_GROUP = "crowd-developers";
    private static final String TEST_INTERNAL_DIRECTORY = "Test Internal Directory";

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testUpdateGroup() {
        this.log("Running: testUpdateGroup");
        this.gotoViewGroup(CROWD_ADMINISTRATORS_GROUP, TEST_INTERNAL_DIRECTORY);
        this.setWorkingForm("groupForm");
        this.setTextField("description", "test-description");
        this.uncheckCheckbox("active");
        this.submit();
        this.setWorkingForm("groupForm");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("description", "test-description");
        this.assertCheckboxNotSelected("active");
    }

    public void testViewGroupMembers() {
        this.log("Running: testViewGroupMembers");
        this.gotoViewGroup(CROWD_ADMINISTRATORS_GROUP, TEST_INTERNAL_DIRECTORY);
        this.clickLink("view-group-users");
        this.assertKeyNotPresent("group.modify.disabled");
        this.assertButtonPresent("addUsers");
        this.assertButtonPresent("removeUsers");
        this.assertTextInTable("view-group-users", new String[]{"admin", "admin@example.com", "true"});
    }

    public void testViewGroupMembersThenRemoveGroup() {
        this.log("Running: testViewGroupMembersThenRemoveGroup");
        this.gotoViewGroup(CROWD_DEVELOPERS_GROUP, TEST_INTERNAL_DIRECTORY);
        this.clickLink("view-group-users");
        this.clickLinkWithKey("menu.removegroup.label");
        this.assertWarningNotPresent();
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
    }

    public void testViewGroupMembersNoneAssigned() {
        this.log("Running: testViewGroupMembersNoneAssigned");
        this.gotoViewGroup(CROWD_DEVELOPERS_GROUP, TEST_INTERNAL_DIRECTORY);
        this.clickLink("view-group-users");
        this.assertKeyPresent("viewprincipals.group.noprincipals.assigned", EasyList.build((Object)CROWD_DEVELOPERS_GROUP));
    }

    public void testViewGroupMembersNoModifyPermissions() {
        this.log("Running: testViewGroupNoModifyPermissions");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(TEST_INTERNAL_DIRECTORY);
        this.clickLink("internal-permissions");
        this.setWorkingForm("permissionForm");
        this.uncheckCheckbox("permissionGroupModify");
        this.submit();
        this.gotoViewGroup(CROWD_ADMINISTRATORS_GROUP, TEST_INTERNAL_DIRECTORY);
        this.clickLink("view-group-users");
        this.assertKeyPresent("group.modify.disabled");
        this.assertButtonNotPresent("addUsers");
        this.assertButtonNotPresent("removeUsers");
        this.assertTextInTable("view-group-users", new String[]{"admin", "admin@example.com", "true"});
    }
}

