/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;

public class ViewDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String INTERNAL_DIRECTORY_NAME = "Second Directory";
    private static final String CROWD_DIRECTORY_NAME = "Remote Crowd Directory";
    private static final String CONNECTOR_DIRECTORY_NAME_APACHEDS = "ApacheDS Directory";
    private static final String CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING = "ApacheDS Caching Directory";
    private static final String CONNECTOR_DIRECTORY_NAME_GENERIC = "GenericLDAP Directory";
    private static final String CUSTOM_DIRECTORY_NAME = "Custom Directory";
    private static final String DELEGATED_DIRECTORY_NAME_APACHEDS = "ApacheDS Delegated Directory";
    private static final String DELEGATED_DIRECTORY_NAME_GENERIC = "Generic Delegated Directory";
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("viewdirectory.xml");
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testUpdateInternalDirectoryGeneralScreen() {
        this.log("Running: testUpdateInternalDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.setTextField("name", "Update Second Directory");
        this.setTextField("directoryDescription", "Update Second Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Second Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Second Directory Description");
    }

    public void testUpdateInternalDirectoryConfiguration() {
        this.log("Running: testUpdateInternalDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
        this.clickLink("internal-configuration");
        this.setWorkingForm("updateConfiguration");
        this.setTextField("passwordRegex", ".*");
        this.setTextField("passwordMaxAttempts", "10");
        this.setTextField("passwordMaxChangeTime", "15");
        this.setTextField("passwordHistoryCount", "20");
        this.submit();
        this.assertTextFieldEquals("passwordRegex", ".*");
        this.assertTextFieldEquals("passwordMaxAttempts", "10");
        this.assertTextFieldEquals("passwordMaxChangeTime", "15");
        this.assertTextFieldEquals("passwordHistoryCount", "20");
    }

    public void testUpdateInternalDirectoryPermissions() {
        this.log("Running: testUpdateInternalDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
        this.clickLink("internal-permissions");
        this.setWorkingForm("permissionForm");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.uncheckCheckbox("permissionRoleAdd");
        this.submit();
        this.setWorkingForm("permissionForm");
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
        this.assertCheckboxNotSelected("permissionRoleAdd");
        this.setWorkingForm("permissionForm");
        this.checkCheckbox("permissionGroupAdd");
        this.checkCheckbox("permissionPrincipalAdd");
        this.checkCheckbox("permissionRoleAdd");
        this.submit();
        this.setWorkingForm("permissionForm");
        this.assertCheckboxSelected("permissionGroupAdd");
        this.assertCheckboxSelected("permissionPrincipalAdd");
        this.assertCheckboxSelected("permissionRoleAdd");
    }

    public void testUpdateInternalDirectoryGeneralScreenError() {
        this.log("Running: testUpdateInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateInternalDirectoryGeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateInternalDirectoryGeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
        this.setTextField("name", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
    }

    public void testUpdateInternalDirectoryConfigurationScreenErrors() {
        this.log("Running: testUpdateInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
        this.clickLink("internal-configuration");
        this.setWorkingForm("updateConfiguration");
        this.setTextField("passwordRegex", "[]");
        this.setTextField("passwordMaxAttempts", "-1");
        this.setTextField("passwordMaxChangeTime", "-2");
        this.setTextField("passwordHistoryCount", "-3");
        this.submit();
        this.assertTextPresent("Unclosed character class near index 1 [] ^");
        this.assertKeyPresent("directoryinternal.passwordmaxchangetime.invalid");
        this.assertKeyPresent("directoryinternal.passwordmaxattempts.invalid");
        this.assertKeyPresent("directoryinternal.passwordhistorycount.invalid");
    }

    public void testUpdateCrowdDirectoryGeneralScreen() {
        this.log("Running: testUpdateCrowdDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.setTextField("name", "Update Second Directory");
        this.setTextField("directoryDescription", "Update Second Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Second Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Second Directory Description");
    }

    public void testViewCrowdDirectorySynchroniseCache() throws Exception {
        this.log("running testViewCrowdDirectorySynchroniseCache");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("directory.caching.sync.never.label");
        DbCachingTestHelper.synchroniseDirectory(this.tester, CROWD_DIRECTORY_NAME, 60000L);
    }

    public void testUpdateCrowdDirectoryGeneralScreenError() {
        this.log("Running: testUpdateCrowdDirectoryGeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateCrowdDirectoryGeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateCrowdDirectoryGeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.setTextField("name", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
    }

    public void testUpdateCrowdDirectoryConnectionScreen() {
        this.log("Running: testUpdateCrowdDirectoryConnectionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl() + "2");
        this.setTextField("applicationName", "jira2");
        this.setTextField("pollingIntervalInMin", "100");
        this.setTextField("httpTimeout", "12");
        this.setTextField("httpMaxConnections", "123");
        this.setTextField("httpProxyPort", "5432");
        this.setTextField("httpProxyUsername", "proxyuser");
        this.submit();
        this.assertTextFieldEquals("url", this.getBaseUrl() + "2");
        this.assertTextFieldEquals("applicationName", "jira2");
        this.assertTextFieldEquals("pollingIntervalInMin", "100");
        this.assertTextFieldEquals("httpTimeout", "12");
        this.assertTextFieldEquals("httpMaxConnections", "123");
        this.assertTextFieldEquals("httpProxyPort", "5432");
        this.assertTextFieldEquals("httpProxyUsername", "proxyuser");
    }

    public void testUpdateCrowdTestConnectionWithCredentials() {
        this.log("Running: testUpdateCrowdTestConnectionWithCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "jira");
        this.setTextField("applicationPassword", "password");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.success");
    }

    public void testUpdateCrowdTestConnectionInvalidNoPassword() {
        this.log("Running: testUpdateCrowdTestConnectionInvalidNoPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.clickLink("crowd-connectiondetails");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.invalid");
    }

    public void testUpdateCrowdTestConnectionInvalidURL() {
        this.log("Running: testUpdateCrowdTestConnectionInvalidURL");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl() + "/invalidUrl");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.invalid");
    }

    public void testUpdateCrowdDirectoryConnectionScreenError() {
        this.log("Running: testUpdateCrowdDirectoryConnectionScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", "");
        this.setTextField("applicationName", "");
        this.submit();
        this.assertKeyPresent("directorycrowd.url.invalid");
        this.assertKeyPresent("directorycrowd.applicationname.invalid");
    }

    public void testUpdateCrowdDirectoryPermissionScreen() {
        this.log("Running: testUpdateCrowdDirectoryPermissionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.clickLink("crowd-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.uncheckCheckbox("permissionRoleAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
        this.assertCheckboxNotSelected("permissionRoleAdd");
    }

    public void testUpdateConnectorDirectoryGeneralScreen() {
        this.log("Running: testUpdateConnectorDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.setWorkingForm("updateGeneral");
        this.setTextField("name", "Update Second Directory");
        this.setTextField("directoryDescription", "Update Second Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Second Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Second Directory Description");
    }

    public void testViewConnectorDirectorySynchroniseCache() throws Exception {
        this.log("running testViewConnectorDirectorySynchroniseCache");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("directory.caching.sync.never.label");
        DbCachingTestHelper.synchroniseDirectory(this.tester, CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING, 60000L);
    }

    public void testUpdateConnectorDirectoryGeneralScreenError() {
        this.log("Running: testUpdateConnectorDirectoryGeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateConnectorDirectoryGeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateConnectorDirectoryGeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.setTextField("name", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
    }

    public void testUpdateConnectorDirectoryConnectionScreen() {
        this.log("Running: testUpdateConnectorDirectoryConnectionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.checkCheckbox("pagedResults");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
        this.assertCheckboxSelected("pagedResults");
    }

    public void testUpdateConnectorTestConnectionWithCredentials() {
        this.log("Running: testUpdateConnectorTestConnectionWithCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorTestConnectionWithoutCredentials() {
        this.log("Running: testUpdateConnectorTestConnectionWithoutCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorTestConnectionInvalidNoPassword() {
        this.log("Running: testUpdateConnectorTestConnectionInvalidNoPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateConnectorTestConnectionInvalidURL() {
        this.log("Running: testUpdateConnectorTestConnectionInvalidURL");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateConnectorDirectoryConnectionScreenWithPwdEncryption() {
        this.log("Running: testUpdateConnectorDirectoryConnectionScreenWithPwdEncryption");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_GENERIC);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_GENERIC));
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.selectOption("userEncryptionMethod", "DES");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.checkCheckbox("useUserMembershipAttribute");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "DES");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
        this.assertCheckboxSelected("pagedResults");
        this.assertCheckboxSelected("useUserMembershipAttribute");
    }

    public void testUpdateConnectorDirectoryConnectionScreenError() {
        this.log("Running: testUpdateConnectorDirectoryConnectionScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid");
    }

    public void testUpdateConnectorDirectoryConfigurationScreen() {
        this.log("Running: testUpdateConnectorDirectoryConfigurationScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("groupDNaddition", "1");
        this.setTextField("groupObjectClass", "2");
        this.setTextField("groupObjectFilter", "3");
        this.setTextField("groupNameAttr", "4");
        this.setTextField("groupDescriptionAttr", "5");
        this.setTextField("groupMemberAttr", "6");
        this.checkCheckbox("rolesDisabled");
        this.setTextField("roleDNaddition", "7");
        this.setTextField("roleObjectClass", "8");
        this.setTextField("roleObjectFilter", "9");
        this.setTextField("roleNameAttr", "10");
        this.setTextField("roleDescriptionAttr", "11");
        this.setTextField("roleMemberAttr", "12");
        this.setTextField("userDNaddition", "13");
        this.setTextField("userObjectClass", "14");
        this.setTextField("userObjectFilter", "15");
        this.setTextField("userNameAttr", "16");
        this.setTextField("userNameRdnAttr", "17");
        this.setTextField("userFirstnameAttr", "18");
        this.setTextField("userLastnameAttr", "19");
        this.setTextField("userMailAttr", "20");
        this.setTextField("userGroupMemberAttr", "21");
        this.setTextField("userPasswordAttr", "22");
        this.setTextField("userDisplayNameAttr", "23");
        this.submit();
        this.assertTextFieldEquals("groupDNaddition", "1");
        this.assertTextFieldEquals("groupObjectClass", "2");
        this.assertTextFieldEquals("groupObjectFilter", "3");
        this.assertTextFieldEquals("groupNameAttr", "4");
        this.assertTextFieldEquals("groupDescriptionAttr", "5");
        this.assertTextFieldEquals("groupMemberAttr", "6");
        this.assertCheckboxSelected("rolesDisabled");
        this.assertTextFieldEquals("roleDNaddition", "7");
        this.assertTextFieldEquals("roleObjectClass", "8");
        this.assertTextFieldEquals("roleObjectFilter", "9");
        this.assertTextFieldEquals("roleNameAttr", "10");
        this.assertTextFieldEquals("roleDescriptionAttr", "11");
        this.assertTextFieldEquals("roleMemberAttr", "12");
        this.assertTextFieldEquals("userDNaddition", "13");
        this.assertTextFieldEquals("userObjectClass", "14");
        this.assertTextFieldEquals("userObjectFilter", "15");
        this.assertTextFieldEquals("userNameAttr", "16");
        this.assertTextFieldEquals("userNameRdnAttr", "17");
        this.assertTextFieldEquals("userFirstnameAttr", "18");
        this.assertTextFieldEquals("userLastnameAttr", "19");
        this.assertTextFieldEquals("userMailAttr", "20");
        this.assertTextFieldEquals("userGroupMemberAttr", "21");
        this.assertTextFieldEquals("userPasswordAttr", "22");
        this.assertTextFieldEquals("userDisplayNameAttr", "23");
    }

    public void testUpdateConnectorDirectoryConfigurationScreenError() {
        this.log("Running: testUpdateConnectorDirectoryConfigurationScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("groupDNaddition", "");
        this.setTextField("groupObjectClass", "");
        this.setTextField("groupObjectFilter", "");
        this.setTextField("groupNameAttr", "");
        this.setTextField("groupDescriptionAttr", "");
        this.setTextField("groupMemberAttr", "");
        this.setTextField("roleDNaddition", "");
        this.setTextField("roleObjectClass", "");
        this.setTextField("roleObjectFilter", "");
        this.setTextField("roleNameAttr", "");
        this.setTextField("roleDescriptionAttr", "");
        this.setTextField("roleMemberAttr", "");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userNameRdnAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userDisplayNameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userPasswordAttr", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.groupobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.groupobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.groupname.invalid");
        this.assertKeyPresent("directoryconnector.groupmember.invalid");
        this.assertKeyPresent("directoryconnector.groupdescription.invalid");
        this.assertKeyPresent("directoryconnector.roleobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.roleobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.rolename.invalid");
        this.assertKeyPresent("directoryconnector.rolemember.invalid");
        this.assertKeyPresent("directoryconnector.roledescription.invalid");
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usernamerdnattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userdisplaynameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userpassword.invalid");
    }

    public void testUpdateConnectorConfigurationSearchGroup() {
        this.log("Running: testUpdateConnectorConfigurationSearchGroup");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("groupDNaddition", "");
        this.clickButton("test-search-group");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorConfigurationSearchRole() {
        this.log("Running: testUpdateConnectorConfigurationSearchRole");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("roleDNaddition", "");
        this.clickButton("test-search-role");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorConfigurationSearchPrincipal() {
        this.log("Running: testUpdateConnectorConfigurationSearchPrincipal");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("userDNaddition", "");
        this.clickButton("test-search-principal");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorConfigurationSearchGroupInvalid() {
        this.log("Running: testUpdateConnectorConfigurationSearchGroupInvalid");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("groupDNaddition", "ou=nonexistentgroup");
        this.clickButton("test-search-group");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorConfigurationSearchRoleInvalid() {
        this.log("Running: testUpdateConnectorConfigurationSearchRoleInvalid");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("roleDNaddition", "ou=nonexistentrole");
        this.clickButton("test-search-role");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorConfigurationSearchPrincipalInvalid() {
        this.log("Running: testUpdateConnectorConfigurationSearchPrincipalInvalid");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-configuration");
        this.setTextField("userDNaddition", "ou=nonexistentprincipal");
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorConfigurationRolesDisabled() throws Exception {
        this.log("Running: testUpdateConnectorConfigurationRolesDisabled");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLink("connector-configuration");
        this.checkCheckbox("rolesDisabled");
        this.submit();
        this.assertCheckboxSelected("rolesDisabled");
        this.gotoBrowseRoles();
        this.assertSelectOptionNotPresent("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
    }

    public void testUpdateConnectorDirectoryPermissionScreen() {
        this.log("Running: testUpdateConnectorDirectoryConfigurationScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.uncheckCheckbox("permissionRoleAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
        this.assertCheckboxNotSelected("permissionRoleAdd");
    }

    public void testUpdateDelegatedDirectoryGeneralScreen() {
        this.log("Running: testUpdateDelegatedDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.setTextField("name", "Update Delegated Directory");
        this.setTextField("directoryDescription", "Update Delegated Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Delegated Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Delegated Directory Description");
    }

    public void testUpdateDelegatedDirectoryGeneralScreenError() {
        this.log("Running: testUpdateDelegatedDirectoryGeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateDelegatedDirectoryGeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateDelegatedDirectoryGeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.setTextField("name", INTERNAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
    }

    public void testUpdateDelegatedDirectoryConnectionScreen() {
        this.log("Running: testUpdateDelegatedDirectoryConnectionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
    }

    public void testUpdateDelegatedDirectoryConnectionScreenWithPwdEncryption() {
        this.log("Running: testUpdateDelegatedDirectoryConnectionScreenWithPwdEncryption");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_GENERIC);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_GENERIC));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.selectOption("userEncryptionMethod", "DES");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "DES");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
    }

    public void testUpdateDelegatedDirectoryConnectionScreenError() {
        this.log("Running: testUpdateDelegatedDirectoryConnectionScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid");
    }

    public void testUpdateDelegatedDirectoryConnectionScreenInvalidPassword() {
        this.log("Running: testUpdateDelegatedDirectoryConnectionScreenInvalidPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("ldapPassword", "invalid");
        this.submit();
        this.assertWarningPresent();
    }

    public void testUpdateDelegatedDirectoryTestConnectionWithCredentials() {
        this.log("Running: testUpdateDelegatedDirectoryTestConnectionWithCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateDelegatedDirectoryTestConnectionWithoutCredentials() {
        this.log("Running: testUpdateDelegatedDirectoryTestConnectionWithoutCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateDelegatedDirectoryTestConnectionInvalidNoPassword() {
        this.log("Running: testUpdateDelegatedDirectoryTestConnectionInvalidNoPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateDelegatedDirectoryTestConnectionInvalidURL() {
        this.log("Running: testUpdateDelegatedDirectoryTestConnectionInvalidURL");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-connectiondetails");
        this.setTextField("URL", "ldap://localhost:123/");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateDelegatedConfigurationSearchPrincipal() {
        this.log("Running: testUpdateDelegatedConfigurationSearchPrincipal");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "");
        this.clickButton("test-search-principal");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateDelegatedConfigurationSearchPrincipalInvalid() {
        this.log("Running: testUpdateDelegatedConfigurationSearchPrincipalInvalid");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "ou=nonexistentprincipal");
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateDelegatedDirectoryConfigurationScreen() {
        this.log("Running: testUpdateDelegatedDirectoryConfigurationScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "13");
        this.setTextField("userObjectClass", "14");
        this.setTextField("userObjectFilter", "15");
        this.setTextField("userNameAttr", "16");
        this.setTextField("userNameRdnAttr", "17");
        this.setTextField("userFirstnameAttr", "18");
        this.setTextField("userLastnameAttr", "19");
        this.setTextField("userMailAttr", "20");
        this.setTextField("userGroupMemberAttr", "21");
        this.setTextField("userPasswordAttr", "22");
        this.setTextField("userDisplayNameAttr", "23");
        this.submit();
        this.assertTextFieldEquals("userDNaddition", "13");
        this.assertTextFieldEquals("userObjectClass", "14");
        this.assertTextFieldEquals("userObjectFilter", "15");
        this.assertTextFieldEquals("userNameAttr", "16");
        this.assertTextFieldEquals("userNameRdnAttr", "17");
        this.assertTextFieldEquals("userFirstnameAttr", "18");
        this.assertTextFieldEquals("userLastnameAttr", "19");
        this.assertTextFieldEquals("userMailAttr", "20");
        this.assertTextFieldEquals("userGroupMemberAttr", "21");
        this.assertTextFieldEquals("userPasswordAttr", "22");
        this.assertTextFieldEquals("userDisplayNameAttr", "23");
    }

    public void testUpdateDelegatedDirectoryConfigurationScreenError() {
        this.log("Running: testUpdateDelegatedDirectoryConfigurationScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userNameRdnAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userDisplayNameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userPasswordAttr", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usernamerdnattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userdisplaynameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userpassword.invalid");
    }

    public void testUpdateDelegatedDirectoryPermissionScreen() {
        this.log("Running: testUpdateDelegatedDirectoryPermissionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)DELEGATED_DIRECTORY_NAME_APACHEDS));
        this.clickLink("delegated-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.uncheckCheckbox("permissionRoleAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
        this.assertCheckboxNotSelected("permissionRoleAdd");
    }

    public void testUpdateCustomDirectoryGeneralScreen() {
        this.log("Running: testUpdateCustomDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
        this.setTextField("name", "Update Custom Directory");
        this.setTextField("directoryDescription", "Update Custom Directory Description");
        this.uncheckCheckbox("active");
        this.submit();
        this.assertTextFieldEquals("name", "Update Custom Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Custom Directory Description");
        this.assertCheckboxNotSelected("active");
    }

    public void testUpdateCustomDirectoryGeneralScreenError() {
        this.log("Running: testUpdateCustomDirectoryGeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateCustomDirectoryGeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateCustomDirectoryGeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
        this.setTextField("name", INTERNAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", EasyList.build((Object)INTERNAL_DIRECTORY_NAME));
    }

    public void testUpdateCustomDirectoryAttributesAddNewAttribute() {
        this.log("Running: testUpdateCustomDirectoryAttributesAddNewAttribute");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
        this.clickLink("custom-attributes");
        this.setTextField("attribute", "New Attribute");
        this.setTextField("value", "123");
        this.clickButton("add-attribute");
        this.assertTextInTable("attributesTable", new String[]{"New Attribute", "123"});
    }

    public void testUpdateCustomDirectoryAttributesWithError() {
        this.log("Running: testUpdateCustomDirectoryAttributesAddMultipleValuesForAttribute");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
        this.clickLink("custom-attributes");
        this.setTextField("attribute", "New Attribute");
        this.setTextField("value", "");
        this.clickButton("add-attribute");
        this.assertKeyPresent("directorycustom.attribute.invalid");
    }

    public void testUpdateCustomDirectoryAttributesRemovingAttribute() {
        this.log("Running: testUpdateCustomDirectoryAttributesAddMultipleValuesForAttribute");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
        this.clickLink("custom-attributes");
        this.clickLink("remove-attribute-testattrib");
        this.assertTextNotInTable("attributesTable", new String[]{"testattrib"});
    }

    public void testUpdateCustomDirectoryPermissionScreen() {
        this.log("Running: testUpdateDelegatedDirectoryPermissionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CUSTOM_DIRECTORY_NAME));
        this.clickLink("custom-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.uncheckCheckbox("permissionRoleAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
        this.assertCheckboxNotSelected("permissionRoleAdd");
    }

    public void testUpdatePagedResultsOnConnectorDirectoryWithInvalidAmount() {
        this.log("Running: testUpdatePagedResultsOnConnectorDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.uncheckCheckbox("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "");
        this.checkCheckbox("pagedResults");
        this.setTextField("pagedResultsSize", "99");
        this.submit();
        this.assertKeyPresent("directoryconnector.pagedresultscontrolsize.invalid");
    }

    public void testUpdatePagedResultsOnConnectorDirectoryWithValidAmount() {
        this.log("Running: testUpdatePagedResultsOnConnectorDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS));
        this.clickLink("connector-connectiondetails");
        this.uncheckCheckbox("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "");
        this.checkCheckbox("pagedResults");
        this.setTextField("pagedResultsSize", "100");
        this.submit();
        this.assertKeyNotPresent("directoryconnector.pagedresultscontrolsize.invalid");
        this.assertTextFieldEquals("pagedResultsSize", "100");
    }

    public void testViewConnectorGroupRoleDnOverlapWarning() {
        this.log("Running: testViewConnectorGroupRoleDnOverlapWarning");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertWarningPresentWithKey("directoryconnector.rolednaddition.invalid");
        this.clickLink("connector-configuration");
        this.setWorkingForm("configuration_details");
        this.checkCheckbox("rolesDisabled");
        this.submit();
        this.assertWarningNotPresent();
    }

    public void testViewDelegatingNoGroupRoleDnOverlapWarning() {
        this.log("Running: testViewDelegatingNoGroupRoleDnOverlapWarning");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertWarningNotPresent();
    }
}

