/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import junit.framework.AssertionFailedError;
import org.apache.commons.lang.StringUtils;

public class SetupCrowdWithDatabase
extends CrowdAcceptanceTestCase {
    private static final String UNSPECIFIED_DATABASE_TYPE = "${database.type}";
    private static final String DATABASE_TYPE = System.getProperty("database.type", "");
    private static final String DATABASE_USERNAME = System.getProperty("database.username");
    private static final String DATABASE_PASSWORD = System.getProperty("database.password");
    private static final String DATABASE_DIALECT = System.getProperty("database.dialect");
    private static final String DATABASE_DRIVER = System.getProperty("database.driver");
    private static final String DATABASE_URL = System.getProperty("database.url");
    private static final String HSQLDB_USERNAME = "sa";
    private static final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    private static final String HSQLDB_DIALECT = "org.hibernate.dialect.HSQLDialect";
    private static final String HSQLDB_URL_PREFIX = "jdbc:hsqldb:";
    private static final String HSQLDB_URL_SUFFIX = "/database/defaultdb";

    public void testSetup() throws Exception {
        this._testLicenseScreen();
        this._testLicenseSuccess();
        this._testInstallScreen();
        this._testInstallNew();
        this.setScriptingEnabled(true);
        this._testDatabaseScreen();
        this._testDatabaseSelectJDBC();
        this.setScriptingEnabled(false);
        this._testOptionsScreen();
        this._testOptionsSuccess();
        this._testMailServerScreen();
        this._testMailServerSuccess();
        this._testInternalDirectoryScreen();
        this._testInternalDirectorySuccess();
        this._testDefaultAdminScreen();
        this._testDefaultAdminSuccess();
        this._testConfigureIntegratedApps();
        this._testCompleteSetup();
        this._testDatabaseSystemInfo();
    }

    private void _testLicenseScreen() {
        this.log("Running _testLicenseScreen");
        this.beginAt("/console/setup/setuplicense.action");
        this.assertKeyPresent("license.title");
        this.assertKeyPresent("license.serverid.label");
    }

    private void _testLicenseSuccess() {
        this.log("Running _testLicenseSuccess");
        this.setTextField("key", "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm");
        this.submit();
        this.assertKeyNotPresent("license.title");
    }

    private void _testInstallScreen() {
        this.log("Running _testInstallScreen");
        this.assertKeyPresent("install.title");
        this.assertKeyPresent("install.new.label");
        this.assertKeyPresent("install.upgrade.xml.label");
        this.assertKeyNotPresent("install.upgrade.db.label");
    }

    private void _testInstallNew() {
        this.log("Running _testInstallNew");
        this.clickRadioOption("installOption", "install.new");
        this.submit();
        this.assertKeyNotPresent("install.title");
    }

    private void _testDatabaseScreen() {
        this.log("Running _testDatabaseScreen");
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.embedded.label");
        this.assertKeyPresent("database.jdbc.label");
        this.assertKeyPresent("database.datasource.label");
    }

    private void _testDatabaseSelectJDBC() {
        this.log("Running _testDatabaseSelectJDBC");
        this.logger.info((Object)"Database properties to be used in setup:");
        this.logger.info((Object)("   database.type: <" + DATABASE_TYPE + ">"));
        this.logger.info((Object)("   database.username: <" + DATABASE_USERNAME + ">"));
        this.logger.info((Object)("   database.password: <" + DATABASE_PASSWORD + ">"));
        this.logger.info((Object)("   database.driver: <" + DATABASE_DRIVER + ">"));
        this.logger.info((Object)("   database.dialect: <" + DATABASE_DIALECT + ">"));
        this.logger.info((Object)("   database.url: <" + DATABASE_URL + ">"));
        if (!this.isDatabaseSpecified()) {
            this.logger.warn((Object)"Falling back to HSQLDB since system properties to specify which database to use were not found");
            this.logger.warn((Object)"Please set the above system properties to specify a real database!");
            this.clickRadioOption("databaseOption", "db.embedded");
            this.submit();
        } else {
            this.clickRadioOption("databaseOption", "db.jdbc");
            this.selectOptionByValue("jdbcDatabaseType", DATABASE_TYPE);
            this.setTextField("jdbcDriverClassName", "");
            this.setTextField("jdbcUsername", DATABASE_USERNAME);
            this.setTextField("jdbcPassword", DATABASE_PASSWORD);
            this.setTextField("jdbcDriverClassName", DATABASE_DRIVER);
            this.setTextField("jdbcUrl", DATABASE_URL);
            this.setTextField("jdbcHibernateDialect", DATABASE_DIALECT);
            this.checkCheckbox("jdbcOverwriteData");
            this.submit();
        }
        this.assertKeyNotPresent("database.title");
    }

    private void _testOptionsScreen() {
        this.log("Running _testOptionsScreen");
        this.assertKeyPresent("options.title");
        this.assertKeyPresent("options.title.label");
        this.assertKeyPresent("session.sessiontime.label");
    }

    private void _testOptionsSuccess() {
        this.log("Running _testOptionsSuccess");
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "20");
        this.setTextField("baseURL", HOST_PATH);
        this.submit();
        this.assertKeyNotPresent("options.title");
    }

    private void _testMailServerScreen() {
        this.log("Running _testMailServerScreen");
        this.assertKeyPresent("mailserver.title");
        this.assertKeyPresent("mailserver.notification.label");
        this.assertKeyPresent("mailserver.from.label");
        this.assertKeyPresent("mailserver.prefix.label");
        this.assertKeyPresent("mailserver.host.label");
        this.assertKeyPresent("mailserver.username.label");
        this.assertKeyPresent("mailserver.password.label");
    }

    private void _testMailServerSuccess() {
        this.log("Running _testMailServerSuccess");
        this.clickRadioOption("jndiMailActive", "false");
        this.setTextField("notificationEmail", "user@example.com");
        this.setTextField("host", "localhost");
        this.setTextField("from", "security@example.com");
        this.submit();
        this.assertKeyNotPresent("mailserver.notification.label");
    }

    private void _testInternalDirectoryScreen() {
        this.log("Running _testInternalDirectoryScreen");
        this.assertKeyPresent("directoryinternal.title");
        this.assertKeyPresent("directoryinternal.name.label");
        this.assertKeyPresent("directoryinternal.description.label");
        this.assertKeyPresent("directoryinternal.passwordmaxchangetime.label");
        this.assertKeyPresent("directoryinternal.passwordmaxattempts.label");
        this.assertKeyPresent("directoryinternal.passwordhistorycount.label");
        this.assertKeyPresent("directoryinternal.passwordregex.label");
        this.assertKeyPresent("directoryconnector.userencryptionmethod.label");
    }

    private void _testInternalDirectorySuccess() {
        this.log("Running _testInternalDirectorySuccess");
        this.setTextField("name", "Test Internal Directory");
        this.setTextField("description", "");
        this.setTextField("passwordRegex", "");
        this.setTextField("passwordMaxAttempts", "");
        this.setTextField("passwordMaxChangeTime", "");
        this.setTextField("passwordHistoryCount", "");
        this.selectOptionByValue("userEncryptionMethod", "atlassian-security");
        this.submit();
        this.assertKeyNotPresent("directoryinternal.title");
    }

    private void _testDefaultAdminScreen() {
        this.log("Running _testDefaultAdminScreen");
        this.assertKeyPresent("defaultadmin.title");
        this.assertKeyPresent("principal.name.label");
        this.assertKeyPresent("principal.password.label");
        this.assertKeyPresent("principal.passwordconfirm.label");
        this.assertKeyPresent("principal.firstname.label");
        this.assertKeyPresent("principal.lastname.label");
        this.assertKeyPresent("principal.email.label");
    }

    private void _testDefaultAdminSuccess() {
        this.log("Running _testDefaultAdminSuccess");
        this.setTextField("email", "admin@example.com");
        this.setTextField("name", "admin");
        this.setTextField("password", "admin");
        this.setTextField("passwordConfirm", "admin");
        this.setTextField("firstname", "Super");
        this.setTextField("lastname", "User");
        this.submit();
        this.assertKeyNotPresent("defaultadmin.title");
    }

    private void _testConfigureIntegratedApps() {
        this.log("Running _testConfigureIntegratedApps");
        this.assertKeyPresent("integration.title");
        this.setRadioButton("configureOpenIDServer", Boolean.TRUE.toString());
        this.setRadioButton("configureDemoApp", Boolean.FALSE.toString());
        this.submit();
    }

    private void _testCompleteSetup() {
        this.log("Running _testCompleteSetup");
        this.assertKeyPresent("setupcomplete.title");
        this.clickElementByXPath("//input[@id='continueButton']");
        try {
            this.assertKeyPresent("login.title");
        }
        catch (AssertionFailedError e) {
            this.logger.error((Object)"Crowd setup has completed. However for some yet-to-be-found reason, clickElementByXPath for the 'continueButton' has failed. We can ignore this, so proceed with the tests.");
        }
    }

    private void _testDatabaseSystemInfo() {
        this.log("Running _testDatabaseSystemInfo");
        this._loginAdminUser();
        this.gotoSystemInfo();
        if (this.isDatabaseSpecified()) {
            this.assertTextNotPresent(HSQLDB_URL_PREFIX + this.getCrowdHome() + HSQLDB_URL_SUFFIX);
            this.assertTextNotPresent(HSQLDB_USERNAME);
            this.assertTextNotPresent(HSQLDB_DRIVER);
            this.assertTextNotPresent(HSQLDB_DIALECT);
            this.assertTextPresent(DATABASE_URL);
            this.assertTextPresent(DATABASE_USERNAME);
            this.assertTextPresent(DATABASE_DRIVER);
            this.assertTextPresent(DATABASE_DIALECT);
        } else {
            this.assertTextPresent(HSQLDB_URL_PREFIX + this.getCrowdHome() + HSQLDB_URL_SUFFIX);
            this.assertTextPresent(HSQLDB_USERNAME);
            this.assertTextPresent(HSQLDB_DRIVER);
            this.assertTextPresent(HSQLDB_DIALECT);
        }
    }

    private boolean isDatabaseSpecified() {
        return !DATABASE_TYPE.equals(UNSPECIFIED_DATABASE_TYPE) && !StringUtils.isBlank((String)DATABASE_TYPE);
    }
}

