/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.integration.rest.service.RestCrowdClient;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Properties;

public class DirectoryAmalgamationTest
extends CrowdAcceptanceTestCase {
    private static final String APPLICATION_NAME = "crowd";
    private static final String APPLICATION_PASSWORD = "qybhDMZh";
    private CrowdClient crowdClient;

    public void setUp() throws Exception {
        super.setUp();
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        this.crowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        this.restoreCrowdFromXML("directoryamalgamation.xml");
    }

    public void testDirectGroupMembershipAmalgamation() throws Exception {
        ImmutableSet expectedGroupNames = ImmutableSet.of((Object)"dir1group1");
        HashSet groupNames = Sets.newHashSet((Iterable)this.crowdClient.getNamesOfGroupsForUser("user1", 0, -1));
        DirectoryAmalgamationTest.assertEquals((Object)expectedGroupNames, (Object)groupNames);
    }

    public void testNestedGroupMembershipAmalgamation() throws Exception {
        ImmutableSet expectedGroupNames = ImmutableSet.of((Object)"dir2childgroup", (Object)"dir2parentgroup");
        HashSet groupNames = Sets.newHashSet((Iterable)this.crowdClient.getNamesOfGroupsForNestedUser("nesteduser", 0, -1));
        DirectoryAmalgamationTest.assertEquals((Object)expectedGroupNames, (Object)groupNames);
    }

    public void testDirectUserMembersAmalgamation() throws Exception {
        ImmutableSet expectedUserNames = ImmutableSet.of((Object)"dir1user", (Object)"dir2user");
        HashSet userNames = Sets.newHashSet((Iterable)this.crowdClient.getNamesOfUsersOfGroup("commongroup", 0, -1));
        DirectoryAmalgamationTest.assertEquals((Object)expectedUserNames, (Object)userNames);
    }

    public void testNestedUserMembersAmalgamation() throws Exception {
        ImmutableSet expectedUserNames = ImmutableSet.of((Object)"dir1user", (Object)"dir2user");
        HashSet userNames = Sets.newHashSet((Iterable)this.crowdClient.getNamesOfNestedUsersOfGroup("commonparentgroup", 0, -1));
        DirectoryAmalgamationTest.assertEquals((Object)expectedUserNames, (Object)userNames);
    }

    public void testIsUserDirectGroupMember() throws Exception {
        DirectoryAmalgamationTest.assertTrue((boolean)this.crowdClient.isUserDirectGroupMember("user1", "dir1group1"));
        DirectoryAmalgamationTest.assertFalse((boolean)this.crowdClient.isUserDirectGroupMember("user1", "dir2group1"));
    }

    public void testIsUserNestedGroupMember() throws Exception {
        DirectoryAmalgamationTest.assertTrue((boolean)this.crowdClient.isUserNestedGroupMember("nesteduser", "dir2parentgroup"));
        DirectoryAmalgamationTest.assertTrue((boolean)this.crowdClient.isUserNestedGroupMember("nesteduser", "dir2childgroup"));
        DirectoryAmalgamationTest.assertFalse((boolean)this.crowdClient.isUserNestedGroupMember("nesteduser", "dir3parentgroup"));
        DirectoryAmalgamationTest.assertFalse((boolean)this.crowdClient.isUserNestedGroupMember("nesteduser", "dir3childgroup"));
    }
}

