/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;

public class AutoGroupAdderTest
extends CrowdAcceptanceTestCase {
    private static final String CROWD_DIRECTORY_NAME = "remotecrowd";
    private static final long MAX_WAIT_TIME_MS = 10000L;

    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("autogroupaddertest.xml");
    }

    public void testAutoAddWithInternalDirectory() {
        this.log("Running testAutoAddWithInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Crowd Local");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "group1");
        this.assertTextInTable("groupsTable", "group2");
        this.assertTextInTable("groupsTable", "group3");
    }

    public void testAutoAddWithDelegatedDirectory() {
        this.log("Running testAutoAddWithDelegatedDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("delg");
        this.clickLink("delegated-options");
        this.assertTextPresent("test1");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "delg");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "test1");
    }

    public void testAutoAddWithLDAPDirectory() {
        this.log("Running testAutoAddWithLDAPDirectory");
        DbCachingTestHelper.synchroniseDirectory(this.tester, "ldap", 10000L);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("ldap");
        this.clickLink("connector-options");
        this.assertTextPresent("groupA");
        this.assertTextPresent("groupB");
        this.assertTextPresent("groupC");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "ldap");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "groupA");
        this.assertTextInTable("groupsTable", "groupB");
        this.assertTextInTable("groupsTable", "groupC");
        this.clickLink("remove-principal");
        this.submit();
        this.assertTextNotPresent("testuser");
    }

    public void testAutoAddWithRemoteCrowdDirectory() {
        this.log("Running testAutoAddWithRemoteCrowdDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CROWD_DIRECTORY_NAME));
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "demo");
        this.setTextField("applicationPassword", "password");
        this.submit();
        DbCachingTestHelper.synchroniseDirectory(this.tester, CROWD_DIRECTORY_NAME, 10000L);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", CROWD_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "group1");
        this.assertTextInTable("groupsTable", "group2");
        this.assertTextInTable("groupsTable", "group3");
        this.clickLink("remove-principal");
        this.submit();
        this.assertTextNotPresent("testuser");
    }
}

