/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import java.util.Properties;

public class AddGroupLDAPTest
extends CrowdAcceptanceTestCase {
    private static final String DIRECTORY_NAME = "ApacheDS102";
    private static final String GROUP_NAME = "myGroup";
    private static final String SUB_GROUP_NAME = "mySubGroup";
    LDAPLoader loader = new LDAPLoader();

    public void setUp() throws Exception {
        super.setUp();
        this.loader.accessibleSetUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.loader.accessibleTearDown();
    }

    public void testAddGroupToLDAPDirectory() {
        this.log("Running testAddGroupToLDAPDirectory");
        this.gotoAddGroup();
        this.setTextField("name", GROUP_NAME);
        this.setTextField("description", "Crowd LDAP Test Group");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent(GROUP_NAME);
    }

    class LDAPLoader
    extends BaseTest {
        LDAPLoader() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS102ConfigFileName());
        }

        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.basedn", directorySettings.getProperty("test.integration.basedn"));
        }

        protected void loadTestData() throws Exception {
            GroupTemplate subGroup = new GroupTemplate(AddGroupLDAPTest.SUB_GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
            this.getRemoteDirectory().addGroup(subGroup);
        }

        protected void removeTestData() {
            this.removeGroup(AddGroupLDAPTest.GROUP_NAME);
            this.removeGroup(AddGroupLDAPTest.SUB_GROUP_NAME);
        }

        public void accessibleSetUp() throws Exception {
            super.setUp();
        }

        public void accessibleTearDown() throws Exception {
            super.tearDown();
        }
    }
}

