/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.confluence;

import com.atlassian.crowd.acceptance.tests.applications.confluence.ConfluenceAcceptanceTestCase;

public class ConfluenceMixedCaseGroupTest
extends ConfluenceAcceptanceTestCase {
    private static final String CONFLUENCE_MIXEDCASE_GROUP = "connie-MixedCase-group";
    private static final String CONFLUENCE_DUPLICATE_GROUP = "connie-mixedcase-group";

    protected void setUp() throws Exception {
        super.setUp();
        this.loginToConfluence("admin", "admin");
    }

    public void testConfluenceGroupCrud() {
        this._testCheckUserMemberOfMixedCaseGroup();
        this._testUserLoginNoPermissions();
        this._testAddMixedCaseGroupPermissions();
        this._testUserLoginSomePermissions();
        this._testAddDuplicateLowerCaseGroupName();
    }

    private void _testCheckUserMemberOfMixedCaseGroup() {
        this.gotoBrowseUsers();
        this.setWorkingForm("createuserform");
        this.setTextField("username", "mutant-connie");
        this.setTextField("fullname", "Mutant Connie");
        this.setTextField("password", "password");
        this.setTextField("confirm", "password");
        this.setTextField("email", "mutant-connie@example.com");
        this.submit();
        this.assertTextPresent("User: mutant-connie");
        this.clickLinkWithText("Edit Groups");
        this.setWorkingForm("editusergroupsform");
        this.assertCheckboxSelected("newGroups", "confluence-users");
        this.assertCheckboxNotSelected("newGroups", "confluence-administrators");
        this.assertCheckboxNotSelected("newGroups", "crowd-administrators");
        this.assertCheckboxNotSelected("newGroups", CONFLUENCE_MIXEDCASE_GROUP);
        this.checkCheckbox("newGroups", CONFLUENCE_MIXEDCASE_GROUP);
        this.uncheckCheckbox("newGroups", "confluence-users");
        this.submit("save");
        this.verifyUserExistsInCrowd("mutant-connie", "Mutant", "Connie", "mutant-connie@example.com", CONFLUENCE_MIXEDCASE_GROUP);
    }

    private void _testUserLoginNoPermissions() {
        this.logoutFromConfluence();
        this.loginToConfluence("mutant-connie", "password");
        this.assertTextPresent("Mutant Connie");
        this.assertTextPresent("Not Permitted");
        this.assertTextPresent("You are not permitted to perform this operation.");
    }

    private void _testAddMixedCaseGroupPermissions() {
        this.adminLoginToConfluence();
        this.gotoGlobalPermissions();
        this.setWorkingForm("editglobalperms", 0);
        this.submit();
        this.setWorkingForm("editglobalperms");
        this.setTextField("groupsToAdd", CONFLUENCE_MIXEDCASE_GROUP);
        this.submit("groupsToAddButton");
        this.assertTextInTable("gPermissionsTable", CONFLUENCE_MIXEDCASE_GROUP);
    }

    private void _testUserLoginSomePermissions() {
        this.logoutFromConfluence();
        this.loginToConfluence("mutant-connie", "password");
        this.gotoPage("dashboard.action");
        this.assertTextPresent("Mutant Connie");
        this.assertTextPresent("Favourite Pages");
        this.assertTextPresent("Recently Updated");
    }

    private void _testAddDuplicateLowerCaseGroupName() {
        this.adminLoginToConfluence();
        this.gotoBrowseGroups();
        this.clickLink("switch-button");
        this.setWorkingForm("creategroupform");
        this.setTextField("name", CONFLUENCE_DUPLICATE_GROUP);
        this.submit();
    }
}

