/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.confluence;

import com.atlassian.crowd.acceptance.tests.ApplicationAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.VersionUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;

public class ConfluenceAcceptanceTestCase
extends ApplicationAcceptanceTestCase {
    protected static final String CONFLUENCE_ADMIN_USERNAME = "confluence-admin";
    protected static final String CONFLUENCE_ADMIN_PASSWORD = "admin";
    protected static final String CONFLUENCE_ADMIN_FIRSTNAME = "Confluence";
    protected static final String CONFLUENCE_ADMIN_LASTNAME = "Administrator";
    protected static final String CONFLUENCE_ADMIN_FULL_NAME = "Confluence Administrator";
    protected static final String CONFLUENCE_ADMIN_EMAIL = "connieadmin@example.com";
    protected static final String CONFLUENCE_USER_USERNAME = "mutant-connie";
    protected static final String CONFLUENCE_USER_PASSWORD = "password";
    protected static final String CONFLUENCE_USER_FIRSTNAME = "Mutant";
    protected static final String CONFLUENCE_USER_LASTNAME = "Connie";
    protected static final String CONFLUENCE_USER_FULLNAME = "Mutant Connie";
    protected static final String CONFLUENCE_USER_EMAIL = "mutant-connie@example.com";
    protected static final String CONFLUENCE_USER_FIRSTNAME_UPDATED = "Mutated";
    protected static final String CONFLUENCE_USER_LASTNAME_UPDATED = "Bonnie";
    protected static final String CONFLUENCE_USER_FULLNAME_UPDATED = "Mutated Bonnie";
    protected static final String CONFLUENCE_USER_EMAIL_UPDATED = "mutated.connie.mutant@example.com";
    protected static final String CONFLUENCE_ADMINISTRATORS_GROUP = "confluence-administrators";
    protected static final String CONFLUENCE_USERS_GROUP = "confluence-users";
    protected static final String CONFLUENCE_GROUP_NAME = "connie-secret-users";
    protected static final String UNLIMITED_LICENSE_KEY = "AAABKQ0ODAoPeNptkF1LwzAUhu/zKwJedzSTigwCbmkvqu02bAUVb47ZqUbSZCTpdP/e7KOg4vV53\n/d5OBe1NfQWDGWMTi9n2dUszahoWjpNWUpy9NKpbVDWcGFNpwc0El9mVNi+RycVaNqg26EjwiEcc\njkE5IdykrKEMRJrAWRYQo/8Y/BBmRsIGrxXYCbS9kTG3UlMqB3y4AYcG0UNSv9fKXaghyONd6A9n\njYqJdF4bPdbPNLEqq6Le1HOKxKnTEADUb742iq3P1tmo+VxYDn0r+hWndARim5pN+h5SlbuDYzyJ\n958FKGN7cInOKTNPqZ7T06PKHO+WLDrZF0+tsnTXdlGwnNFznLxWpX5b9yDR+d5wsbMD8PBaNWrg\nBuyHpx8B49/3/sNy3SZHDAsAhQlpKvZ3mUX4sy/D7R6HBpzP5aIZAIUAuzbc7J+FY/5QWYgnPGJx\nmL1FFM=X02eu";

    protected String getResourceBundleName() {
        return null;
    }

    protected String getApplicationName() {
        return "confluence";
    }

    protected String getLocalTestPropertiesFileName() {
        return "localtest.properties";
    }

    protected void gotoBrowseUsers() {
        this.gotoPage("/admin/users/browseusers.action");
        this.accessAdminFeature();
    }

    protected void gotoBrowseGroups() {
        this.gotoPage("/admin/users/browsegroups.action");
        this.accessAdminFeature();
    }

    protected void gotoGlobalPermissions() {
        this.gotoPage("/admin/permissions/globalpermissions.action");
        this.accessAdminFeature();
    }

    protected String loginToConfluence(String username, String password) {
        this.logoutFromConfluence();
        this.gotoPage("/login.action");
        this.assertTextPresent("Log In");
        this.setWorkingForm("loginform");
        this.setTextField("os_username", username);
        this.setTextField("os_password", password);
        this.submit();
        return this.getCurrentlyLoggedInConfluenceUserFullName();
    }

    protected void logoutFromConfluence() {
        this.gotoPage("logout.action");
        this.assertTextPresent("You have been successfully logged out.");
    }

    protected void adminLoginToConfluence() {
        this.loginToConfluence(CONFLUENCE_ADMIN_USERNAME, CONFLUENCE_ADMIN_PASSWORD);
        this.assertTextPresent(CONFLUENCE_ADMIN_FULL_NAME);
    }

    protected String getCurrentlyLoggedInConfluenceUserFullName() {
        this.gotoPage("/users/viewmyprofile.action");
        try {
            return this.getElementTextByXPath("//*[@id=\"fullName\"]");
        }
        catch (AssertionFailedError e) {
            return null;
        }
    }

    protected void accessAdminFeature() {
        if (!this.isTextPresent("Administrator Access")) {
            return;
        }
        this.setWorkingForm("authenticateform");
        this.setTextField(CONFLUENCE_USER_PASSWORD, CONFLUENCE_ADMIN_PASSWORD);
        this.submit("authenticate");
    }

    public void restoreCrowdFromXMLNoSync(String xmlFilename) {
        super.restoreCrowdFromXML(xmlFilename);
    }

    boolean isAtLeastVersion(String v) {
        return VersionUtils.compareVersions(this.getConfluenceVersion(), "3.5") >= 0;
    }

    public void restoreCrowdFromXML(String xmlFilename) {
        super.restoreCrowdFromXML(xmlFilename);
        this.adminLoginToConfluence();
        if (this.isAtLeastVersion("3.5")) {
            this.synchroniseConfluenceWithCrowd();
        }
    }

    protected String getConfluenceVersion() {
        Pattern pattern = Pattern.compile("Powered by Atlassian Confluence ([^,]+),");
        String poweredByText = this.getElementTextById("poweredby");
        Matcher matcher = pattern.matcher(poweredByText);
        ConfluenceAcceptanceTestCase.assertTrue((String)("Could not find version number from the following text: " + poweredByText), (boolean)matcher.find());
        return matcher.group(1);
    }

    protected void synchroniseConfluenceWithCrowd() {
        this.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        this.accessAdminFeature();
        if (!this.isTextPresent("Synchronising")) {
            this.clickLinkWithText("Synchronise");
        }
        long startTime = System.currentTimeMillis();
        while (!this.isTextPresent("Synchronise") && System.currentTimeMillis() < startTime + 60000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        }
        this.assertTextPresent("Last synchronised at");
    }

    protected void clickUsernameLink(String username) {
        if (this.isAtLeastVersion("3.5")) {
            this.clickElementByXPath("//a[@data-username='" + username + "']");
        } else {
            this.clickLinkWithExactText(username);
        }
    }
}

