/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.applications.bamboo.BambooAcceptanceTestCase;

public class BambooSingleSignOnTest
extends BambooAcceptanceTestCase {
    protected static final String CROWD_ONLY_USER_USERNAME = "crowd-only";
    protected static final String BAMBOO_ONLY_USER_USERNAME = "bamboo-only";
    protected static final String DUAL_ACCESS_USER_USERNAME = "crowd-bamboo";
    protected static final String PASSWORD = "password";

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("crowdbamboosso.xml");
        this.logoutFromCrowd();
        this.logoutFromBamboo();
        this.setScriptingEnabled(false);
    }

    public void testLoginToCrowdConsequentlyLoggedInToBamboo() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToBamboo");
        this.logoutFromCrowd();
        this.logoutFromBamboo();
        String crowdUser = this.loginToCrowd("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertEquals((String)crowdUser, (String)bambooUser);
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        BambooSingleSignOnTest.assertEquals((String)crowdUser, (String)bambooUser);
    }

    public void testLoginToBambooConsequentlyLoggedInToCrowd() {
        this.log("Running testLoginToBambooConsequentlyLoggedInToCrowd");
        this.logoutFromCrowd();
        this.logoutFromBamboo();
        String bambooUser = this.loginToBamboo("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        BambooSingleSignOnTest.assertEquals((String)bambooUser, (String)crowdUser);
        bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertEquals((String)bambooUser, (String)crowdUser);
    }

    public void testLogoutOfCrowdConsequentlyLoggedOutOfBamboo() {
        this.log("Running testLogoutOfCrowdConsequentlyLoggedOutOfBamboo");
        String crowdUser = this.loginToCrowd("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        this.logoutFromCrowd();
        bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNull((Object)bambooUser);
    }

    public void testLogoutOfBambooConsequentlyLoggedOutOfCrowd() {
        this.log("Running testLogoutOfBambooConsequentlyLoggedOutOfCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        this.logoutFromBamboo();
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        BambooSingleSignOnTest.assertNull((Object)crowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInBamboo() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInBamboo");
        String crowdUser = this.loginToCrowd("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd(DUAL_ACCESS_USER_USERNAME, PASSWORD);
        BambooSingleSignOnTest.assertNotSame((Object)newCrowdUser, (Object)crowdUser);
        String newBambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertEquals((String)newCrowdUser, (String)newBambooUser);
    }

    public void testSwitchUserInBambooConsequentlySwitchesUserInCrowd() {
        this.log("Running testSwitchUserInBambooConsequentlySwitchesUserInCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        this.logoutFromBamboo();
        String newBambooUser = this.loginToBamboo(DUAL_ACCESS_USER_USERNAME, PASSWORD);
        BambooSingleSignOnTest.assertNotSame((Object)newBambooUser, (Object)bambooUser);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        BambooSingleSignOnTest.assertEquals((String)newCrowdUser, (String)newBambooUser);
    }

    public void testLoginToBambooConsequentlyLoggedInToCrowd_unauthorisedFailure() {
        this.log("Running testLoginToBambooConsequentlyLoggedInToCrowd_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromBamboo();
        String bambooUser = this.loginToBamboo(BAMBOO_ONLY_USER_USERNAME, PASSWORD);
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        BambooSingleSignOnTest.assertNull((Object)crowdUser);
        String currentBambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertEquals((String)bambooUser, (String)currentBambooUser);
    }

    public void testLoginToCrowdConsequentlyLoggedInToBamboo_unauthorisedFailure() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToBamboo_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromBamboo();
        String crowdUser = this.loginToCrowd(CROWD_ONLY_USER_USERNAME, PASSWORD);
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNull((Object)bambooUser);
        String currentCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        BambooSingleSignOnTest.assertEquals((String)crowdUser, (String)currentCrowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInBamboo_unauthorisedFailure() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInBamboo_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd(CROWD_ONLY_USER_USERNAME, PASSWORD);
        BambooSingleSignOnTest.assertNotSame((Object)newCrowdUser, (Object)crowdUser);
        String newBambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNull((Object)newBambooUser);
    }

    public void testSwitchUserInBambooConsequentlySwitchesUserInCrowd_unauthorisedFailure() {
        this.log("Running testSwitchUserInBambooConsequentlySwitchesUserInCrowd_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        BambooSingleSignOnTest.assertNotNull((Object)crowdUser);
        String bambooUser = this.getCurrentlyLoggedInBambooUserFullName();
        BambooSingleSignOnTest.assertNotNull((Object)bambooUser);
        this.logoutFromBamboo();
        String newBambooUser = this.loginToBamboo(BAMBOO_ONLY_USER_USERNAME, PASSWORD);
        BambooSingleSignOnTest.assertNotSame((Object)newBambooUser, (Object)bambooUser);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        BambooSingleSignOnTest.assertNull((Object)newCrowdUser);
    }
}

