/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.applications.bamboo.BambooAcceptanceTestCase;

public class BambooMixedCaseUserTest
extends BambooAcceptanceTestCase {
    private static final String BAMBOO_MUTANT_FIRSTNAME = "MixedCase";
    private static final String BAMBOO_MUTANT_LASTNAME = "User";
    private static final String BAMBOO_MUTANT_FULLNAME = "MixedCase User";
    private static final String BAMBOO_MUTANT_EMAIL = "mixedCase@updated.com";

    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToBamboo();
    }

    public void testBambooUserCrud() {
        this._testUserLoginNoPermission();
        this._testUpdateBambooUser();
        this._testUserLoginWithPermission();
        this._testModifyBambooUserGroupMembership();
        this._testDeleteBambooUser();
    }

    private void _testUserLoginNoPermission() {
        this.loginToBamboo("MixedCaseUser", "password");
        this.assertTextPresent("You have entered an invalid username and password. Please try again.");
    }

    private void _testUpdateBambooUser() {
        this.adminLoginToBamboo();
        this.gotoBrowseUsers();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
        this.clickLink("editUser-MixedCaseUser");
        this.setWorkingForm("updateUser");
        this.setTextField("fullName", BAMBOO_MUTANT_FULLNAME);
        this.setTextField("email", BAMBOO_MUTANT_EMAIL);
        this.selectOptionsByValues("groups", new String[]{"bamboo-users"});
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", BAMBOO_MUTANT_EMAIL, BAMBOO_MUTANT_FULLNAME, "bamboo-users \n", "", "Edit | Delete"});
        this.verifyUserExistsInCrowd("MixedCaseUser", BAMBOO_MUTANT_FIRSTNAME, BAMBOO_MUTANT_LASTNAME, BAMBOO_MUTANT_EMAIL, "bamboo-users");
    }

    private void _testUserLoginWithPermission() {
        this.loginToBamboo("MixedCaseUser", "password");
        this.assertTextPresent(BAMBOO_MUTANT_FULLNAME);
        this.assertTextPresent("Log out");
    }

    private void _testModifyBambooUserGroupMembership() {
        this.adminLoginToBamboo();
        this.gotoBrowseUsers();
        this.clickLink("editUser-MixedCaseUser");
        this.setWorkingForm("updateUser");
        this.selectOptionByValue("groups", "bamboo-admin");
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", BAMBOO_MUTANT_EMAIL, BAMBOO_MUTANT_FULLNAME, "bamboo-admin \n", "", "Edit | Delete"});
        this.verifyUserExistsInCrowd("MixedCaseUser", BAMBOO_MUTANT_FIRSTNAME, BAMBOO_MUTANT_LASTNAME, BAMBOO_MUTANT_EMAIL, "bamboo-admin");
    }

    private void _testDeleteBambooUser() {
        this.gotoBrowseUsers();
        this.clickLink("deleteUser-MixedCaseUser");
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
        this.verifyUserDoesNotExistInCrowd("MixedCaseUser", BAMBOO_MUTANT_FIRSTNAME, BAMBOO_MUTANT_LASTNAME, BAMBOO_MUTANT_EMAIL, "bamboo-admin");
    }
}

