/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.CrowdWebTestCase;
import java.util.Properties;
import junit.framework.AssertionFailedError;

public abstract class ApplicationAcceptanceTestCase
extends CrowdWebTestCase {
    protected static final String CROWD_ADMIN_USER = "admin";
    protected static final String CROWD_ADMIN_EMAIL_ADDRESS = "admin@example.com";
    protected static final String CROWD_ADMIN_FULLNAME = "Super User";
    protected static final String ADMIN_PW = "admin";
    protected String port;
    protected String context;
    protected String path;
    protected String baseUrl;
    protected Properties specProperties;
    protected String rootUrl;
    protected CrowdAcceptanceTestCase crowdConsole;
    protected String crowdContext;
    protected String crowdPort;
    protected String crowdBaseUrl;
    protected String crowdResourceBundle;
    protected static final String CROWD_ADMINISTRATORS_GROUP = "crowd-administrators";

    protected void setUp() throws Exception {
        super.setUp();
        this.specProperties = AcceptanceTestHelper.loadProperties(this.getLocalTestPropertiesFileName());
        this.port = this.getTestProperty(this.getApplicationName() + ".port");
        this.context = this.getTestProperty(this.getApplicationName() + ".context");
        this.path = this.getTestProperty(this.getApplicationName() + ".path");
        this.rootUrl = "http://" + this.getTestProperty("host.location") + ":" + this.port;
        this.baseUrl = this.rootUrl + this.context;
        this.getTestContext().setBaseUrl(this.baseUrl);
        this.setScriptingEnabled(false);
        this.beginAt(this.baseUrl);
        this.crowdContext = this.getTestProperty("crowd.context");
        this.crowdPort = this.getTestProperty("crowd.port");
        this.crowdBaseUrl = "http://" + this.getTestProperty("host.location") + ":" + this.crowdPort + this.crowdContext;
        this.crowdConsole = new CrowdAcceptanceTestCase();
        this.crowdConsole.setTester(this.getTester());
        this.crowdConsole.setUp();
        this.crowdResourceBundle = "com.atlassian.crowd.console.action.BaseAction";
        this.useApp();
        this.log("Running: " + ((Object)((Object)this)).getClass().getSimpleName() + " - " + this.getName());
    }

    protected String getTestProperty(String propName) {
        if (System.getProperty("acceptance.test." + propName) != null) {
            return System.getProperty("acceptance.test." + propName);
        }
        if (this.specProperties.getProperty(propName) != null) {
            return this.specProperties.getProperty(propName);
        }
        return "";
    }

    protected void useCrowd() {
        this.getTestContext().setBaseUrl(this.crowdBaseUrl);
        this.getTestContext().setResourceBundleName(this.crowdResourceBundle);
    }

    protected void useApp() {
        this.getTestContext().setBaseUrl(this.baseUrl);
        this.getTestContext().setResourceBundleName(this.getResourceBundleName());
    }

    public void restoreBaseSetup() {
        this.restoreCrowdFromXML("basesetup.xml");
    }

    public void restoreCrowdFromXML(String xmlFilename) {
        this.useCrowd();
        this.crowdConsole.restoreCrowdFromXML(xmlFilename);
        this.useApp();
    }

    protected void logoutFromCrowd() {
        this.useCrowd();
        this.crowdConsole._logout();
        this.useApp();
    }

    protected void loginToCrowd() {
        this.useCrowd();
        this.crowdConsole._logout();
        this.crowdConsole.assertKeyPresent("login.title");
        this.crowdConsole.setTextField("j_username", "admin");
        this.crowdConsole.setTextField("j_password", "admin");
        this.crowdConsole.submit();
        this.crowdConsole.assertLinkPresentWithKey("menu.logout.label");
        this.useApp();
    }

    public String getCrowdHome() {
        String crowdHome = System.getProperty("crowd.home");
        if (crowdHome == null) {
            return System.getProperty("java.io.tmp");
        }
        return crowdHome;
    }

    protected abstract String getResourceBundleName();

    protected abstract String getApplicationName();

    protected abstract String getLocalTestPropertiesFileName();

    protected void verifyUserExistsInCrowd(String username, String firstname, String lastname, String email, String ... groupNames) {
        this.loginToCrowd();
        this.useCrowd();
        String fullname = firstname + " " + lastname;
        this.crowdConsole.gotoBrowsePrincipals();
        this.crowdConsole.assertTextPresent(fullname);
        this.crowdConsole.assertTextPresent(email);
        this.crowdConsole.assertTextPresent(username);
        this.crowdConsole.clickLinkWithText(fullname);
        this.crowdConsole.assertTextPresent(username);
        this.crowdConsole.assertTextInElement("email", email);
        this.crowdConsole.assertTextInElement("firstname", firstname);
        this.crowdConsole.assertTextInElement("lastname", lastname);
        this.crowdConsole.assertCheckboxSelected("active");
        this.crowdConsole.clickLink("user-groups-tab");
        for (String groupName : groupNames) {
            this.crowdConsole.assertTextInTable("groupsTable", groupName);
        }
        this.crowdConsole.assertTableRowCountEquals("rolesTable", 1);
        this.useApp();
    }

    protected void verifyUserDoesNotExistInCrowd(String username, String firstname, String lastname, String email, String ... groupNames) {
        this.loginToCrowd();
        this.useCrowd();
        String fullname = firstname + " " + lastname;
        this.crowdConsole.gotoBrowsePrincipals();
        this.crowdConsole.assertTextNotPresent(fullname);
        this.crowdConsole.assertTextNotPresent(email);
        this.crowdConsole.assertTextNotPresent(username);
        this.useApp();
    }

    protected void verifyGroupExistsInCrowd(String groupName, String ... memberNames) {
        this.loginToCrowd();
        this.useCrowd();
        this.crowdConsole.gotoBrowseGroups();
        this.crowdConsole.assertTextInTable("group-details", new String[]{groupName, "true"});
        this.crowdConsole.clickLinkWithText(groupName);
        this.crowdConsole.setWorkingForm("groupForm");
        this.crowdConsole.assertTextPresent(groupName);
        this.crowdConsole.assertTextFieldEquals("description", "");
        this.crowdConsole.assertCheckboxSelected("active");
        this.crowdConsole.clickLink("view-group-users");
        if (memberNames.length == 0) {
            this.crowdConsole.assertTextPresent("There are no user members");
        } else {
            for (String memberName : memberNames) {
                this.crowdConsole.assertTextInTable("view-group-users", new String[]{memberName});
            }
        }
        this.useApp();
    }

    protected void verifyGroupDoesNotExistInCrowd(String groupName) {
        this.loginToCrowd();
        this.useCrowd();
        this.crowdConsole.gotoBrowseGroups();
        this.crowdConsole.assertTextNotInTable("group-details", new String[]{groupName});
        this.useApp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCurrentlyLoggedInCrowdUserFullName() {
        this.useCrowd();
        this.crowdConsole.gotoPage("/console");
        try {
            String string = this.crowdConsole.getElementTextByXPath("//span[@id='userFullName']");
            return string;
        }
        catch (AssertionFailedError e) {
            String string = null;
            return string;
        }
        finally {
            this.useApp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loginToCrowd(String username, String password) {
        this.useCrowd();
        this.crowdConsole._logout();
        this.crowdConsole.assertKeyPresent("login.title");
        this.crowdConsole.setTextField("j_username", username);
        this.crowdConsole.setTextField("j_password", password);
        this.crowdConsole.submit();
        try {
            this.crowdConsole.assertLinkPresentWithKey("menu.logout.label");
            String string = this.crowdConsole.getElementTextByXPath("//span[@id='userFullName']");
            return string;
        }
        catch (AssertionFailedError e) {
            String string = null;
            return string;
        }
        finally {
            this.useApp();
        }
    }
}

