/*
 * Copyright © 2010 - 2012 Atlassian Corporation Pty Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.atlassian.crowd.exception;

/**
 * Thrown when an invalid token is provided.
 *
 * @author Justen Stepka <jstepka@atlassian.com>
 * @version 1.0
 */
public class InvalidTokenException extends Exception
{
    /**
     * Default constructor.
     */
    public InvalidTokenException()
    {
        super();
    }

    /**
     * {@inheritDoc}
     */
    public InvalidTokenException(String s)
    {
        super(s);
    }

    /**
     * Default constructor.
     *
     * @param s         The message.
     * @param throwable the {@link Exception Exception}.
     */
    public InvalidTokenException(String s, Throwable throwable)
    {
        super(s, throwable);
    }

    /**
     * Default constructor.
     *
     * @param throwable the {@link Exception Exception}.
     */
    public InvalidTokenException(Throwable throwable)
    {
        super(throwable);
    }
}
