/*
 * Copyright © 2010 - 2012 Atlassian Corporation Pty Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.atlassian.crowd.exception;

/**
 * Thrown when the email address is not valid.
 */
public class InvalidEmailAddressException extends Exception
{
    /**
     * Default constructor.
     */
    public InvalidEmailAddressException()
    {
    }

    /**
     * @param s the message.
     */
    public InvalidEmailAddressException(String s)
    {
        super(s);
    }

    /**
     * @param s         the message.
     * @param throwable the {@link Exception Exception}.
     */
    public InvalidEmailAddressException(String s, Throwable throwable)
    {
        super(s, throwable);
    }

    /**
     *
     * @param throwable the {@link Exception Exception}.
     */
    public InvalidEmailAddressException(Throwable throwable)
    {
        super(throwable);
    }
}