define('confluence/share-page/service/analytics-service', [
    'confluence/analytics-support',
    'confluence/meta',
    'confluence/share-page/util/resolve-entity-id'
], function (Analytics,
             Meta,
             resolveEntityId) {
    return {
        /**
         * Triggers an analytics event.
         * @param {string} name         The name of the event
         *                                  Needs to be whitelisted in analytics_whitelist.json
         * @param {number} entityId     Id of the entity being shared
         * @param {string} shareType    Type The type of share... whether view, edit, attachment, or custom
         * @param {object} data         Additional data.
         * @returns {undefined}
         */
        publish: function analyticsEvent(name, entityId, shareType, data) {
            try {
                var resolvedEntityId = parseInt(resolveEntityId(entityId));
                var contentType = shareType === 'attachment' ? 'attachment' : Meta.get('content-type');
                var params = data || {};

                if (shareType === 'attachment') {
                    params.attachmentId = resolvedEntityId;
                } else if (shareType === 'edit') {
                    params.draftId = resolvedEntityId;
                } else {
                    params.contentId = resolvedEntityId;
                }

                params.contentType = contentType;

                Analytics.publish(name.replace('<shareType>', shareType), params);
            } catch (e) {
                // ¯\_(ツ)_/¯
            }
        },
        /* Triggered when the share button is clicked or selected by keyboard. This also refers to the invite to edit
         * button when the shareType is '*-draft.' */
        SHARE_STARTED: 'confluence.share-page.<shareType>.started',
        /* Triggered when the link input field is clicked or selected by keyboard. Note this automatically selects
         * all the contents of the field. */
        SHARE_LINK_CLICKED: 'confluence.share-page.<shareType>.link.clicked',
        /* Triggered when the link input field is double-clicked. Note this automatically copies the link. */
        SHARE_LINK_DOUBLE_CLICKED: 'confluence.share-page.<shareType>.link.double-clicked',
        /* Triggered when the Copy button is clicked or triggered by keyboard. */
        SHARE_LINK_COPY_CLICKED: 'confluence.share-page.<shareType>.link.copy.clicked',
        /* Triggered when the link has been copied. This could be due to the Copy button being pressed,
         * the link being double-clicked, or the link copied via keyboard shortcut or right-click menu. */
        SHARE_LINK_COPIED: 'confluence.share-page.<shareType>.link.copied',
        /* Triggered when the Cancel button is clicked or selected by keyboard. */
        SHARE_CANCEL_CLICKED: 'confluence.share-page.<shareType>.cancel.clicked',
        /* Triggered when the Submit button is clicked or selected by keyboard but no users are selected. */
        SHARE_NO_USERS_SELECTED: 'confluence.share-page.<shareType>.submit.no-users',
        /* Triggered when the process results in an error. */
        SHARE_ERROR: 'confluence.share-page.<shareType>.error'
    };
});