define('confluence/share-page/util/resolve-entity-id', [
    'confluence/meta'
], function (Meta) {
    /**
     * Resolves the entity id from the given value. If the value is a function,
     * it executes the function, otherwise it returns the given id if it's a string or number,
     * or the current page content id.
     * @param entityId
     * @returns {*}
     * @private
     */
    return function resolveEntityId(entityId) {
        if (typeof entityId === 'function') {
            return entityId();
        }
        if (typeof entityId === 'string' || typeof entityId === 'number') {
            return parseInt(entityId);
        }

        return Meta.get('content-id');
    }
});