define('confluence/share-page/service/share-dialog-loader', [
    'wrm',
    'confluence/api/logger'
], function (
    WRM,
    logger) {
    return {
        /**
         *
         * @param {string} triggerButtonId the ID of the trigger button
         * @param {string} mode 'view' (default) or 'edit' mode
         */
        init: function(triggerButtonId, mode) {
            WRM
            .require(['wrc!share-dialog-react']) // load the React web resource defined in base.config.js
            .done(function () {
                require(['share-dialog-react'], function (ShareDialogReact) {
                    ShareDialogReact.init(triggerButtonId, mode);
                });
            })
            .fail(function () {
                logger.error('fail to load share-dialog-app');
            });
        }
    };
});