define('confluence/share-page/autocomplete/setup-autocomplete', [
    'ajs',
    'jquery',
    'confluence/legacy'
], function (AJS,
             $,
             Confluence) {
    /**
     * Sets up the controls for the user autocomplete
     * @param $contents     jQuery dialog contents
     * @param trigger       The DOM element trigger that controls this dialog
     * @param parameters    Parameters passed-through from the dialog controller.
     */
    return function setupAutocomplete($contents, trigger, parameters) {
        var $input = $contents.find("#share-invite-users-input");
        var $shareButton = $contents.find("input.submit");

        $input.bind("selected.autocomplete-sharepage", function (e, data) {
            var addItem = function (type, template, data) {
                var $recipients = $contents.find(".recipients");
                var recipientSelector;
                var $item;

                $recipients.show();
                $contents.find('.autocomplete-user-target').nextAll('.recipientSelectionError').remove();
                $input.removeClass('field-error');

                recipientSelector = "li[data-" + type + "=\"" + data.content[type] + "\"]";
                if ($recipients.find(recipientSelector).length > 0) {
                    $recipients.find(recipientSelector).hide();
                } else {
                    $recipients.append(template(data.content));
                }
                $item = $recipients.find(recipientSelector);
                $item.find(".remove-recipient").click(function () {
                    $item.remove();
                    if ($recipients.find("li").length == 0) {
                        $shareButton.addClass("disabled");
                        $recipients.hide();
                    }
                    $(trigger).data('dialog').refresh();
                    $input.focus();
                    return false;
                });
                $item.fadeIn(200);
            };

            if (data.content.email) {
                addItem("email", Confluence.Templates.Share.Dialog.recipientEmail, data);
            } else if (data.content.type == "group") {
                addItem("group", Confluence.Templates.Share.Dialog.recipientGroup, data);
            } else {
                addItem("userKey", Confluence.Templates.Share.Dialog.recipientUser, data);
            }

            $(trigger).data('dialog').refresh();
            $shareButton.removeClass("disabled");
            $input.val("");
            $input.focus();

            return false;
        });

        $input.bind("open.autocomplete-sharepage", function (e, data) {
            if ($("a:not(.no-results)", AJS.dropDown.current.links).length > 0)
                AJS.dropDown.current.moveDown();
        });

        $input.keypress(function (e) {
            return e.keyCode != 13;
        });
    }
});