AJS.test.require("com.atlassian.confluence.plugins.recently-viewed-plugin:app-resources");

module("RecentPageStorage", {
    setup: function() {

        this.addCurrentPage = function() {
            this.pageStorage.addCurrentPage({id: "123", title: "page 1", space: "my space"});
        };

        // simple mock local storage
        var storage = {
            items: {},
            getItem: function(key) {
                return this.items[key] || null;
            },
            setItem: function(key, value) {
                this.items[key] = value;
            }
        };

        this.pageStorage = new RY.RecentPageStorage(storage);
    }
});

test("add pages", function() {
    equal(this.pageStorage.getPages().length, 0, "Should be empty");

    this.addCurrentPage();
    equal(this.pageStorage.getPages().length, 1, "Should have one page");

    // add it again
    this.addCurrentPage();
    equal(this.pageStorage.getPages().length, 1, "Should still have one page");
});

test("add page without title or id", function() {
    this.pageStorage.addCurrentPage({});
    equal(this.pageStorage.getPages().length, 0, "Should not have been added");
});


module("FilterView", {
    setup: function() {
        this.collection = new RY.PageCollection();
        var mockNavigationEvents = {
          trigger: function() {}
        };

        var $input = AJS.$("<div class='filter'><input class='filter-input' type='text'></div>");
        this.filterView = new RY.FilterView({el: $input, collection: this.collection, navigationEvents: mockNavigationEvents});
    }
});

asyncTest("search on input event", function () {
    this.filterView.render();
    var spy = sinon.spy(this.collection, "search");
    this.filterView.$input.trigger($.Event("input"));

    setTimeout(function() {
        ok(spy.calledOnce, "collection should have been searched");
        start();
    }, 100);
});

asyncTest("search on keyup event", function () {
    this.filterView.render();
    var spy = sinon.spy(this.collection, "search");
    this.filterView.$input.trigger($.Event("keyup"));

    setTimeout(function() {
        ok(spy.calledOnce, "collection should have been searched");
        start();
    }, 100);
});

asyncTest("search on input and keyup event", function () {
    this.filterView.render();
    var spy = sinon.spy(this.collection, "search");

    // trigger both events!
    this.filterView.$input.trigger($.Event("input"));
    this.filterView.$input.trigger($.Event("keyup"));

    setTimeout(function() {
        ok(spy.calledOnce, "collection should have only been searched once");
        start();
    }, 100);
});


module("Page", {
    setup: function() {
        // make sure contextPath is not system dependent
        AJS.contextPath = function() {
            return "";
        };

        this.collection = new RY.PageCollection();
        this.collectionView = new RY.PageCollectionView({collection: this.collection});
        this.collectionView.render();

        this.page1 = new RY.Page({
            title: "page one",
            space: "space one",
            lastSeen: new Date()
        });

        this.page2 = new RY.Page({
            title: "page two",
            lastSeen: new Date()
        });

         this.page3 = new RY.Page({
            title: "page three",
            lastSeen: new Date()
        });

        this.collection.reset([this.page1, this.page2, this.page3]);

    }
});

test("PageCollection search", function() {

    // search for 'one'
    var result = this.collection.search("one");
    equal(result.length, 1);
    equal(result[0], this.page1);

    // search for 'page'
    result = this.collection.search("page");
    equal(result.length, 3);

    // search for ''
    result = this.collection.search("");
    equal(result.length, 3);

    // search for combination of page name and space
    result = this.collection.search("space one page");
    equal(result.length, 1);
});

test("Search for space", function() {
    var result = this.collection.search("space on");
    equal(result.length, 1);
    equal(result[0], this.page1);
});


module("util");
test("daysSince", function() {
    var now = new Date();
    var daysSince = RY.util.daysSince(now);
    equal(daysSince, 0);

    var yesterday = new Date(now.getFullYear(), now.getMonth(), now.getDate() - 1);
    yesterday.setMinutes(20);
    daysSince = RY.util.daysSince(yesterday);
    equal(daysSince, 1);

    var threeDaysAgo = new Date(now.getFullYear(), now.getMonth(), now.getDate() - 3);
    daysSince = RY.util.daysSince(threeDaysAgo);
    equal(daysSince, 3);
});
