var RY = RY || {};

/**
 * @Deprecated in favor for data from REST resource.
 *
 * Simple module to store and retrieve the recent pages in the local storage.
 * @type {*}
 * @param storage an object that corresponds to the localStorage interface
 */
RY.RecentPageStorage = function(storage) {
    var LS_KEY = "com.atlassian.confluence.plugins.recently.viewed.pages.v1";
    var MAX_PAGES = 100;
    var pages = {};

    /**
     * Parses the pages out of local storage.
     *
     * @return {Object}
     */
    var readPages = function() {
        var transformer = function(key, value) {

            // backwards compability for dates in string UTC format. convert to timestamp
            if (key === "lastSeen" && _.isString(value)) {
                // fix IE's date parsing.
                if (AJS.$.browser.msie) {
                    value = value.replace(/\-/g, "/");
                    value = value.replace(/T.*$/, "");
                }

                return new Date(value).getTime();
            } else {
                return value;
            }
        };

        try {
            pages = JSON.parse(storage.getItem(LS_KEY), transformer) || {};
        } catch (e) {
            // json parsing or local storage operation could potentially throw an exception. proceed
            // with an empty pages object then.
            pages = {};
        }
        return pages;
    };


    /**
     * Restricts the amount of pages stored to MAX_LENGTH pages. Chucks out the oldest entries.
     */
    var checkMaxPages = function() {
        var pageArray = _.values(pages);
        var diff = pageArray.length - MAX_PAGES;
        if (diff > 0) {
            var oldestPages = _.sortBy(pageArray, function (page) {
                return page.lastSeen;
            });

            _.times(diff, function() {
                var oldest = oldestPages.shift();
                delete pages[oldest.id];
            });
        }
    };

    var storePages = function() {
        checkMaxPages();
        try {
            storage.setItem(LS_KEY, JSON.stringify(pages));
        } catch (e) {
            // there is always the possibility that the quota was exceeded. ignore that for now.
        }
    };


    this.addCurrentPage = function(attrs) {
        if (!(attrs.id && attrs.title)) {
            return;
        }

        readPages();
        savePage(attrs);
        storePages();
    };

    var savePage = function(attrs) {
        var page = pages[attrs.id];
        if (!page) {
            pages[attrs.id] = page = {};
        }

        page = _.extend(page, attrs);

        page.lastSeen = new Date().getTime();
        page.count = page.count + 1 || 1;
    };

    /**
     * Returns a list of all recent pages.
     *
     * @return {Array}
     */
    this.getPages = function() {
        return _.values(readPages());
    };
};
