/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.recentlyviewed.rest;

import com.atlassian.confluence.plugins.recentlyviewed.RecentSpace;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.math.NumberUtils;

@Path(value="/recent")
@Produces(value={"application/json;charset=UTF-8"})
public class RecentlyViewedResource {
    public static final int DEFAULT_MAX_RESULTS_PAGES = 200;
    private static final int DEFAULT_MAX_RESULTS_SPACES = 5;
    private final RecentlyViewedManager recentlyViewedManager;
    private final UserManager userManager;

    public RecentlyViewedResource(RecentlyViewedManager recentlyViewedManager, @ComponentImport UserManager userManager) {
        this.recentlyViewedManager = recentlyViewedManager;
        this.userManager = userManager;
    }

    @GET
    public Response getRecentlyViewed(@QueryParam(value="includeTrashedContent") boolean includeTrashedContent, @QueryParam(value="limit") String limitStr) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return Response.serverError().build();
        }
        int limit = NumberUtils.toInt((String)limitStr, (int)200);
        List<RecentlyViewed> recentlyViewed = this.recentlyViewedManager.getRecentlyViewed(userKey, includeTrashedContent, limit);
        return Response.ok(recentlyViewed).build();
    }

    @Path(value="/pages")
    @GET
    public Response getRecentlyViewedPages(@QueryParam(value="noTrashedContent") boolean noTrashedContent, @QueryParam(value="limit") String limitStr) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return Response.serverError().build();
        }
        int limit = NumberUtils.toInt((String)limitStr, (int)200);
        List<RecentlyViewed> recentlyViewed = this.recentlyViewedManager.getRecentlyViewedPages(userKey.getStringValue(), noTrashedContent, limit);
        return Response.ok(recentlyViewed).build();
    }

    @Path(value="/spaces")
    @GET
    public Response getRecentlyViewedSpaces(@QueryParam(value="limit") String limitStr) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            return Response.serverError().build();
        }
        int limit = NumberUtils.toInt((String)limitStr, (int)5);
        List<Space> recentlyViewedSpaces = this.recentlyViewedManager.getRecentlyViewedSpaces(userKey.getStringValue(), limit);
        List recentSpaces = recentlyViewedSpaces.stream().map(RecentSpace::fromSpace).collect(Collectors.toList());
        return Response.ok(recentSpaces).build();
    }
}

