/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.recentlyviewed;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.plugins.recentlyviewed.dao.RecentlyViewedDao;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.usercompatibility.UserCompatibilityHelper;
import com.atlassian.marshalling.api.Marshaller;
import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.marshalling.api.Unmarshaller;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={RecentlyViewedManager.class})
public class DefaultRecentlyViewedManager
implements RecentlyViewedManager {
    public static final int DELETE_OLDER_THAN_DAYS = 60;
    private static final int SPACE_FETCH_FACTOR = 20;
    private static final String RECENT_SPACES_CACHE_NAME = DefaultRecentlyViewedManager.class.getName() + ".RecentSpacesCache";
    private static final int PAGE_FETCH_FACTOR = 2;
    private final RecentlyViewedDao recentlyViewedDao;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final Supplier<StableReadExternalCache<ImmutableList>> cacheRef;

    @Autowired
    public DefaultRecentlyViewedManager(RecentlyViewedDao recentlyViewedDao, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport VCacheFactory cacheFactory) {
        this.recentlyViewedDao = recentlyViewedDao;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.cacheRef = Lazy.supplier(() -> this.createCache(cacheFactory));
    }

    private StableReadExternalCache<ImmutableList> createCache(VCacheFactory cacheFactory) {
        return cacheFactory.getStableReadExternalCache(RECENT_SPACES_CACHE_NAME, new MarshallingPair((Marshaller)MarshallerFactory.serializableMarshaller(ImmutableList.class), (Unmarshaller)MarshallerFactory.serializableMarshaller(ImmutableList.class)), new ExternalCacheSettingsBuilder().build());
    }

    @Override
    public void savePageView(String userKey, long contentId, String spaceKey, long timestamp) {
        this.savePageView(userKey, contentId, null, spaceKey, timestamp);
    }

    @Override
    public void savePageView(String userKey, long contentId, String contentType, String spaceKey, long timestamp) {
        this.recentlyViewedDao.update(contentId, contentType, userKey, spaceKey, timestamp);
        this.updateSpaceCache(userKey, spaceKey);
    }

    @Override
    public void removePageViews(long contentId) {
        this.recentlyViewedDao.delete(contentId);
    }

    @Override
    public List<Long> getRecentlyViewedIds(String userKey) {
        return this.recentlyViewedDao.findRecentContentIds(userKey);
    }

    @Override
    public List<RecentlyViewed> getRecentlyViewed(String userKey, int limit) {
        return this.getRecentlyViewed(new UserKey(userKey), false, limit);
    }

    @Override
    public List<RecentlyViewed> getRecentlyViewed(@Nonnull UserKey userKey, boolean includeTrashedContent, int limit) {
        if (limit <= 0) {
            return Collections.emptyList();
        }
        List<RecentlyViewed> recentlyViewedItems = this.recentlyViewedDao.findRecentlyViewed(userKey, limit, 0);
        ArrayList filteredPages = Lists.newArrayList();
        for (RecentlyViewed recentlyViewed : recentlyViewedItems) {
            AbstractPage content = this.pageManager.getAbstractPage(recentlyViewed.getId());
            if (content == null || content.isDeleted() && (!content.isDeleted() || !includeTrashedContent)) continue;
            recentlyViewed.setPageData(content);
            filteredPages.add(recentlyViewed);
        }
        return filteredPages;
    }

    @Override
    public List<RecentlyViewed> getRecentlyViewedPages(String userKey, boolean noTrashedContent, int limit) {
        if (limit <= 0) {
            return Collections.emptyList();
        }
        List<RecentlyViewed> recentlyViewedPages = this.recentlyViewedDao.findRecentlyViewedPages(userKey, limit * 2);
        ArrayList filteredPages = Lists.newArrayList();
        for (RecentlyViewed recentlyViewed : recentlyViewedPages) {
            Page page = this.pageManager.getPage(recentlyViewed.getId());
            if (page == null || noTrashedContent && StringUtils.equals((CharSequence)page.getContentStatus(), (CharSequence)"deleted")) continue;
            recentlyViewed.setPageData((AbstractPage)page);
            filteredPages.add(recentlyViewed);
            if (filteredPages.size() != limit) continue;
            return filteredPages;
        }
        return filteredPages;
    }

    @Override
    public List<RecentlyViewed> getRecentlyViewedPages(String userKey, Date after, int limit) {
        if (limit <= 0) {
            return Lists.newArrayList();
        }
        return this.recentlyViewedDao.findRecentlyViewedPages(userKey, after, limit);
    }

    @Override
    public List<Space> getRecentlyViewedSpaces(String userKey, int limit) {
        if (limit <= 0) {
            return Lists.newArrayList();
        }
        User user = UserCompatibilityHelper.getUserForKey((String)userKey);
        List lastSpaces = (List)VCacheUtils.unsafeJoin((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).get(userKey, () -> ImmutableList.copyOf(this.recentlyViewedDao.findRecentlyViewedSpaceKeys(userKey, limit * 20))));
        return this.spacesWithPermissions(lastSpaces, limit, user);
    }

    @Override
    public Map<Long, Collection<UserKey>> getRecentViewers(Iterable<Long> contentIds) {
        return Maps.transformValues(this.recentlyViewedDao.findRecentViewers(contentIds), x -> x.stream().map(UserKey::new).collect(Collectors.toList()));
    }

    @Override
    public List<RecentlyViewed> getRecentlyViewed(String userKey, Date after, Set<String> spaceKeys, int limit, int offset) {
        if (limit <= 0) {
            return Collections.emptyList();
        }
        return this.recentlyViewedDao.findRecentlyViewed(userKey, after, spaceKeys, limit, offset);
    }

    private List<Space> spacesWithPermissions(List<String> spaceKeys, int limit, User user) {
        ArrayList result = Lists.newArrayList();
        for (String spaceKey : spaceKeys) {
            Space space;
            if (!result.stream().noneMatch(arg_0 -> DefaultRecentlyViewedManager.hasSpaceKey(spaceKey).apply(arg_0)) || (space = this.spaceManager.getSpace(spaceKey)) == null || !this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space) || space.isArchived()) continue;
            result.add(space);
            if (result.size() != limit) continue;
            return result;
        }
        return result;
    }

    private static Predicate<Space> hasSpaceKey(String spaceKey) {
        return input -> input.getKey().equals(spaceKey);
    }

    @Override
    public void deleteOldEntries() {
        this.recentlyViewedDao.deleteOldRecentyViewed(60);
    }

    private void updateSpaceCache(String userKey, String spaceKey) {
        Optional cachedSpaces = (Optional)VCacheUtils.unsafeJoin((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).get(userKey));
        if (cachedSpaces.isPresent() && (((ImmutableList)cachedSpaces.get()).isEmpty() || !spaceKey.equals(((ImmutableList)cachedSpaces.get()).get(0)))) {
            ArrayList<String> list = new ArrayList<String>((Collection)cachedSpaces.get());
            list.remove(spaceKey);
            list.add(0, spaceKey);
            ((StableReadExternalCache)this.cacheRef.get()).put(userKey, (Object)ImmutableList.copyOf(list), PutPolicy.PUT_ALWAYS);
        }
    }
}

