/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gadgets.metadata;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.CacheStatisticsManager;
import com.atlassian.confluence.event.events.admin.MacroMetadataChangedEvent;
import com.atlassian.confluence.macro.browser.MacroMetadataProvider;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.macro.browser.beans.MacroSummary;
import com.atlassian.confluence.plugins.gadgets.events.GadgetInstalledEvent;
import com.atlassian.confluence.plugins.gadgets.events.GadgetUninstalledEvent;
import com.atlassian.confluence.plugins.gadgets.metadata.CachedMetadata;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetCacheFlusher;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetUsageTracker;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetsMacroMetadataProvider;
import com.atlassian.confluence.plugins.gadgets.requestcontext.RequestContextBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.GadgetSpecProvider;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecStore;
import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeedStore;
import com.atlassian.gadgets.feed.GadgetFeedReaderFactory;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettingsBuilder;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CachingGadgetsMacroMetadataProvider
implements MacroMetadataProvider,
InitializingBean,
DisposableBean {
    @VisibleForTesting
    static final String CACHE_NAME = CachingGadgetsMacroMetadataProvider.class.getName();
    @VisibleForTesting
    static final String CACHE_KEY = "Key";
    private static final Logger log = LoggerFactory.getLogger(CachingGadgetsMacroMetadataProvider.class);
    private final EventPublisher eventPublisher;
    private final GadgetCacheFlusher gadgetCacheFlusher;
    private final GadgetsMacroMetadataProvider delegateProvider;
    private final Supplier<JvmCache<String, CachedMetadata>> cache;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean invalidationRequested = new AtomicBoolean();

    public CachingGadgetsMacroMetadataProvider(CacheManager cacheManager, VCacheFactory cacheFactory, CacheStatisticsManager cacheStatisticsManager, GadgetSpecProvider gadgetSpecProvider, ExternalGadgetSpecStore gadgetStore, SubscribedGadgetFeedStore feedStore, GadgetFeedReaderFactory gadgetFeedReaderFactory, GadgetSpecFactory gadgetSpecFactory, RequestContextBuilder requestContextBuilder, I18nResolver resolver, EventPublisher eventPublisher, GadgetUsageTracker gadgetUsageTracker) {
        this((Supplier<JvmCache<String, CachedMetadata>>)Lazy.supplier(() -> cacheFactory.getJvmCache(CACHE_NAME, new JvmCacheSettingsBuilder().maxEntries(1).build())), new GadgetCacheFlusher(cacheManager, gadgetUsageTracker, cacheStatisticsManager, eventPublisher), new GadgetsMacroMetadataProvider(gadgetSpecProvider, gadgetStore, feedStore, gadgetFeedReaderFactory, gadgetSpecFactory, requestContextBuilder, resolver, eventPublisher), eventPublisher);
    }

    @VisibleForTesting
    CachingGadgetsMacroMetadataProvider(Supplier<JvmCache<String, CachedMetadata>> cache, GadgetCacheFlusher gadgetCacheFlusher, GadgetsMacroMetadataProvider delegateProvider, EventPublisher eventPublisher) {
        this.delegateProvider = Objects.requireNonNull(delegateProvider);
        this.gadgetCacheFlusher = Objects.requireNonNull(gadgetCacheFlusher);
        this.cache = Objects.requireNonNull(cache);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    public void afterPropertiesSet() {
        this.cache.get();
    }

    public void destroy() {
        this.clearMacroMetadataCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MacroMetadata> getData() {
        if (!this.lock.tryLock()) {
            return this.getMacroMetadataImmediately();
        }
        try {
            if (this.invalidationRequested.get()) {
                this.invalidationRequested.set(false);
                Collection<MacroMetadata> collection = this.retrieveMetadataAndUpdateCache().getMacroMetadata();
                return collection;
            }
            Optional cachedMetadata = ((JvmCache)this.cache.get()).get((Object)CACHE_KEY);
            if (!cachedMetadata.isPresent()) {
                Collection<MacroMetadata> collection = this.retrieveMetadataAndUpdateCache().getMacroMetadata();
                return collection;
            }
            Set<URI> currentGadgetUris = this.getGadgetUris();
            if (((CachedMetadata)cachedMetadata.get()).matchesGadgetUris(currentGadgetUris)) {
                log.debug("Cached macro metadata matches current set of {} gadget URIs, returning cached macro metadata", (Object)currentGadgetUris.size());
                Collection<MacroMetadata> collection = ((CachedMetadata)cachedMetadata.get()).getMacroMetadata();
                return collection;
            }
            log.debug("Cached macro metadata set of {} gadget URIs does not match current set of {} gadget URIs", (Object)((CachedMetadata)cachedMetadata.get()).getGadgetUris().size(), (Object)currentGadgetUris.size());
            Collection<MacroMetadata> collection = this.retrieveMetadataAndUpdateCache().getMacroMetadata();
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Collection<MacroMetadata> getMacroMetadataImmediately() {
        Optional cachedMetadata = ((JvmCache)this.cache.get()).get((Object)CACHE_KEY);
        if (cachedMetadata.isPresent()) {
            return ((CachedMetadata)cachedMetadata.get()).getMacroMetadata();
        }
        return Collections.emptyList();
    }

    public Collection<MacroSummary> getSummaries() {
        return GadgetsMacroMetadataProvider.getSummaries(this.getData());
    }

    public MacroMetadata getByMacroName(String macroName) {
        return this.getByMacroNameAndId(macroName, null);
    }

    public MacroMetadata getByMacroNameAndId(String macroName, String alternateId) {
        return GadgetsMacroMetadataProvider.getByMacroNameAndId(macroName, alternateId, this::getData);
    }

    private CachedMetadata retrieveMetadataAndUpdateCache() {
        Set<URI> gadgetUris = this.delegateProvider.getGadgetUris();
        log.debug("Starting fetch and assembly of gadgets macro metadata for {} gadget URIs", (Object)gadgetUris.size());
        long start = System.currentTimeMillis();
        Collection<MacroMetadata> macroMetadata = this.delegateProvider.getMacroMetadata(gadgetUris);
        long end = System.currentTimeMillis();
        CachedMetadata cachedMetadata = new CachedMetadata((Set<URI>)ImmutableSet.copyOf(gadgetUris), (Collection<MacroMetadata>)ImmutableList.copyOf(macroMetadata));
        ((JvmCache)this.cache.get()).put((Object)CACHE_KEY, (Object)cachedMetadata);
        log.debug("Gadgets macro metadata assembly for {} gadget URIs took {} ms.", (Object)gadgetUris.size(), (Object)(end - start));
        this.gadgetCacheFlusher.requestGadgetsCacheFlush();
        this.eventPublisher.publish((Object)new MacroMetadataChangedEvent((Object)this));
        return cachedMetadata;
    }

    private Set<URI> getGadgetUris() {
        log.trace("Fetching gadget URIs first");
        long start = System.currentTimeMillis();
        Set<URI> gadgetUris = this.delegateProvider.getGadgetUris();
        long end = System.currentTimeMillis();
        log.trace("Fetched {} gadget URIs in {}ms", (Object)gadgetUris.size(), (Object)(end - start));
        return gadgetUris;
    }

    private void clearMacroMetadataCache() {
        log.debug("Clearing gadgets macro metadata cache");
        ((JvmCache)this.cache.get()).removeAll();
    }

    private void invalidateCache() {
        log.debug("Invalidating the cache");
        this.invalidationRequested.set(true);
    }

    @EventListener
    public void gadgetInstalled(GadgetInstalledEvent event) {
        log.debug("Gadget installed, uri={}", (Object)event.getGadgetUri());
        this.invalidateCache();
    }

    @EventListener
    public void gadgetUninstalled(GadgetUninstalledEvent event) {
        log.debug("Gadget uninstalled, uri={}", (Object)event.getGadgetUri());
        this.invalidateCache();
    }

    @EventListener
    public void pluginUninstalled(PluginUninstalledEvent event) {
        log.debug("Plugin {} uninstalled, clearing gadgets metadata cache since we assume it's now stale", (Object)event.getPlugin());
        this.invalidateCache();
    }

    @EventListener
    public void pluginUpgraded(PluginUpgradedEvent event) {
        log.debug("Plugin {} upgraded, clearing gadgets metadata cache since we assume it's now stale", (Object)event.getPlugin());
        this.invalidateCache();
    }
}

