/* globals define, AJS */
define("confluence-user-profile/avatar-picker/avatar-picker-dialog", [
    "jquery",
    "underscore",
    "confluence-user-profile/avatar-picker/avatar-picker-panel"
],
/**
 * @tainted AJS.I18n
 */
function(
    $,
    _,
    AvatarPickerPanel
) {
    "use strict";

    function AvatarPickerDialog(opts) {
        return this.init(opts);
    }

    AvatarPickerDialog.prototype.defaults = {
        dialogTitle: AJS.I18n.getText("confluence.user.profile.avatar.picker.details"),
        dialogOptions: {
            width:400,
            height:518,
            id:"personal-avatar-picker-dialog",
            closeOnOutsideClick: false
        },
        onCrop: function() {},
        trigger: null
    };

    AvatarPickerDialog.prototype.init = function(opts) {
        _.bindAll(this, "initDialogContent", "hide", "show", "cancel");

        this.options = $.extend(true, {}, this.defaults, opts);
        this._$dialog = new AJS.Dialog(this.options.dialogOptions);

        this.initDialogContent();

        if (this.options.trigger) {
            this._$trigger = $(this.options.trigger);
            this._$trigger.click(_.bind(function(e) {
                e.preventDefault();
                this.show();
            }, this));
        }

        return this;
    };

    AvatarPickerDialog.prototype.initDialogContent = function() {
        this._$dialog
            .addHeader(this.options.dialogTitle)
            .addPanel()
            .addSubmit(AJS.I18n.getText("confluence.user.profile.avatar.picker.save"))
            .addCancel(AJS.I18n.getText("confluence.user.profile.avatar.picker.cancel"), this.cancel);

        this._$saveButton = this._$dialog.getCurrentPanel().page.buttonpanel.find(".button-panel-submit-button");
        this._$cancelButton = this._$dialog.getCurrentPanel().page.buttonpanel.find(".button-panel-cancel-link");

        this.panel = new AvatarPickerPanel({
            panel: this._$dialog.getCurrentPanel().body,
            saveButton: this._$saveButton,
            cancelButton: this._$cancelButton,
            onCrop: this.options.onCrop,
            onExpanded: function(toggle) {
                $('#personal-avatar-picker-dialog').toggleClass('expanded', toggle);
            }
        });
    };

    AvatarPickerDialog.prototype.hide = function() {
        this.panel.hideMessage();
        this._$dialog.hide();
        this.panel.getImageCropper().resetState(); //Only resets errors and the file upload element, imageExplorer image is persisted.
    };

    AvatarPickerDialog.prototype.cancel = function() {
        this.panel.getImageCropper().restoreState();
        this.hide();
    };

    AvatarPickerDialog.prototype.setMessage = function(message) {
        this.panel.setMessage(message);
    };

    AvatarPickerDialog.prototype.show = function() {
        // save last position in case user moves/zooms image and then clicks cancel
        this.panel.getImageCropper().saveState();
        this._$dialog.show();
        $("#personal-avatar-picker-dialog .button-panel-submit-button").removeClass("button-panel-button").addClass("aui-button aui-button-primary");
    };

    return AvatarPickerDialog;
});