/**
 * @module confluence-templates/variable-placeholder
 */
define('confluence-templates/variable-placeholder', [
    'ajs',
    'jquery'
], function(
    AJS,
    $
) {
    'use strict';

    return {
        component: {
            insertPlaceholder: function(name, additionalAttrs) {
                var variable;
                var label = '$' + name;
                var ed = AJS.Rte.getEditor();

                AJS.Rte.BookmarkManager.storeBookmark();

                var attrs = {
                    title: label,
                    src: AJS.Meta.get('context-path')
                    + '/plugins/servlet/confluence/placeholder/template-variable?name=' + encodeURIComponent(name),
                    'data-variable-name': name,
                    class: 'template-variable',
                    alt: '$' + name
                };
                !!additionalAttrs && $.extend(attrs, additionalAttrs);
                variable = $('<img/>').attr(attrs);

                ed.selection.setNode(variable[0]);
            }
        },
        init: function() {
            // CONFDEV-9297 - prevent default browser drag behaviour for template variables.
            $(AJS.Rte.getEditor().getBody()).delegate('img.template-variable', 'dragstart', function(e) {
                e.preventDefault();
            });
        }
    };
});

if (AJS.Meta.get('content-type') === 'template') {
    require('confluence/module-exporter').safeRequire('confluence-templates/variable-placeholder', function(VariablePlaceholder) {
        'use strict';

        require('confluence/legacy').VariablePlaceHolder = VariablePlaceholder.component;
        require('ajs').bind('init.rte', VariablePlaceholder.init);
    });
}
