/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.plugins.ia.model.SpaceBean;
import com.atlassian.confluence.plugins.ia.service.SpaceBeanFactory;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;

public class DefaultSpaceBeanFactory
implements SpaceBeanFactory {
    private final SpaceLogoManager spaceLogoManager;
    private final BootstrapManager bootstrapManager;

    public DefaultSpaceBeanFactory(SpaceLogoManager spaceLogoManager, BootstrapManager bootstrapManager) {
        this.spaceLogoManager = spaceLogoManager;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public SpaceBean createSpaceBean(Space space, User currentUser) {
        String homePath = space.getDeepLinkUri().toString();
        String logoUriReference = this.spaceLogoManager.getLogoUriReference(space, currentUser);
        String contextPath = this.bootstrapManager.getWebAppContextPath();
        SpaceDescription spaceDescription = space.getDescription();
        return new SpaceBean(space.getKey(), space.getName(), spaceDescription != null ? spaceDescription.getBodyAsString() : "", contextPath + homePath, logoUriReference, contextPath + this.getBrowseUrlPath(space), space.isPersonal(), currentUser != null && space.isPersonal() && space.getKey().equals("~" + currentUser.getName()));
    }

    private String getBrowseUrlPath(Space space) {
        return "/collector/pages.action?key=" + GeneralUtil.urlEncode((String)space.getKey());
    }
}

