/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.content.render.xhtml.links.WebLink;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.plugins.ia.SidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.SidebarLinkDelegate;
import com.atlassian.confluence.plugins.ia.SidebarLinkManager;
import com.atlassian.confluence.plugins.ia.impl.DefaultSidebarLink;
import com.atlassian.confluence.plugins.ia.rest.SidebarLinkBean;
import com.atlassian.confluence.setup.BootstrapManager;
import org.apache.commons.lang3.StringUtils;

public class DefaultSidebarLinkDelegate
implements SidebarLinkDelegate {
    private SidebarLinkManager sidebarLinkManager;
    private BootstrapManager bootstrapManager;

    protected DefaultSidebarLinkDelegate(SidebarLinkManager sidebarLinkManager, BootstrapManager bootstrapManager) {
        this.sidebarLinkManager = sidebarLinkManager;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public SidebarLink createSidebarLink(String spaceKey, Long resourceId, SidebarLink.Type type, String customTitle, String url, String iconClass) {
        return this.sidebarLinkManager.createLink(spaceKey, SidebarLinkCategory.QUICK, type, null, 0, customTitle, url, iconClass, resourceId == null ? -2L : resourceId);
    }

    @Override
    public SidebarLinkBean getSidebarLinkBean(SidebarLink sidebarLink) {
        String title = sidebarLink.getCustomTitle();
        String url = sidebarLink.getHardcodedUrl();
        String styleClass = sidebarLink.getType().getStyleClass();
        String customIconClass = sidebarLink.getCustomIconClass();
        title = title == null ? "" : title;
        String string = styleClass = styleClass == null ? "" : styleClass;
        if (StringUtils.isNotBlank((CharSequence)customIconClass)) {
            styleClass = styleClass + " " + customIconClass;
        }
        return new SidebarLinkBean(sidebarLink.getID(), sidebarLink.getWebItemKey(), title, WebLink.isValidURL((String)url) ? url : "#", sidebarLink.getPosition(), styleClass, sidebarLink.getHidden(), false, null, null);
    }

    protected SidebarLink getCustomizedSidebarLink(SidebarLink sidebarLink, Addressable entity) {
        DefaultSidebarLink link = new DefaultSidebarLink(sidebarLink);
        if (entity != null) {
            String title = link.getCustomTitle();
            String url = link.getHardcodedUrl();
            String contextPath = this.bootstrapManager.getWebAppContextPath();
            if (StringUtils.isBlank((CharSequence)title)) {
                link.setCustomTitle(entity.getDisplayTitle());
            }
            if (StringUtils.isBlank((CharSequence)url)) {
                link.setHardcodedUrl(contextPath + entity.getUrlPath());
            }
        }
        return link;
    }
}

