/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.ia.model.BlogNodeBean;
import com.atlassian.confluence.plugins.ia.model.DateNodeBean;
import com.atlassian.confluence.plugins.ia.service.BlogTreeService;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBlogTreeService
implements BlogTreeService {
    private final BootstrapManager bootstrapManager;
    private final PageManager pageManager;
    private final LocaleManager localeManager;
    private final ContentPermissionManager contentPermissionManager;
    private static final Logger log = LoggerFactory.getLogger(DefaultBlogTreeService.class);
    private static final DateFormat yearFormat = new SimpleDateFormat("yyyy");
    private static final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("MMMM");
    private static final Comparator<DateNodeBean> DATE_NODE_BEAN_COMPARATOR = (dateNodeBean1, dateNodeBean2) -> {
        if (dateNodeBean1.getGroupType() == 2) {
            return Integer.valueOf(dateNodeBean1.getGroupValue().split("/")[0]).compareTo(Integer.valueOf(dateNodeBean2.getGroupValue().split("/")[0]));
        }
        return Integer.valueOf(dateNodeBean1.getGroupValue()).compareTo(Integer.valueOf(dateNodeBean2.getGroupValue()));
    };

    public DefaultBlogTreeService(BootstrapManager bootstrapManager, PageManager pageManager, LocaleManager localeManager, ContentPermissionManager contentPermissionManager) {
        this.bootstrapManager = bootstrapManager;
        this.pageManager = pageManager;
        this.localeManager = localeManager;
        this.contentPermissionManager = contentPermissionManager;
    }

    @Override
    public List<DateNodeBean> getBlogTree(User user, String spaceKey, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
            BlogPost latestPermittedBlogPost = this.getLatestPermittedAddedBlogPost(user, spaceKey);
            if (latestPermittedBlogPost != null) {
                calendar.setTime(latestPermittedBlogPost.getCreationDate());
            }
        }
        return this.generateYearBeans(user, spaceKey, calendar);
    }

    @Override
    public List<DateNodeBean> getBlogTree(User user, long id) {
        BlogPost blogPost = this.getTargetBlogPost(user, id);
        if (blogPost == null) {
            return Collections.emptyList();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(blogPost.getPostingDate());
        String spaceKey = blogPost.getSpaceKey();
        return this.generateYearBeans(user, spaceKey, calendar);
    }

    @Override
    public List<DateNodeBean> getMonthsWithBlogPosts(User user, String spaceKey, String year) {
        try {
            Calendar dateToExpand = Calendar.getInstance();
            dateToExpand.set(1, Integer.parseInt(year));
            return this.generateMonthBeans(user, spaceKey, dateToExpand);
        }
        catch (NumberFormatException e) {
            log.debug("Couldn't parse the year '{}' when retrieving months with blog posts in the space with key '{}'", (Object)year, (Object)spaceKey);
            return Collections.emptyList();
        }
    }

    @Override
    public List<BlogNodeBean> getBlogsForMonth(User user, String spaceKey, String month) {
        try {
            Calendar dateToExpand = Calendar.getInstance();
            String[] split = month.split("/");
            dateToExpand.set(2, Integer.parseInt(split[0]));
            dateToExpand.set(1, Integer.parseInt(split[1]));
            return this.getPermittedBlogPostBeansPerMonth(user, spaceKey, dateToExpand);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            log.debug("Couldn't parse the month '{}' when retrieving blog posts in the space with key '{}'", (Object)month, (Object)spaceKey);
            return Collections.emptyList();
        }
    }

    @Override
    public String getDefaultBlogUrl(User user, String spaceKey) {
        Preconditions.checkNotNull((Object)spaceKey);
        BlogPost latestPermittedBlogPost = this.getLatestPermittedAddedBlogPost(user, spaceKey);
        String defaultBlogUrl = this.bootstrapManager.getWebAppContextPath();
        if (latestPermittedBlogPost == null) {
            return defaultBlogUrl + "/pages/viewrecentblogposts.action?key=" + spaceKey;
        }
        return defaultBlogUrl + latestPermittedBlogPost.getUrlPath();
    }

    private BlogPost getTargetBlogPost(User user, long pageId) {
        AbstractPage abstractPage = this.pageManager.getAbstractPage(pageId);
        if (abstractPage == null || !(abstractPage instanceof BlogPost) || !this.isPermitted(user, abstractPage)) {
            return null;
        }
        return (BlogPost)abstractPage;
    }

    private List<DateNodeBean> generateYearBeans(User user, String spaceKey, Calendar dateToExpand) {
        Set yearsWithBlogPosts = this.pageManager.getYearsWithBlogPosts(spaceKey);
        ArrayList beans = Lists.newArrayList();
        Calendar calendar = Calendar.getInstance();
        DateNodeBean bean = null;
        for (Date year : yearsWithBlogPosts) {
            calendar.setTime(year);
            bean = new DateNodeBean(yearFormat.format(year), 1, String.valueOf(calendar.get(1)));
            if (dateToExpand != null && dateToExpand.get(1) == calendar.get(1)) {
                List<DateNodeBean> monthNodes = this.generateMonthBeans(user, spaceKey, dateToExpand);
                if (monthNodes.isEmpty()) continue;
                bean.setChildren(monthNodes);
                beans.add(bean);
                continue;
            }
            beans.add(bean);
        }
        Collections.sort(beans, Collections.reverseOrder(DATE_NODE_BEAN_COMPARATOR));
        return beans;
    }

    private List<DateNodeBean> generateMonthBeans(User user, String spaceKey, Calendar dateToExpand) {
        EnumSet<Month> monthsWithUserVisibleBlogPosts = EnumSet.noneOf(Month.class);
        Month selectedMonth = Month.of(dateToExpand.get(2) + 1);
        ArrayList<BlogNodeBean> selectedMonthBlogPosts = new ArrayList<BlogNodeBean>();
        List blogPosts = this.pageManager.getBlogPosts(spaceKey, dateToExpand, 1);
        for (BlogPost blogPost : blogPosts) {
            Month month2 = Month.from(blogPost.getCreationDate().toInstant().atZone(ZoneId.systemDefault()));
            Supplier isPermitted = Suppliers.memoize(() -> this.isPermitted(user, (AbstractPage)blogPost));
            if (!monthsWithUserVisibleBlogPosts.contains(month2) && ((Boolean)isPermitted.get()).booleanValue()) {
                monthsWithUserVisibleBlogPosts.add(month2);
            }
            if (month2 != selectedMonth || !((Boolean)isPermitted.get()).booleanValue()) continue;
            selectedMonthBlogPosts.add(new BlogNodeBean(blogPost.getId(), blogPost.getTitle(), this.bootstrapManager.getWebAppContextPath() + blogPost.getUrlPath()));
        }
        return monthsWithUserVisibleBlogPosts.stream().sorted(Comparator.reverseOrder()).map(month -> {
            DateNodeBean bean = new DateNodeBean(MONTH_FORMATTER.withLocale(this.getCurrentUserLocale()).format((TemporalAccessor)month), 2, month.getValue() - 1 + "/" + dateToExpand.get(1));
            if (month == selectedMonth) {
                bean.setChildren(selectedMonthBlogPosts);
            }
            return bean;
        }).collect(Collectors.toList());
    }

    private List<BlogNodeBean> getPermittedBlogPostBeansPerMonth(User user, String spaceKey, Calendar dateToExpand) {
        return this.pageManager.getBlogPosts(spaceKey, dateToExpand, 2).stream().filter(blogPost -> this.isPermitted(user, (AbstractPage)blogPost)).map(blogPost -> new BlogNodeBean(blogPost.getId(), blogPost.getTitle(), this.bootstrapManager.getWebAppContextPath() + blogPost.getUrlPath())).collect(Collectors.toList());
    }

    private Locale getCurrentUserLocale() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Locale locale = this.localeManager.getLocale((User)user);
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    private BlogPost getLatestPermittedAddedBlogPost(User user, String spaceKey) {
        BlogPost blogPost = this.pageManager.getNewestBlogPost(spaceKey);
        while (blogPost != null && !this.isPermitted(user, (AbstractPage)blogPost)) {
            blogPost = this.pageManager.findPreviousBlogPost(blogPost);
        }
        return blogPost;
    }

    private boolean isPermitted(User user, AbstractPage page) {
        return this.contentPermissionManager.hasContentLevelPermission(user, "View", (ContentEntityObject)page);
    }
}

