/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.plugins.ia.SidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.SidebarLinkManager;
import com.atlassian.confluence.plugins.ia.SidebarLinks;
import com.atlassian.confluence.plugins.ia.impl.DefaultSidebarLink;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSidebarLinkManager
implements SidebarLinkManager {
    private static final Logger log = LoggerFactory.getLogger(CachingSidebarLinkManager.class);
    private static final String CACHE_NAME = CachingSidebarLinkManager.class.getName() + ".SidebarLinkCache";
    private final SidebarLinkManager delegate;
    private final Supplier<StableReadExternalCache<SidebarLinks>> cacheRef;

    public CachingSidebarLinkManager(SidebarLinkManager delegate, VCacheFactory cacheFactory) {
        this.delegate = delegate;
        this.cacheRef = Lazy.supplier(() -> CachingSidebarLinkManager.createCache(cacheFactory));
    }

    private static StableReadExternalCache<SidebarLinks> createCache(VCacheFactory cacheFactory) {
        StableReadExternalCache cache = cacheFactory.getStableReadExternalCache(CACHE_NAME, MarshallerFactory.serializableMarshaller(SidebarLinks.class), new ExternalCacheSettingsBuilder().build());
        VCacheUtils.fold((CompletionStage)cache.removeAll(), (val, ex) -> {
            if (ex != null) {
                log.warn("Failed to clear sidebar links cache during startup");
            }
            return null;
        });
        return cache;
    }

    private void invalidateCache(SidebarLink link) {
        VCacheUtils.fold((CompletionStage)this.cache().remove(new String[]{Objects.requireNonNull(link).getSpaceKey()}), (val, ex) -> {
            if (ex != null) {
                log.error("Failed to invalidate sidebar links cache for space '{}'. Cache may be out of date.", (Object)link.getSpaceKey(), ex);
            }
            return null;
        });
    }

    private StableReadExternalCache<SidebarLinks> cache() {
        return Objects.requireNonNull((StableReadExternalCache)this.cacheRef.get(), "Cache has not been initialized");
    }

    private void invalidateCache() {
        VCacheUtils.fold((CompletionStage)this.cache().removeAll(), (val, ex) -> {
            if (ex != null) {
                log.warn("Failed to clear sidebar links cache");
            }
            return null;
        });
    }

    private SidebarLinks transformAoProxiesToDefaultSidebarLinks(SidebarLinks proxiedLinks) {
        return new SidebarLinks(proxiedLinks.getAllLinks().stream().map(DefaultSidebarLink::new).collect(Collectors.toList()));
    }

    @Override
    public SidebarLink createLink(String spaceKey, SidebarLinkCategory category, SidebarLink.Type type, String webItemKey, int position, String customTitle, String hardcodedUrl, String customIconClass, long destResourceId) {
        SidebarLink newLink = this.delegate.createLink(spaceKey, category, type, webItemKey, position, customTitle, hardcodedUrl, customIconClass, destResourceId);
        this.invalidateCache(newLink);
        return newLink;
    }

    @Override
    public void moveLink(SidebarLink link, int from, int to) {
        this.delegate.moveLink(link, from, to);
        this.invalidateCache(link);
    }

    @Override
    public void deleteLink(SidebarLink link) {
        this.delegate.deleteLink(link);
        this.invalidateCache(link);
    }

    @Override
    public void deleteLinks(long resourceId, SidebarLink.Type type) {
        this.delegate.deleteLinks(resourceId, type);
        this.invalidateCache();
    }

    @Override
    public void deleteLinksForSpace(String spaceKey) {
        this.delegate.deleteLinksForSpace(spaceKey);
        this.invalidateCache();
    }

    @Override
    public void hideLink(SidebarLink link) {
        this.delegate.hideLink(link);
        this.invalidateCache(link);
    }

    @Override
    public void showLink(SidebarLink link) {
        this.delegate.showLink(link);
        this.invalidateCache(link);
    }

    @Override
    public SidebarLink findById(int id) {
        return this.delegate.findById(id);
    }

    @Override
    public SidebarLinks findBySpace(String spaceKey) {
        return (SidebarLinks)VCacheUtils.fold((CompletionStage)this.cache().get(spaceKey, () -> this.transformAoProxiesToDefaultSidebarLinks(this.delegate.findBySpace(spaceKey))), Function.identity(), ex -> {
            log.warn("Failed to retrieve sidebar links from cache for space '{}'. Fetching from database instead.", (Object)spaceKey, ex);
            return this.delegate.findBySpace(spaceKey);
        });
    }
}

