define("confluence/softwareproject/dialog/abstract-panel-view",["jquery","underscore","ajs","backbone","confluence/softwareproject/util/config","confluence/softwareproject/util/service","confluence/softwareproject/util/select2-mixin"],function(D,H,F,G,B,E,C){var A=G.Model.extend({defaults:{selectedServer:null,isValid:false},reset:function(){H.extend(this.attributes,this.defaults)
}});
var I=G.View.extend({template:Confluence.SpaceBlueprints.SoftwareProject.Dialog,initialize:function(){this.panelId="";
this.panelTitle="";
this.view={$errorMessage:null,$servers:null};
this.servers=[];
this.on("reload.data",function(){E.resetCachingData();
this._fillServersData()
},this);
this.formData=new A();
this.listenTo(this.formData,"change:selectedServer",this._handleServerChanged)
},render:function(J){this.dialogView=J.dialog;
this.panelDialog=J.panelDialog;
if(J.$el){this.$el=J.$el
}else{this.$el=this.panelDialog.body
}this.el=this.$el[0];
this.delegateEvents();
this.listenTo(this.dialogView,"dialog.process.begin",this.onBeginInitDialog);
this.listenTo(this.dialogView,"dialog.process.finish",this.onEndInitDialog);
this.listenTo(this.dialogView,"dialog.showing.begin",this.onOpenDialog)
},initServerField:function(){this.view.$servers=this.$(".jira-servers");
this.view.$servers.on("change",this._onSelectServerChanged.bind(this));
this.setupSelect2({$el:this.view.$servers,placeholderText:F.I18n.getText("jira.server.placeholder"),isRequired:true})
},onBeginInitDialog:function(){},onEndInitDialog:function(){},onOpenDialog:function(J){this.init()
},init:function(){this._fillServersData().done(function(){this.reset()
}.bind(this))
},reset:function(){var J=this;
this.$("input[type=text]").each(function(){var K=D(this);
K.val("");
J.toggleSiblingErrorMessage(K,false)
})
},toggleEnablePanel:function(K){var J=this.$("input, area, select");
J=J.not("[name=jira-server]");
if(K){J.enable()
}else{J.disable()
}J.select2("enable",K);
if(!K){this.dialogView.toggleEnableInsertButton(false)
}},disableWholePanel:function(){var J=this.$("input, select, textarea");
this.$(".select2-container-active").removeClass("select2-container-active");
J.disable();
J.select2("enable",false);
this.dialogView.toggleEnableInsertButton(false)
},toggleSiblingErrorMessage:function(L,K,M){var J=L.siblings(".error");
if(K){L.focus();
J.removeClass("hidden").text(M)
}else{J.addClass("hidden").text("")
}},handleAjaxRequestError:function(L,K){var J=F.I18n.getText("confluence.software.jira.project.validation.cannot.connect");
if(K==="timeout"){J=F.I18n.getText("confluence.software.jira.project.validation.connection.timeout")
}var M=F.messages.error({body:J});
this.view.$errorMessage.empty().append(M).removeClass("hidden");
this.resetSelect2Options(L);
this.toggleSiblingErrorMessage(L,false);
this.dialogView.toggleEnableInsertButton(false)
},renderErrorNoAppLink:function(){var L=F.Meta.get("is-confluence-admin");
var J="";
if(L){J=F.I18n.getText("confluence.software.jira.project.noapplink.admin.message",F.contextPath())
}else{J=F.I18n.getText("confluence.software.jira.project.noapplink.user.message",F.contextPath())
}var K=F.messages.error({body:J});
this.view.$errorMessage.empty().append(K).removeClass("hidden");
this.toggleCreateButton(false)
},validateServer:function(K){var J=true;
if(K&&K.authUrl){this._renderErrorMessageUnauthentication(K);
J=false
}return J
},_renderErrorMessageUnauthentication:function(K){var M=this;
var L=(window.AppLinks&&window.AppLinks.authenticateRemoteCredentials);
var J=this.template.errorMessageOauth({forceUserToReload:!L});
this.view.$errorMessage.removeClass("hidden").append(J);
this.view.$errorMessage.find("a").click(function(N){N.preventDefault();
if(L){window.AppLinks.authenticateRemoteCredentials(K.authUrl,function(){K.authUrl=null;
if(window.AJS.Editor&&window.AJS.Editor.JiraConnector&&window.AJS.Editor.JiraConnector.servers){var O=H.findWhere(window.AJS.Editor.JiraConnector.servers,{id:K.id});
if(O){O.authUrl=null
}}M.view.$errorMessage.empty().addClass("hidden");
M.trigger("reload.data")
},function(){})
}else{window.open(K.authUrl,"com_atlassian_applinks_authentication")
}})
},validateRequiredFields:function(J,K){var L=D.trim(J.val());
if(!L||L===B.DEFAULT_OPTION_VALUE){this.toggleSiblingErrorMessage(J,true,K);
return false
}this.toggleSiblingErrorMessage(J,false);
return true
},getUserInputData:function(){return{}
},fillDataInSelect2:function(K,J){this.toggleSelect2Loading(K,true);
J.done(function(){this.toggleSelect2Loading(K,false);
this.view.$errorMessage.empty().addClass("hidden")
}.bind(this));
J.fail(function(M,L){this.handleAjaxRequestError(K,L)
}.bind(this));
return J
},_fillServersData:function(){return this.fillDataInSelect2(this.view.$servers,E.loadJiraServers()).done(function(L){this.servers=L.servers;
this.primaryServer=L.primaryServer;
if(this.servers.length===0){this.renderErrorNoAppLink();
return 
}this.fillDataSelect2(this.view.$servers,this.servers);
if(this.servers.length===1){this.view.$servers.parent().addClass("hidden");
this.removeEmptyOptionInSelect2(this.view.$servers)
}var K=this.macroOptions&&this.macroOptions.params?this.macroOptions.params.serverId:null;
var J;
if(K){J=K
}else{if(this.primaryServer){J=this.primaryServer.id
}else{J=this.view.$servers[0].id
}}this.setSelect2Value(this.view.$servers,J)
}.bind(this))
},_handleServerChanged:function(){var K=this.formData.get("selectedServer");
if(!K){this.formData.set("isValid",false);
return 
}this.formData.set("isValid",this.validateServer(K));
var J=this.formData.get("isValid");
this.toggleEnablePanel(J);
if(!J){E.resetCachingData()
}},_onSelectServerChanged:function(){var K=this.view.$servers.val();
if(!K||K===B.DEFAULT_OPTION_VALUE){this.formData.set("isValid",false)
}else{this.formData.set("isValid",true)
}var L=H.findWhere(this.servers,{id:K});
var J=this.formData.get("selectedServer");
if(J!==null&&J.id===K){this.formData.set("isValid",this.validateServer(L));
this.toggleEnablePanel(this.formData.get("isValid"))
}this.formData.set("selectedServer",L)
}});
H.extend(I.prototype,C);
return I
});